/////////////////////////////////////////////////////////////////////////
// CTaEditDraw 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include <X11/keysym.h>
#include <X11/Sunkeysym.h>
#include <Xm/CutPaste.h>

#include "TaEditDraw.h"
#include "TaEditShell.h"
#include "TaEditJPEXT.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CTaEditDraw::CTaEditDraw() :
	pVScrollMgr( NULL ),
	pHScrollMgr( NULL ),
	BackgndPixmap( NULL ),
	DrawedLineCnt_hoz( 0 ),
	ViewLineCnt( 0 ),
	IsFirstExposed( false ),
	ForcusState( false ),
	pTabString( NULL ),
	LeftColumnWidth( 0 )
{

}

CTaEditDraw::~CTaEditDraw()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// staticʥ٥ȥϥɥ
////////////////////////////////////////////////////////////////////////////

// եξ֤ѲФ륤٥ȥϥɥ
void CTaEditDraw::OnForcusEvent( Widget w, XtPointer client_data, XEvent *event, Boolean *continue_to_dispatch )
{
	CTaEditDraw *p = reinterpret_cast< CTaEditDraw* >( client_data );
	p->OnForcus( w, event, continue_to_dispatch );
}

// ܡϤФ륤٥ȥϥɥ
void CTaEditDraw::OnKeybordEvent( Widget w, XtPointer client_data, XEvent *event, Boolean *continue_to_dispatch )
{
	CTaEditDraw *p = reinterpret_cast< CTaEditDraw* >( client_data );
	p->OnKey( w, event, continue_to_dispatch );
}

// ޥФ륤٥ȥϥɥ
void CTaEditDraw::OnMouseEvent( Widget w, XtPointer client_data, XEvent *event, Boolean *continue_to_dispatch )
{
	CTaEditDraw *p = reinterpret_cast< CTaEditDraw* >( client_data );
	p->OnMouse( w, event, continue_to_dispatch );
}

// ޥݥ󥿤ΰưФ륤٥ȥϥɥ
void CTaEditDraw::OnPointerMotionEvent( Widget w, XtPointer client_data, XEvent *event, Boolean *continue_to_dispatch )
{
	CTaEditDraw *p = reinterpret_cast< CTaEditDraw* >( client_data );
	p->OnPointerMotion( w, event, continue_to_dispatch );
}

// ɥåפ줿ȤΥХå
void CTaEditDraw::OnDropCallback( Widget w, XtPointer client_data, XtPointer callback_data )
{
	CTaEditDraw *p = reinterpret_cast< CTaEditDraw* >( client_data );
	p->OnDrop( reinterpret_cast< DtDndTransferCallbackStruct* >( callback_data ) );
}

// ٥ȥϥɥ
////////////////////////////////////////////////////////////////////////////

// 
void CTaEditDraw::OnCreate( Widget argWgt, XtPointer user_data )
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	int i;

	// եȥåȤ
	const string &rFontName = pConf->RefFontName();
	fontSet = JPEXT_CreateFontSet( XtDisplay( m_Draw ), rFontName.c_str() );
	TextHeight = JPEXT_GetFontHeight( fontSet ) + pConf->GetLineGapWidth();
	TabWidth = JPEXT_GetMinWidth( fontSet ) * pConf->RefTabWidth();
	TabWidth_CM = pConf->GetTabWidthCalculationMethod();
	pTabString = &( pConf->RefTabString() );
	TextAscent = JPEXT_GetFont_ascent( fontSet ) + pConf->GetLineGapWidth();

	// եޥѤΥ٥ȥϥɥ
	XtAddEventHandler( m_Draw, FocusChangeMask, False, CTaEditDraw::OnForcusEvent, (XtPointer)this );
	XtAddEventHandler( m_Draw, KeyPressMask, False, CTaEditDraw::OnKeybordEvent, (XtPointer)this );
	XtAddEventHandler( m_Draw, ButtonPressMask, False, CTaEditDraw::OnMouseEvent, (XtPointer)this );
	XtAddEventHandler( m_Draw, ButtonReleaseMask, False, CTaEditDraw::OnMouseEvent, (XtPointer)this );
	XtAddEventHandler( m_Draw, Button1MotionMask, False, CTaEditDraw::OnMouseEvent, (XtPointer)this );
	XtAddEventHandler( m_Draw, PointerMotionMask, False, CTaEditDraw::OnPointerMotionEvent, (XtPointer)this );

	// ɥåץȤȤϿ
	Arg al[10];
	int ac = 0;
        XtCallbackRec cblist[] = { { CTaEditDraw::OnDropCallback, (XtPointer)this }, { NULL, NULL } };
	XtSetArg( al[ac], const_cast< char* >( DtNregisterChildren ), False ); ac++;
	DtDndDropRegister( m_Draw, DtDND_FILENAME_TRANSFER, XmDROP_COPY, cblist, al, ac );

	// ¦˶ΰ򻻽
	LeftColumnWidth = pConf->GetExInfoColumnWidth() * pConf->GetExInfoColumnCount();
}

// ˲
void CTaEditDraw::OnDestroy( Widget argWgt, XtPointer user_data )
{
	// եȥåȤ˴
	XFreeFontSet( XtDisplay( m_Draw ), fontSet );

	XFreePixmap( XtDisplay( m_Draw ), BackgndPixmap );
	pGCMgr = NULL;
	pCursorInfo = NULL;
	pXimMgr = NULL;

	// ɥåץȤȤƤϿ
	DtDndDropUnregister( m_Draw );
}

// ϥХå
void CTaEditDraw::OnInput( Widget argWgt, XtPointer user_data )
{
}

// ϥ٥
void CTaEditDraw::OnKey( Widget w, XEvent *event, Boolean *continue_to_dispatch )
{
	wstring wstr;
	int i;
	KeySym keysym;
	ScrollInfoPacket scrPacket;
	bool OnShift;
	bool OnCtrl;
	T_CurPos NextPos;
	CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	CErrorBool r;

	if ( NULL == pXimMgr ) return ;

	// Ϥ줿ʸ
	pXimMgr->GetInputText( reinterpret_cast< XKeyPressedEvent* >( event ), &wstr, &keysym, &OnShift, &OnCtrl );

	if ( wstr.length() <= 0 ) {

		// KeySymͤѤϤ줿Ƚꤹ
		switch ( keysym ) {
		case XK_Left:
			pCursorInfo->Left( &scrPacket, OnShift, OnCtrl );
			break;
		case XK_Up:
			pCursorInfo->Up( &scrPacket, OnShift );
			break;
		case XK_Right:
			pCursorInfo->Right( &scrPacket, OnShift, OnCtrl );
			break;
		case XK_Down:
			pCursorInfo->Down( &scrPacket, OnShift );
			break;
		case XK_Page_Up:
			pCursorInfo->PageUp( &scrPacket, OnShift );
			break;
		case XK_Page_Down:
			pCursorInfo->PageDown( &scrPacket, OnShift );
			break;
		case XK_End:
			pCursorInfo->End( &scrPacket, OnShift, OnCtrl );
			break;
		case XK_Home:
			pCursorInfo->Home( &scrPacket, OnShift, OnCtrl );
			break;
		case XK_L4:	// (Undo)˥塼UndoƤӽФ
			m_TaEditShell->OnEditUndo( NULL, NULL );
			break;
		case XK_L2:	// (Again)˥塼RedoƤӽФ
			m_TaEditShell->OnEditRedo( NULL, NULL );
			break;
		case XK_L6:	// (Copy)˥塼CopyƤӽФ
			m_TaEditShell->OnEditCopy( NULL, NULL );
			break;
		case XK_L8:	// (Paste)˥塼PasteƤӽФ
			m_TaEditShell->OnEditPaste( NULL, NULL );
			break;
		case XK_L10:	// (Cut)˥塼CutƤӽФ
			m_TaEditShell->OnEditCut( NULL, NULL );
			break;
		// case XK_L9:	// (Find)
		}

		// ɬפ˱ơ̤򥹥뤵
		if ( scrPacket.NeedXScroll ) ScrollH( scrPacket.pixX, false );
		if ( scrPacket.NeedYScroll ) ScrollV( scrPacket.lineY, false );

		// 
		// ϰϤѲ
		if ( scrPacket.IsSelCange && !scrPacket.NeedXScroll && !scrPacket.NeedYScroll )
			AfterSelRangeRedraw( scrPacket.ChangeSLine, scrPacket.ChangeELine );
		// 뤵줿
		if ( scrPacket.NeedXScroll || scrPacket.NeedYScroll )
			OnRedraw( TED_REUSE_CHAR_INFO );
		return ;
	}

	// Խ٤֤
	const T_CurPos &rCurPos = pCursorInfo->GetCurPos();
	const T_SelRange &rSelRange = pCursorInfo->GetSelRange();

	// ʣ򤵤줿֤TAB줿
	if ( rSelRange.GetSPos().GetLine() != rSelRange.GetEPos().GetLine() && wstr == L"\t" ) {
		T_SelRange NextSelRange;
		// 򤵤ƤΤФTABɲá롣
		if ( !OnShift )
			r = pDoc->MultiLineTabInsert( rSelRange, &NextPos, &NextSelRange );
		else
			r = pDoc->MultiLineTabDelete( rSelRange, &NextPos, &NextSelRange );
		pDoc->EndEdit();
		m_TaEditShell->ProcErrorMsg( r );

		// ֤Ⱥ
		// ľ˺褹뤿ᡢκϹԤʤ
		pCursorInfo->SetCurPos( NextPos, &scrPacket, NextSelRange, false );
		AfterEditRedraw( scrPacket );
		return ;
	}

	// ֥줿Ϥʸꤹ
	if ( wstr == L"\t" && NULL != pTabString )
		wstr = (*pTabString);

	// üʥξ
	if (	wstr.length() == 1 &&
		( XK_BackSpace == keysym || XK_Return == keysym || XK_Delete == keysym || XK_KP_Enter == keysym ) )
		r = pDoc->InsertSpecialCode( keysym, rCurPos, rSelRange, &NextPos );
	else
		// ̾ʸؼ
		r = pDoc->Insert( wstr, rSelRange.GetSPos(), pCursorInfo->GetSelRange(), &NextPos );
	pDoc->EndEdit();
	m_TaEditShell->ProcErrorMsg( r );

	// Ϥ줿ʬư
	// ʤƱκס
	pCursorInfo->SetCurPos( NextPos, &scrPacket, false, false );

	// 
	AfterEditRedraw( scrPacket );
}

// ɽ
void CTaEditDraw::OnExpose( Widget argWgt, XtPointer user_data )
{
	// ǽΰܤɽ򥤥٥ȤȤƽ
	if ( !IsFirstExposed ){
		m_TaEditShell->OnFirstExpose();
		OnFirstExpose();
	}

	ClearBackScreen();
	OnRedraw( TED_REUSE_CHAR_INFO );	// 
}

// ѹ
void CTaEditDraw::OnResize( Widget argWgt, XtPointer user_data )
{
	int x, y;
	int wrv;

	// ޤɽƤ⤤ʤΤʤ顢ɬפϤʤ
	if ( !IsFirstExposed ) return ;

	GetSize( &x, &y );	// ɥ
	ViewLineCnt = y / TextHeight;	// ̤ǽʹԿ򻻽

	// СΥڡ
	if ( !pVScrollMgr->SetPageSize( ViewLineCnt, &wrv ) ) {
		ScrollV( wrv, false );
		pVScrollMgr->SetPageSize( ViewLineCnt, NULL );
	}
	if ( !pHScrollMgr->SetPageSize( x, &wrv ) ) {
		ScrollH( wrv, false );
		pHScrollMgr->SetPageSize( x, NULL );
	}

	ClearBackScreen();
	OnRedraw( TED_REUSE_CHAR_INFO );	// 
	if ( NULL != pCursorInfo )
		pCursorInfo->RefleshXIMPos();	// XIMΰ֤
}

// եν
void CTaEditDraw::OnForcus( Widget w, XEvent *event, Boolean *continue_to_dispatch )
{
	XFocusChangeEvent *pf = (XFocusChangeEvent*)event;

	if ( NULL == pXimMgr ) return ;

	// XIM֥ȤˡեѲΤ
	switch ( pf->type ){
	case FocusIn:
		pXimMgr->OnForcus();
		ForcusState = true;
		break;
	case FocusOut:
		pXimMgr->ExitForcus();
		ForcusState = false;
		break;
	}
}

// ޥ
void CTaEditDraw::OnMouse( Widget w, XEvent *event, Boolean *continue_to_dispatch )
{
	enumBTN2FUNC Btn2Func = m_TaEditShell->GetConfigInfo()->GetBtn2Func();
	TA_EVENT e;
	int x;
	int y;
	XButtonEvent *pBtnE = NULL;
	XMotionEvent *pMtnE = NULL;
	bool OnShift;
	bool OnCtrl;
	Display *pDisplay = XtDisplay( w );
	Window window = XtWindow( w );
	ScrollInfoPacket scrPacket;

	switch ( event->type ) {
	case ButtonPress:
		pBtnE = &( event->xbutton );

		//  ڤܥʳΤΤФ
		switch ( pBtnE->button ) {
		case 3:	// ܥ
			OnMouse3Push( pBtnE );
			return ;
		case 4:	// 她
			OnMouseScrollUp( pBtnE );
			return ;
		case 5:	// 
			OnMouseScrollDown( pBtnE );
			return ;
		default:
			// 15ʳΥܥ󤬲줿̵뤹
			if ( pBtnE->button > 5 ) return ;
		}

		e = TAE_BUTTON1_DOWN;
		x = pBtnE->x - LeftColumnWidth;
		y = pBtnE->y;
		if ( 2 == pBtnE->button && B2F_LEFT != Btn2Func ) {
			m_TaEditShell->RaiseWindow();
			// ܥФ
			if ( Btn2Func == B2F_LEFT_CTRL ) {
				OnCtrl = true;
				OnShift = false;
			}
			else {
				OnCtrl = false;
				OnShift = true;
			}
		}
		else {
			OnShift = ( pBtnE->state & ShiftMask ) ? true : false;
			OnCtrl = ( pBtnE->state & ControlMask ) ? true : false;
		}

		// ޥΥ֤
		//XGrabPointer( pDisplay, window, True, ButtonReleaseMask | PointerMotionMask, GrabModeAsync, GrabModeSync, None, None, CurrentTime );
		break;

	case ButtonRelease:
		pBtnE = &( event->xbutton );

		// ڤܥʳΤΤǤ̵뤹
		if ( pBtnE->button > 2 ) return ;

		e = TAE_BUTTON1_UP;
		x = pBtnE->x - LeftColumnWidth;
		y = pBtnE->y;
		OnShift = ( pBtnE->state & ShiftMask ) ? true : false;
		OnCtrl = ( pBtnE->state & ControlMask ) ? true : false;

		// ޥΥ֤
		//XUngrabPointer( pDisplay, CurrentTime );
		break;

	case MotionNotify:
		pMtnE = &( event->xmotion );
		e = TAE_MOTION;
		x = pMtnE->x - LeftColumnWidth;
		y = pMtnE->y;
		OnShift = ( pMtnE->state & ShiftMask ) ? true : false;
		OnCtrl = ( pMtnE->state & ControlMask ) ? true : false;
		break;
	default:
		return ;
	}

	pMouseInfo->OnMouse( e, x, y, &scrPacket, OnShift, OnCtrl );
	if ( scrPacket.IsSelCange && !scrPacket.NeedXScroll && !scrPacket.NeedYScroll )
		OnRedraw( TED_REUSE_CHAR_INFO, scrPacket.ChangeSLine, scrPacket.ChangeELine );

	if ( scrPacket.NeedXScroll ) ScrollH( scrPacket.pixX, false );
	if ( scrPacket.NeedYScroll ) ScrollV( scrPacket.lineY, false );
	if ( scrPacket.NeedXScroll || scrPacket.NeedYScroll )
		OnRedraw( TED_REUSE_CHAR_INFO );
}

// ޥݥ󥿤ΰư
void CTaEditDraw::OnPointerMotion( Widget w, XEvent *event, Boolean *continue_to_dispatch )
{
	XMotionEvent *pMtnE = &( event->xmotion );
	pMouseInfo->OnPointerMotion( pMtnE->x, pMtnE->y );
}

// ޥܥβ
void CTaEditDraw::OnMouse2Push( XButtonPressedEvent* event )
{

}

// ޥαܥβ
void CTaEditDraw::OnMouse3Push( XButtonPressedEvent* event )
{
	// ݥåץåץ˥塼ɽ
	m_menuPopup->Popup( event );
}

// ޥΥܥˤؤΥ
void CTaEditDraw::OnMouseScrollUp( XButtonPressedEvent* event )
{
	int cy = GetTopLineNum();
	int ScrollMouseSpeed = m_TaEditShell->GetConfigInfo()->GetScrollMouseSpeed();
	cy -= ScrollMouseSpeed;
	if ( cy < 0 ) cy = 0;
	ScrollV( cy, true );
}

// ޥΥܥˤ벼ؤΥ
void CTaEditDraw::OnMouseScrollDown( XButtonPressedEvent* event )
{
	int cy = GetTopLineNum();
	int CurLineCnt = m_TaEditShell->GetDocument()->RefData().size();
	int ScrollMouseSpeed = m_TaEditShell->GetConfigInfo()->GetScrollMouseSpeed();
	int VLC = GetViewLineCnt();

	if ( CurLineCnt <= VLC )
		cy = 0;
	else {
			cy += ScrollMouseSpeed;
			if ( cy + VLC >= CurLineCnt ) cy = CurLineCnt - VLC;
	}
	ScrollV( cy, true );
}

// ޥ٥
void CTaEditDraw::OnTimer()
{
	if ( NULL != pCursorInfo )
		pCursorInfo->OnTimer();
}

// ɥåץ٥
void CTaEditDraw::OnDrop( DtDndTransferCallbackStruct *pCallbackData )
{
	DtDndProtocol prot = pCallbackData->dropData->protocol;
	if ( DtDND_TEXT_TRANSFER == prot || DtDND_BUFFER_TRANSFER == prot )
		return ;
	if ( pCallbackData->dropData->numItems <= 0 )
		return ;

	// ɥåפ줿ե򳫤
	m_TaEditShell->OpenDnDFiles(
		pCallbackData->dropData->numItems,
		pCallbackData->dropData->data.files
	);
}

// ¾Ūʥ٥
////////////////////////////////////////////////////////////////////////////

// ɥȤɤ߹ޤ줿
void CTaEditDraw::OnReadDocument()
{
	int x, y;
	CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	numTopLine = 0;
	MaxLengthPix = 0;

	pCursorInfo = NULL;
	pMouseInfo = NULL;
	pTextEditor = NULL;
	pGCMgr = NULL;
	pCursorInfo = new CCursor( this, pDoc, pXimMgr );
	if ( NULL == pCursorInfo ) goto ERR_EXIT;
	pTextEditor = new CTextEdit( this, pCursorInfo, pDoc );
	if ( NULL == pTextEditor ) goto ERR_EXIT;
	pMouseInfo = new CMouse( pCursorInfo, this, pTextEditor );
	if ( NULL == pMouseInfo ) goto ERR_EXIT;
	pGCMgr = new CGCMgr();
	if ( NULL == pGCMgr ) goto ERR_EXIT;
	if ( !pGCMgr->CreateGC( m_Draw, pConf, pDoc->GetTxtColorMgr() ) )
		return ;

	// 빽ۤؼ
	pMouseInfo->CreateCursor( m_Draw );

	GetSize( &x, &y );	// ɥ
	ViewLineCnt = y / TextHeight;

	// Сν
	pVScrollMgr->SetMin( 0 );
	pVScrollMgr->SetMax( pDoc->RefData().size() );
	pVScrollMgr->SetToMin();
	pVScrollMgr->SetMinChickSize( 1 );
	pVScrollMgr->SetPageSize( ViewLineCnt, NULL );

	pHScrollMgr->SetMin( 0 );
	pHScrollMgr->SetMax( 0 );
	pHScrollMgr->SetToMin();
	pHScrollMgr->SetMinChickSize( 1 );
	pHScrollMgr->SetPageSize( x, NULL );

	// ƥ˥塼ν֤
	m_TaEditShell->SetEnableCopyPasteMenu( false );
	m_TaEditShell->SetEnableUndoMenu( false );
	m_TaEditShell->SetEnableRedoMenu( false );

	OnRedraw( TED_REUSE_CHAR_INFO );

	// XIMΰ֤
	pCursorInfo->RefleshXIMPos();

	return ;
ERR_EXIT:
	m_TaEditShell->ShowErrorMsgBox( pConf->RefOutOfMemoryErrorMsg() );
	pCursorInfo = NULL;	// 
	pMouseInfo = NULL;
	pTextEditor = NULL;
	pGCMgr = NULL;
}

// 
void CTaEditDraw::DrawCursor( int x, int y ) const
{
	Drawable drawable = XtWindow( m_Draw );
	DrawCursor( x, y, drawable );
}
void CTaEditDraw::DrawCursor( int x, int y, Drawable drawable ) const
{
	Display *pDisplay = XtDisplay( m_Draw );
	if ( NULL == pDisplay || NULL == drawable || NULL == pGCMgr ) return ;
	x += LeftColumnWidth;
	XDrawLine( pDisplay, drawable, pGCMgr->GetCursorGC(), x, y + 1, x, y + TextHeight - 1 );
	XDrawLine( pDisplay, drawable, pGCMgr->GetCursorGC(), x - 2, y, x + 2, y );
	XDrawLine( pDisplay, drawable, pGCMgr->GetCursorGC(), x - 2, y + TextHeight, x + 2, y + TextHeight );
}

// ĥ
void CTaEditDraw::ScrollV( int y, bool NeedRedraw )
{
	pVScrollMgr->SetValue( y );
	OnScrValueChange( pVScrollMgr, y, NeedRedraw );
}

// 
void CTaEditDraw::ScrollH( int x, bool NeedRedraw )
{
	// Xޤޤ褦ScrollAtñ̤ˤʤ褦˥뤵
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	int ViewWidth = GetViewWidth();
	int ScrMin = ( 0 - pConf->GetLeftPadding() );	// 뤷Ǿ
	int ScrMax = ( MaxLengthPix - ViewWidth + pConf->GetRightPadding() );	// Ʊ
	int HScrollAt = pConf->GetHScrollAt();			// 뤹ñ
	int wx = x;

	// ǾScrMinHScrollAtñ̤˥뤷
	wx -= ScrMin;
	wx /= HScrollAt;
	if ( x >= pHScrollMgr->GetValue() )
		wx += 1;	// 뤹
	wx *= HScrollAt;
	wx += ScrMin;

	// ʥˤäơ뤬ʤʤäƤޤȤɻ
	if ( x >= pHScrollMgr->GetValue() ) {
		if ( x + ViewWidth < wx ) wx = x + ViewWidth / 2;
	}
	else {
		if ( wx + ViewWidth < x ) wx = x - ViewWidth / 2;
	}

	// ΰ֤¤䲼¤ۤƤʤȤݾ
	if ( wx < ScrMin ) wx = ScrMin;
	if ( wx >= ScrMax ) wx = ScrMax;

	pHScrollMgr->SetValue( wx );
	OnScrValueChange( pHScrollMgr, wx, NeedRedraw );
}

// ǽ˲̤ɽȤΥ٥
void CTaEditDraw::OnFirstExpose()
{
	IsFirstExposed = true;	// ǽβɽλȤ򼨤

	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	CTaEditDoc *pDoc = m_TaEditShell->GetDocument();

	// XIM֥Ȥ
	pXimMgr = new CXimMgr();
	if ( NULL == pXimMgr ) {
		m_TaEditShell->ShowErrorMsgBox( pConf->RefOutOfMemoryErrorMsg() );
		return ;
	}
	if( !pXimMgr->Initialize( m_Draw, pConf ) ) return ;
	pXimMgr->SetLeftColumnWidth( LeftColumnWidth );

	// ֥Хåեѥԥåޥåפ
	int w = WidthOfScreen( XtScreen( m_Draw ) );
	int h = HeightOfScreen( XtScreen( m_Draw ) );
	BackgndPixmap = XCreatePixmap( XtDisplay( m_Draw ), XtWindow( m_Draw ), w, h, 24 );

	// ΥɥȤۤ줿νԤ
	OnReadDocument();

	// ޥɹԤ˻ꤵ줿ץ

	const CCmdOption& rCmdOption = m_TaEditShell->GetCmdOption();

	// ư˳եλ
	if ( rCmdOption.IsEnableFileName() ) {
		m_TaEditShell->OpenFile( rCmdOption.GetFileName(), rCmdOption.GetLangType() );
	}

	// ư˥ꤹֹ
	if ( rCmdOption.IsEnableInitLine() ) {
		ScrollInfoPacket scrPacket;
		int Line = rCmdOption.GetInitLine() - pConf->GetLineNumberOrigin();
		int DocLineCnt = m_TaEditShell->GetDocument()->RefData().size();	// ɥȤιԿ

		// ꤹԤϰϤǧ
		if ( Line < 0 ) Line = 0;
		if ( Line >= DocLineCnt ) Line = DocLineCnt - 1;

		// ֤ꤹ
		pCursorInfo->SetCurPos( T_CurPos( Line, 0 ), &scrPacket, false );
		// 
		if ( scrPacket.NeedYScroll ) ScrollV( scrPacket.lineY, true );
	}
}

// 
////////////////////////////////////////////////////////////////////////////

// СΥ֥Ȥ
void CTaEditDraw::SetScrollMgr( CScrollMgr *argpH, CScrollMgr *argpV )
{
	pHScrollMgr = argpH;
	pVScrollMgr = argpV;
}

// μ
////////////////////////////////////////////////////////////////////////////

// ƥȤι⤵
int CTaEditDraw::GetTextHeight() const
{
	return TextHeight;
}
int CTaEditDraw::GetTextAscent() const
{
	return TextAscent;
}

// ʸ
int CTaEditDraw::GetCharWidth( wchar_t c, int xpos ) const
{
	// tabʳʸʤСʸ֤
	if ( c != '\t' )
		return XwcTextEscapement( fontSet, &c, 1 );

	// Tabʸξϡ˽׻ɬפ
	if ( TWCM_FIX == TabWidth_CM )
		return TabWidth;	// 
	else {
		// TabWidthñ̤ڤ夲
		int w = ( (int)ceil( (double)xpos / (double)TabWidth ) ) * TabWidth - xpos;
		if ( w <= 0 ) w = TabWidth;
		return w;
	}
}

// ־褷ƤԤιֹ
int CTaEditDraw::GetTopLineNum() const
{
	return numTopLine;
}

// ϰϤκüΥԥΰ֤
int CTaEditDraw::GetLeftPixPos() const
{
	if ( NULL != pHScrollMgr )
		return pHScrollMgr->GetValue();
	return 0;
}

// ӥ塼ǤԿ
int CTaEditDraw::GetViewLineCnt() const
{
	return ViewLineCnt;
}

// ӥ塼
int CTaEditDraw::GetViewWidth() const
{
	int w, h;
	GetSize( &w, &h );
	return w;
}

// ̤˲褷Ƥ뤫
int CTaEditDraw::GetDrawedLineCnt() const
{
	const T_LineData &rData = m_TaEditShell->GetDocument()->RefData();
	return min( (long)( rData.size() - numTopLine ), (long)ViewLineCnt );
}

// ΰΥ
void CTaEditDraw::GetSize( int *pX, int *pY ) const
{
	int ac = 0;
	Arg al[2];
	Dimension wx, wy;

	// ɥΥ
	XtSetArg( al[ac], XmNwidth, &wx ); ac++;
	XtSetArg( al[ac], XmNheight, &wy ); ac++;
	XtGetValues( m_Draw, al, ac );
	(*pX) = wx - LeftColumnWidth;
	(*pY) = wy;
}

// Խ֥Ȥ
VClsPtr< CTextEdit > CTaEditDraw::GetTextEditor()
{
	return pTextEditor;
}

// ֥Ȥ
VClsPtr< CCursor > CTaEditDraw::GetCursorInfo()
{
	return pCursorInfo;
}
const CCursor* CTaEditDraw::GetCursorInfo() const
{
	return pCursorInfo.GetPtr();
}

// եξ֤
bool CTaEditDraw::GetForcusState() const
{
	return ForcusState;
}

// 
////////////////////////////////////////////////////////////////////////////

// ̾Xɸ顢鲿ʸܤ򻻽Ф
int CTaEditDraw::XPosToCharNum( int lineY, int pixX ) const
{
	assert( NULL != this && lineY >= 0 );
	CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	const T_LineData &rl = pDoc->RefData();
	assert( lineY < rl.size() );

	// ʸˡ
	enumCHARSELTYPE CharSelType = m_TaEditShell->GetConfigInfo()->GetCharSelType();

	// ƥ졼
	T_LineDataItr_c witr = rl.begin() + lineY;
	const CDrawCharPos& rDCP = witr->GetDrawCharPos();

	// ̾Ǥκɸ򡢹Ƭ0ȤɸѴ
	const int wXPos = pixX + GetLeftPixPos();

	// ꤵ줿顢ƬǤΤȤ
	if ( wXPos <= 0 ) return 0;

	// ־ѤǤʤä顢ۤ
	if ( !witr->IsEnableDrawCharPos() )
		witr->UpdateDrawCharPos( this );

	int r = rDCP.FindPosToRowNum( (unsigned int)wXPos, CharSelType );
	return r;
}

// ̾κɸ顢ʸ֤򻻽Ф
T_CurPos CTaEditDraw::PixPosToCurPos( int pixX, int pixY ) const
{
	CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	const int DataLineCnt = pDoc->RefData().size();

	// Ԥΰ֤򻻽
	int lineY = numTopLine + ( pixY / TextHeight );
	if ( lineY < 0 ) lineY = 0;
	if ( lineY >= DataLineCnt ) lineY = DataLineCnt - 1;

	// ʸ֤򻻽
	int cposX = XPosToCharNum( lineY, pixX );

	return T_CurPos( lineY, cposX );
}

// С줿
void CTaEditDraw::OnScrValueChange( const CScrollMgr *argpMgr, int value, bool NeedRedraw )
{
	if ( argpMgr != pVScrollMgr && argpMgr != pHScrollMgr && !IsFirstExposed )
		return ;
	if ( argpMgr == pVScrollMgr ) numTopLine = value;

	if ( NeedRedraw ) OnRedraw( TED_REUSE_CHAR_INFO );
	pCursorInfo->RefleshXIMPos();	// XIMΰ֤

}

// ̤򥯥ꥢ
void CTaEditDraw::ClearBackScreen()
{
	XRectangle rect;
	Display *pDisplay = XtDisplay( m_Draw );
	Drawable drawable = BackgndPixmap;
	int w, h;

	// ֤äƤʤСʤ
	if ( NULL == pDisplay || NULL == drawable || NULL == pGCMgr )
		return ;

	GetSize( &w, &h );	// ̤Υ
	w += LeftColumnWidth;	// GetSizeǼϡ餫LeftColumnWidthƤ
	XFillRectangle( pDisplay, drawable, pGCMgr->GetClearGC(), 0, 0, w, h );

	// ѤߤιԤ򼨤򥯥ꥢ
	vDrewLD.clear();
}

// 
void CTaEditDraw::OnRedraw( enumREDRAWTYPE type )
{
	OnRedraw( type, numTopLine, numTopLine + GetDrawedLineCnt() );
}

// ϰϤꤷơ
void CTaEditDraw::OnRedraw( enumREDRAWTYPE type, int argSLine, int argELine )
{
	CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	const T_LineData &rData = pDoc->RefData();
	int i, w, h;
	XRectangle rect;
	Display *pDisplay = XtDisplay( m_Draw );
	Drawable drawable = BackgndPixmap;
	int wMaxLineLength = 0;	// 褷ǡǤĹԤΥԥ
	int ExInfoColW = pConf->GetExInfoColumnWidth();
	int ExInfoColCnt = pConf->GetExInfoColumnCount();

	// ֤äƤʤСʤ
	if ( NULL == pDisplay || NULL == drawable ) return ;
	if ( NULL == fontSet || NULL == pGCMgr ) return ;

	// ϰϤǧĴ
	if ( argSLine < numTopLine ) argSLine = numTopLine;
	if ( argELine > numTopLine + ViewLineCnt ) argELine = numTopLine + ViewLineCnt;

	const int RedrawLineCnt = argELine - argSLine;	// 褹Կ
	const int wSL = argSLine - numTopLine;			// ̾Ǥ賫ϰ
	const int wEL = argELine - numTopLine;			// ̾Ǥ轪λ
	const int wRealViewLineCnt = GetDrawedLineCnt();	// ̤ǽʹԿ
	const int DrawPosX = GetLeftPixPos();			// 

	T_LineDataItr_c itr = rData.begin() + argSLine;
	GetSize( &w, &h );		// ̤Υ
	w += LeftColumnWidth;	// GetSizeǼϡLeftColumnWidthƤ

	// ѤˡvDrewLDΥݾڤ
	vDrewLD.resize( ViewLineCnt, CDrewLineCash() );

	// ʸ
	for ( i = wSL; i < wEL && numTopLine + i < rData.size(); i++, itr++ ) {

		// typeTED_LINE_BASEǺ褹ɬפʤϥåפ
		if ( TED_LINE_BASE == type && vDrewLD[ i ] == CDrewLineCash( (*itr) ) )
			continue;

		// ־ѤǤʤϺƹۤ
		if ( !itr->IsEnableDrawCharPos() )
			itr->UpdateDrawCharPos( this );

		// ǤĹԤΥԥ줿ݤ
		if ( itr->GetDrawCharPos().GetRightXPos() > wMaxLineLength )
			wMaxLineLength = itr->GetDrawCharPos().GetRightXPos();

		// 
		XFillRectangle( pDisplay, drawable, pGCMgr->GetClearGC(),
			0, i * TextHeight, w, TextHeight );
		DrawString_ReuseCharInfo( pDisplay, drawable, -DrawPosX,
			TextHeight * i, itr, i + numTopLine, w );

		// ¦Υ褹
		if ( LeftColumnWidth > 0 )
			DrawLeftColumn( pDisplay, drawable, TextHeight * i, itr, ExInfoColW, ExInfoColCnt );

		// 褷Ԥɤ줫¸
		vDrewLD[ i ] = CDrewLineCash( (*itr) );
	}

	if ( DrawedLineCnt_hoz > wRealViewLineCnt ) {
		// 褵줿Ԥϡä٤ʬ˻ĤäƤʸõ
		XFillRectangle( pDisplay, drawable, pGCMgr->GetClearGC(),
			0, wRealViewLineCnt * TextHeight,
			w, ( DrawedLineCnt_hoz - wRealViewLineCnt ) * TextHeight );

		// äȤ褵ƤԤˡ̤õ줿ȤϿ
		for ( i = wRealViewLineCnt; i < DrawedLineCnt_hoz; i++ )
			vDrewLD[ i ] = CDrewLineCash();
	}

	// ¦ζΰ褹
	if ( pConf->GetDrawSeparatorLine() )
		XDrawLine( pDisplay, BackgndPixmap, pGCMgr->GetLeftColumnSeparatorGC(),
			LeftColumnWidth, 0, LeftColumnWidth, h );

	// ԥåޥåפƤɥåȤɽ
	XCopyArea( pDisplay, BackgndPixmap, XtWindow( m_Draw ), pGCMgr->GetClearGC(), 0, 0, w, h, 0, 0 );

	// ˺褵줿ȤΤ
	pCursorInfo->OnRedraw();

	// Сκͤꤹ
	if ( MaxLengthPix < wMaxLineLength ) {
		MaxLengthPix = wMaxLineLength;
		pHScrollMgr->SetMax( MaxLengthPix );
	}

	// ̤褷Կݻ
	DrawedLineCnt_hoz = wRealViewLineCnt;
}

// ʸ褹
// XPos,YPos 褹
// XPosͿ줿ϡιԤκü褵ʤ
// Ϳ줿ϡιԤκü˶
// LineNum ̾βܤιԤ
void CTaEditDraw::DrawString_ReuseCharInfo(
	Display *pDisplay,
	Drawable argDrawable,
	int XPos,
	int YPos,
	const T_LineDataItr_c &rItr,
	int LineNum,
	int ViewWidth ) const
{
	int s, e;	// 褹ϰϡʸ
	int wXPos;		// 򳫻Ϥ֡ʥԥ
	const wstring &rStr = rItr->getString();	// 褹ʸ
	const CDrawCharPos &rDPos = rItr->GetDrawCharPos();

	// 򳫻Ϥ֡ʸˤ
	if ( XPos < 0 )
		s = rDPos.FindPosToRowNum( abs( XPos ), CST_LEFT );
	else {
		// ˶褹ϡüƬʸ褹롣
		s = rDPos.FindPosToRowNum( 0, CST_LEFT );
	}

	// 򳫻Ϥ֡ʥԥˤ
	if ( rDPos.GetCharCnt() > s )
		wXPos = rDPos.GetCharPos( s ) + XPos + LeftColumnWidth;
	else
		wXPos = rDPos.GetRightXPos() + XPos + LeftColumnWidth;

	// λ֡ʸˤ
	e = rDPos.FindPosToRowNum( ViewWidth - XPos, CST_RIGHT );

	DrawString( pDisplay, argDrawable, wXPos, YPos, rItr, s, e - s, LineNum );
}

// ̤λꤵ줿֤ʸ
void CTaEditDraw::DrawString(
	Display *pDisplay,
	Drawable argDrawable,
	int XPos,
	int YPos,
	const T_LineDataItr_c &rItr,
	int StrSPos,
	int StrCnt,
	int LineNum ) const
{
	unsigned int wXPos = XPos;
	GC hGC;		// GC¸
	bool hIsTab;	// ʸ֤äݤ
	int hIdx;	// 褹Ȥϰ֤ȤʤʸΥǥå
	bool hIsSel;
	int i;
	const wstring &rStr = rItr->getString();
	bool wIsSel;	// GCݤˡ򤵤Ƥ뤫ݤöݻѿ
	unsigned int wWidth;	// ʸ(Pixcel)ݻѿ
	const CDrawCharPos& rDrawCharPos = rItr->GetDrawCharPos();

	// 褹ʸʤнλ
	if ( StrCnt <= 0 ) return ;
	if ( rStr.length() <= StrSPos || rStr.length() < StrSPos + StrCnt ) return ;

	// ֡󥿥֤ޤGCѲ뤿Ӥ褹
	wIsSel = pCursorInfo->IsCharSelected( T_CurPos( LineNum, StrSPos ) );
	hIsTab = ( (*rItr)[ StrSPos ].moji == L'\t' );
	hGC = pGCMgr->GetTextDrawGC( (*rItr)[ StrSPos ].iro, wIsSel, hIsTab );
	hIdx = StrSPos;
	hIsSel = wIsSel;
	wWidth = 0;

	for ( i = StrSPos; i < StrSPos + StrCnt; i++ ) {

		// rStr[i]褹Τ˻ѤGC
		wIsSel = pCursorInfo->IsCharSelected( T_CurPos( LineNum, i ) );
		GC wGC = pGCMgr->GetTextDrawGC( (*rItr)[ i ].iro, wIsSel, ( rStr[i] == L'\t' ) );

		if ( hGC != wGC || hIsTab != ( rStr[i] == L'\t' ) ) {
			// ѤäᡢʸϤ
			if ( hIsTab )
				XFillRectangle( pDisplay, argDrawable, hGC, wXPos, YPos, wWidth, TextHeight );
			else
				XwcDrawImageString( pDisplay, argDrawable, fontSet, hGC, wXPos, YPos + TextAscent, rStr.begin() + hIdx, i - hIdx );
				// wXPos += XwcTextEscapement( fontSet, rStr.begin() + hIdx, i - hIdx );
			// ߤξ¸
			hGC = wGC;
			hIsTab = ( rStr[i] == L'\t' );
			hIdx = i;
			hIsSel = wIsSel;
			wXPos += wWidth;	// 褹٤֤򻻽Ф
			wWidth = 0;
		}

		// ʸ
		wWidth += rDrawCharPos.GetCharWidth( i );
	}

	// ԤκǸʬ
	if ( hIsTab )
		XFillRectangle( pDisplay, argDrawable, hGC, wXPos, YPos, wWidth, TextHeight );
	else
		XwcDrawImageString( pDisplay, argDrawable, fontSet, hGC, wXPos, YPos + TextAscent, rStr.begin() + hIdx, i - hIdx );
}

// ¦Υ
void CTaEditDraw::DrawLeftColumn(
	Display *pDisplay,
	Drawable argDrawable,
	int YPos,
	const T_LineDataItr_c &rItr,
	int ColW,
	int ColCnt ) const
{
	int i;

	// פʤΤõ
	XFillRectangle( pDisplay, argDrawable, pGCMgr->GetClearGC(), 0, YPos,
		LeftColumnWidth, TextHeight );

	// ƥ褹
	for ( i = 0; i < ColCnt; i++ ) {
		if ( rItr->GetExtendInfo( i ) )
			XFillRectangle( pDisplay, argDrawable, pGCMgr->GetExInfoColumnGC(i), ColW * i, YPos, ColW, TextHeight );
	}
}

// ԽκԤ
void CTaEditDraw::AfterEditRedraw( const ScrollInfoPacket &rScrPacket )
{
	CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	ScrollInfoPacket wScrPacket = rScrPacket;

	// β֤MaxLengthPixۤϡMaxLengthPix򹹿
	if ( MaxLengthPix < pCursorInfo->GetCurPosX() ) {
		MaxLengthPix = pCursorInfo->GetCurPosX();
		pHScrollMgr->SetMax( MaxLengthPix );
	}
	if ( wScrPacket.NeedXScroll ) ScrollH( wScrPacket.pixX, false );

	const int AfterLineCnt = pDoc->RefData().size();	// ԽιԿ

	// ̤ͭäơԿäϡ˥뤹ɬפ
	if ( ( pVScrollMgr->GetValue() + ViewLineCnt > AfterLineCnt ) ) {
		int wScrCnt = AfterLineCnt - ViewLineCnt;	// ɤ˥뤹뤫
		if ( wScrCnt < 0 ) wScrCnt = 0;
		ScrollV( wScrCnt, false );
		// wScrPacket.NeedYScroll = false;
	}

	// ͤ
	pVScrollMgr->SetMax( AfterLineCnt );

	// ΰưȼ
	if ( wScrPacket.NeedYScroll ) ScrollV( wScrPacket.lineY, false );

	// ɬפ˱
	if ( rScrPacket.NeedYScroll || rScrPacket.NeedXScroll )
		OnRedraw( TED_REUSE_CHAR_INFO );
	else
		OnRedraw( TED_LINE_BASE );
}

// ϰϤѲκԤ
void CTaEditDraw::AfterSelRangeRedraw( int argSLine, int argELine )
{
	OnRedraw( TED_REUSE_CHAR_INFO, argSLine, argELine );
}
