////////////////////////////////////////////////////////////////////////////
// CTaEditFindDlg 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "TaEditFindDlg.h"
#include "TaEditShell.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CTaEditFindDlg::CTaEditFindDlg()
{

}

CTaEditFindDlg::~CTaEditFindDlg()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// 
void CTaEditFindDlg::OnCreate( Widget argWgt, XtPointer user_data )
{

}

// Ĥץܥβ
void CTaEditFindDlg::OnFindExit( Widget argWgt, XtPointer user_data )
{
	XtUnmanageChild( m_FindDlg );
}

// ִץܥβ
void CTaEditFindDlg::OnFindAllReplace( Widget argWgt, XtPointer user_data )
{
	wstring PatternStr;
	wstring ReplaceStr;

	// ѥڤִꤹʸ
	GetPatternStr( &PatternStr );
	GetReplaceStr( &ReplaceStr );

	// ѥϤƤʤСԤʤ
	if ( PatternStr.length() <= 0 ) return ;

	// ִ
	GetTextEditorObj()->ReplaceAll( PatternStr, ReplaceStr );	
}

// ִץܥβ
void CTaEditFindDlg::OnFindReplace( Widget argWgt, XtPointer user_data )
{
	wstring ReplaceStr;

	// ִꤹʸ
	GetReplaceStr( &ReplaceStr );

	// ִ
	GetTextEditorObj()->PasteText( ReplaceStr, true );
}

// ָץܥβ
void CTaEditFindDlg::OnFindNext( Widget argWgt, XtPointer user_data )
{
	wstring PatternStr;

	// ѥʸ
	GetPatternStr( &PatternStr );

	// ѥϤƤʤСԤʤ
	if ( PatternStr.length() <= 0 ) return ;

	// 
	GetTextEditorObj()->FindText( PatternStr );
}

// ɽ
void CTaEditFindDlg::ShowDlg()
{
	XtManageChild( m_FindDlg );
}

// ˡ
enumFINDTYPE CTaEditFindDlg::GetFindType() const
{
	// ñץȥܥ
	if ( XmToggleButtonGetState( m_FindTypeNormal ) )
		return FINDTYPE_NORMAL;

	// ֥磻ɥɡץȥܥ
	if ( XmToggleButtonGetState( m_FindTypeWildcard ) )
		return FINDTYPE_WILDCARD;

	// ɽץȥܥ
	if ( XmToggleButtonGetState( m_FindTypeRegex ) )
		return FINDTYPE_REGEX;

	// Ȥꤢ
	return FINDTYPE_NORMAL;
}

// оݤʸ
void CTaEditFindDlg::GetPatternStr( wstring *pStr ) const
{
	assert( NULL != this && NULL != pStr && NULL != m_FindPatternStr );

	// Ϥ줿ʸ
	wchar_t *pIptStr = XmTextFieldGetStringWcs( m_FindPatternStr );

	// ȥܥˤ碌ʸù
	switch ( GetFindType() ) {
	case FINDTYPE_NORMAL:
		// Ϥ줿ʸʸ򸡺ɽѴ
		ConvertNormalPtnToRegexPtn( pIptStr, pStr );
		break;

	case FINDTYPE_WILDCARD:
		// 磻ɥɤѤ줿ʸ򸡺ɽѴ
		ConvertWildcardPtnToRegexPtn( pIptStr, pStr );
		break;

	case FINDTYPE_REGEX:
		// ʸ򤽤Τޤɽȸʤ
		(*pStr) = pIptStr;
	}

	XtFree( reinterpret_cast< char* >( pIptStr ) );
}

// ִʸ
void CTaEditFindDlg::GetReplaceStr( wstring *pStr ) const
{
	assert( NULL != this && NULL != pStr && NULL != m_FindReplaceStr );
	wchar_t *str = XmTextFieldGetStringWcs( m_FindReplaceStr );
	(*pStr) = str;
	XtFree( reinterpret_cast< char* >( str ) );
}

// ƥԽ֥Ȥ
VClsPtr< CTextEdit > CTaEditFindDlg::GetTextEditorObj() const
{
	assert( NULL != this && NULL != m_TaEditShell );
	return m_TaEditShell->GetTextEditor();
}

// Ϥ줿оʸɽѴ
void CTaEditFindDlg::ConvertNormalPtnToRegexPtn( const wchar_t *pIptPtn, wstring *pRegexPtn ) const
{
	assert( NULL != pIptPtn && NULL != pRegexPtn );

	// Ϥ줿ʸˡREGEX_SPECIALCODE˴ޤޤü쵭椬ѤƤ顢
	// ץ󥹤
	while ( (*pIptPtn) ) {
		if ( L'\\' == (*pIptPtn) || wcschr( REGEX_SPECIALCODE, (*pIptPtn) ) )
			(*pRegexPtn) += L'\\';
		(*pRegexPtn) += (*pIptPtn);
		pIptPtn++;
	}
}

// Ϥ줿磻ɥɤˤ븡ѥ򡢤ƱɽѴ롣
void CTaEditFindDlg::ConvertWildcardPtnToRegexPtn( const wchar_t *pIptPtn, wstring *pRegexPtn ) const
{
	assert( NULL != pIptPtn && NULL != pRegexPtn );

	// Ϥ줿ʸ*ޤޤƤ{.}ˡ
	// ?ޤޤƤ.ִ롣
	// \\\\ˡ\**ˡ\??֤롣

	while ( (*pIptPtn) ) {
		switch ( (*pIptPtn) ) {
		case L'*':
			(*pRegexPtn) += L"{.}";
			break;
		case L'?':
			(*pRegexPtn) += L".";
			break;
		case '\\':
			pIptPtn++;
			if ( NULL == (*pIptPtn) ) {
				// \ǽäƤ롣Ȥꤢ\\Ϥ
				(*pRegexPtn) += L"\\\\";
				return ;
			}
			if ( L'\\' == (*pIptPtn)  )
				(*pRegexPtn) += L"\\\\";
			else
				(*pRegexPtn) += (*pIptPtn);
			break;
		default:
			if ( wcschr( REGEX_SPECIALCODE, (*pIptPtn) ) )
				(*pRegexPtn) += L'\\';
			(*pRegexPtn) += (*pIptPtn);
		}
		pIptPtn++;
	}
	
}


