////////////////////////////////////////////////////////////////////////////////
// TextMatchLib.h
// SRegexǸԤ˻Ѥ륯饹
////////////////////////////////////////////////////////////////////////////////

#if !defined( TEXTMATCHLIB_H_INCLUDED_ )
#define TEXTMATCHLIB_H_INCLUDED_

// SRegexT_Text˻ꤹ뵿ݥ

// ʲεǽ롣
// 1.֥󥯥
// 2.ɥ쥹ȱ黻
// 3.黻
// 4.㥹
// 5.ԥɤμ
// 6.ƥNULL֤
// 7.ޥå󥰤η̤Τ뤿Ρ֤δ

class tagPseudPtr
{
public:
	tagPseudPtr() : pLineData( NULL ){};
		
	tagPseudPtr( const T_LineData *argLineData, T_LineDataItr_c argItr, T_CurPos argCurPos ) :
		pLineData( argLineData ),
		itr( argItr ),
		CurPos( argCurPos )
	{
	};

	tagPseudPtr( const tagPseudPtr &r ) : 
		pLineData( r.pLineData ),
		itr( r.itr ),
		CurPos( r.CurPos )
	{
	};

	const tagPseudPtr& operator ++()
	{
		assert( NULL != pLineData );

		// ʤ뤳ȤǤʤϡλ
		if ( itr == pLineData->end() ) return (*this);

		if ( CurPos.GetCPos() < itr->length() ) {
			// Ʊμʸ
			CurPos.IncrCPos();

			// ʸذư̡ǸιԤ+1ݥȤ硢
			// ˤʸ¸ߤʤᡢŪ˥ꥹȤendݥȤ롣
			if ( !( CurPos.GetCPos() == itr->length() && CurPos.GetLine() == pLineData->size() - 1 ) ) {
				return (*this);
			}
		}

		// ιԤ
		itr++;
		CurPos.IncrLine();
		CurPos.SetCPos( 0 );
		return (*this);
	};

	wchar_t operator *()
	{
		assert( NULL != pLineData );

		// ݥȤƤϡNULL֤
		if ( itr == pLineData->end() ) return NULL;

		// Ԥ+1ݥȤƤ
		if ( CurPos.GetCPos() == itr->length() ) {
			// ιԤ¸ߤϡԥɤ֤
			if ( CurPos.GetLine() < pLineData->size() - 1 )
				return L'\n';
			else
				return NULL;	// ʸ¸ߤʤ
		}

		// ʸ֤
		return itr->getString()[ CurPos.GetCPos() ];
	};

	// 
	bool operator ==( const tagPseudPtr &r ) const
	{
		assert( NULL != pLineData );
		return ( pLineData == r.pLineData && CurPos == r.CurPos );
	};

	// ֤μ
	T_CurPos GetCurPos() const
	{
		assert( NULL != pLineData );
		return CurPos;
	};

protected:
	const T_LineData *pLineData;
	T_LineDataItr_c itr;
	T_CurPos CurPos;
};

#endif // TEXTMATCHLIB_H_INCLUDED_
