////////////////////////////////////////////////////////////////////////////
// CTxtColorMgr 饹Υ󥿥ե
//
////////////////////////////////////////////////////////////////////////////

#if !defined( TXTCOLORMGR_H_INCLUDED_ )
#define TXTCOLORMGR_H_INCLUDED_

#include "../LineData.h"
#include "../TaEdit_std.h"
#include "../ConfigInfo.h"
#include "LangConfig.h"

namespace NLangExt {

class CTxtColorMgr
{
public:
	CTxtColorMgr(){};
	virtual ~CTxtColorMgr() {};

	// 
	virtual bool Initialize( VClsPtr< CConfigInfo > pConf ) = 0;

	// Ѥ뿧ο
	virtual int GetColorCount() const = 0;

	// 
	virtual Pixel GetColor( int idx ) const = 0;

	// 󤫤鿧ΥǥåѴ
	virtual int TranseToIdx( unsigned char c ) const = 0;

	// ֤ǹ
	virtual void InitiUpdate( T_LineData &rData ) const = 0;

	// ʸιȼι
	virtual void Update( T_LineData &rData, const T_SelRange &range ) const = 0;

	// ॳɤ
	virtual enumLANGTYPE GetLangType() const = 0;
};

// ֤ǤιԤ
template< typename T_ >
void InitUpdateColorFunc( const T_ &rHM, T_LineData &rData )
{
	CLinePseudoPtr_txt pSTxt( &rData );
	CLinePseudoPtr_txt pETxt( &rData );
	CLinePseudoPtr_clr pSCB( &rData );
	pETxt.SetEnd();
	rHM.FullUpdate( pSTxt, pETxt, pSCB );
}

// ʸιȼι
template< typename T_ >
void UpdateColorFunc( const T_ &rHM, T_LineData &rData, const T_SelRange &range )
{
	CLinePseudoPtr_txt pSTxt( &rData );
	CLinePseudoPtr_txt pETxt( &rData );
	CLinePseudoPtr_txt pUpdateSTxt( &rData );
	CLinePseudoPtr_txt pUpdateETxt( &rData );
	CLinePseudoPtr_clr pUpdateSPosCB( &rData );
	pETxt.SetEnd();
	pUpdateSTxt.SetPos( range.GetSPos() );
	pUpdateETxt.SetPos( range.GetEPos() );
	pUpdateSPosCB.SetPos( range.GetSPos() );
	rHM.UpdateWidthChange( pSTxt, pETxt, pUpdateSTxt, pUpdateSPosCB, pUpdateETxt );
}

}; // NLangExt

#endif // TXTCOLORMGR_H_INCLUDED_

