/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.csvio.builder;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.talisman.csvio.CsvIOSetting;
import jp.sourceforge.talisman.csvio.EscapeMode;
import jp.sourceforge.talisman.csvio.builder.AbstractCsvLineBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NoQuoteCsvLineBuilder
extends AbstractCsvLineBuilder {
    public NoQuoteCsvLineBuilder() {
    }

    public NoQuoteCsvLineBuilder(CsvIOSetting setting) {
        super(setting);
    }

    @Override
    protected List<String> splitToTokens(String line) {
        String[] tokens = line.split(",");
        CsvIOSetting setting = this.getSetting();
        ArrayList<String> list = new ArrayList<String>(tokens.length);
        String[] stringArray = tokens;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String token = stringArray[n];
            list.add(this.normalize(token, setting));
            ++n;
        }
        return list;
    }

    private String normalize(String token, CsvIOSetting setting) {
        EscapeMode mode = setting.getEscapeMode();
        char qb = setting.getQuoteBegin();
        char qe = setting.getQuoteEnd();
        if (mode == EscapeMode.DOUBLE_CHARACTER) {
            token.replaceAll("" + qb + qb, String.valueOf(qb));
            token.replaceAll("" + qe + qe, String.valueOf(qe));
        } else {
            char ec = setting.getEscapeCharacter();
            token.replaceAll("" + ec + qb, String.valueOf(qb));
            token.replaceAll("" + ec + qe, String.valueOf(qe));
            token.replaceAll("" + ec + ec, String.valueOf(ec));
        }
        return token;
    }
}

