package jp.sourceforge.talisman.csvio;

/*
 * $id$
 */

import static org.junit.Assert.assertEquals;

import java.io.BufferedReader;
import java.io.StringReader;

import org.junit.Test;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 4 $ $Date: 2007-08-11 10:41:41 +0900 (Sat, 11 Aug 2007) $
 */
public class CsvParserEscapeTest{
    @Test
    public void escapeBasicTestOfDoubleCharacter() throws Exception{
        BufferedReader in = new BufferedReader(new StringReader(
            "1,2,3,\"4,\"\"5\"\r\n" +
            "6,7,8\"\",\"\"9\r\n" + 
            "10,11,12")
        );
        CsvParser parser = new CsvParser(in);
        CsvIOSetting setting = parser.getSetting();
        setting.setEscapeMode(EscapeMode.DOUBLE_CHARACTER);
        parser.setSetting(setting);

        CsvLine[] lines = parser.getAllLines();

        assertEquals(3, lines.length);

        assertEquals("1", lines[0].getValue(0));
        assertEquals("2", lines[0].getValue(1));
        assertEquals("3", lines[0].getValue(2));
        assertEquals("4,\"5", lines[0].getValue(3));

        assertEquals("6", lines[1].getValue(0));
        assertEquals("7", lines[1].getValue(1));
        assertEquals("8\"", lines[1].getValue(2));
        assertEquals("\"9", lines[1].getValue(3));

        assertEquals("10", lines[2].getValue(0));
        assertEquals("11", lines[2].getValue(1));
        assertEquals("12", lines[2].getValue(2));
    }

    @Test
    public void escapeBasicTestEscapeCharacter() throws Exception{
        BufferedReader in = new BufferedReader(new StringReader(
            "1,2,3,\"4,\\\"5\"\r\n" +
            "6,7,8,9\r\n" + 
            "10,\"11,\\\"12\"")
        );
        CsvParser parser = new CsvParser(in);
        CsvIOSetting setting = parser.getSetting();
        setting.setEscapeMode(EscapeMode.ESCAPE_CHARACTER);
        parser.setSetting(setting);

        CsvLine[] lines = parser.getAllLines();

        assertEquals(3, lines.length);

        assertEquals("1", lines[0].getValue(0));
        assertEquals("2", lines[0].getValue(1));
        assertEquals("3", lines[0].getValue(2));
        assertEquals("4,\"5", lines[0].getValue(3));

        assertEquals("6", lines[1].getValue(0));
        assertEquals("7", lines[1].getValue(1));
        assertEquals("8", lines[1].getValue(2));
        assertEquals("9", lines[1].getValue(3));

        assertEquals("10", lines[2].getValue(0));
        assertEquals("11,\"12", lines[2].getValue(1));
    }
}
