package jp.sourceforge.talisman.csvio.translator;

/*
 * $Id: TransposeTest.java 7 2007-08-11 02:25:21Z tama3 $
 */

import static org.junit.Assert.assertEquals;

import jp.sourceforge.talisman.csvio.CsvLine;

import org.junit.Before;
import org.junit.Test;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 7 $ $Date: 2007-08-11 11:25:21 +0900 (Sat, 11 Aug 2007) $
 */
public class TransposeTest{
    private CsvLine[] lines;

    @Test
    public void transposeBasicTest(){
        Transpose transpose = new Transpose();
        CsvLine[] transposed = transpose.translate(lines);

        assertEquals(4, transposed.length);
        assertEquals("00", lines[0].getValue(0));
        assertEquals("01", lines[0].getValue(1));
        assertEquals("02", lines[0].getValue(2));
        assertEquals("03", lines[0].getValue(3));

        assertEquals("10", lines[1].getValue(0));
        assertEquals("11", lines[1].getValue(1));
        assertEquals("12", lines[1].getValue(2));
        assertEquals("13", lines[1].getValue(3));

        assertEquals("20", lines[2].getValue(0));
        assertEquals("21", lines[2].getValue(1));
        assertEquals("22", lines[2].getValue(2));
        assertEquals("23", lines[2].getValue(3));

        assertEquals("30", lines[3].getValue(0));
        assertEquals("31", lines[3].getValue(1));
        assertEquals("32", lines[3].getValue(2));
        assertEquals("33", lines[3].getValue(3));

        assertEquals("40", lines[4].getValue(0));
        assertEquals("41", lines[4].getValue(1));
        assertEquals("42", lines[4].getValue(2));
        assertEquals("43", lines[4].getValue(3));
    }

    @Before
    public void createTranslateSource(){
        lines = new CsvLine[5];
        lines[0] = new CsvLine();
        lines[0].addValue("00");
        lines[0].addValue("01");
        lines[0].addValue("02");
        lines[0].addValue("03");

        lines[1] = new CsvLine();
        lines[1].addValue("10");
        lines[1].addValue("11");
        lines[1].addValue("12");
        lines[1].addValue("13");

        lines[2] = new CsvLine();
        lines[2].addValue("20");
        lines[2].addValue("21");
        lines[2].addValue("22");
        lines[2].addValue("23");

        lines[3] = new CsvLine();
        lines[3].addValue("30");
        lines[3].addValue("31");
        lines[3].addValue("32");
        lines[3].addValue("33");

        lines[4] = new CsvLine();
        lines[4].addValue("40");
        lines[4].addValue("41");
        lines[4].addValue("42");
        lines[4].addValue("43");
    }
}
