module TapKit

	# Tracks changes for objects.
	class ObserverCenter
		attr_reader :suppress_count

		def initialize
			@observers = Hash.new []
			@omni_observers = []
			@suppress_count = 0
			@enable = true
		end

		def observers( object )
			@observers[object]
		end

		def add( observer, object )
			@observers[object] << observer
		end

		def add_omni( observer )
			@omni_observers = []
		end

		def remove( observer, object )
			@observers[object].delete observer
		end

		def remove( observer )
			@omni_observers.delete observer
		end

		def notify_will_change( object )
			if enable? then
				observers = []
				observers.concat @omni_observers
				observers.concat @observers[object]
				observers.each do |observer|
					observer.object_will_change object
				end
			else
				@suppress_count += 1
			end
		end

		def suppress
			@enable = false
		end

		def enable
			@enable = true
		end

		def enable?
			@enable
		end
	end

end
