class TestCompoundKeyEntity < Test::Unit::TestCase
	include TapKit

	def setup
		#@app = Application.new MODEL_FOR_COMPOUND_KEY
		@app = Application.new(MODEL_FOR_COMPOUND_KEY, '.')
		@ec  = @app.create_editing_context
		# @app.log_options[:sql] = true
	end

	def test_01_insert
		employee = @ec.create 'Employee'
		company  = @ec.create 'Company'
		project  = @ec.create 'Project'

		# regists new records to get primary key values
		test = "test #{Time.now.to_s}"

		employee['name']    = test
		company['name']     = test
		project['name']     = test
		project['summary']  = test
		employee['company'] = company
		@ec.save

		# next, regists a new record having multiple primary keys
		# sets primary key values directly
		emp_proj = @ec.create 'EmployeeProject'
		emp_proj['employee_id'] = employee['employee_id']
		emp_proj['project_id']  = project['project_id']
		emp_proj['employee'] = employee
		emp_proj['project']  = project
		@ec.save

		qualifier = Qualifier.format("(employee.name == %@) and (project.name == %@)",
			[test, test])
		fetchspec = FetchSpec.new('EmployeeProject', qualifier)
		fetchspec.limit = 10
		objects = @ec.fetch fetchspec

		assert_equal(false, objects.empty?)
	end

	def test_02_fetch
		fetchspec = FetchSpec.new 'EmployeeProject'
		fetchspec.limit = 10
		objects = @ec.fetch fetchspec

		assert_equal(false, objects.empty?)
	end

	def test_03_update
		# @app.log_options[:sql] = true
		fetchspec = FetchSpec.new 'EmployeeProject'
		fetchspec.limit = 1
		objects = @ec.fetch fetchspec
		object  = objects.first

		original1 = object['employee_id']
		original2 = object['project_id']

		# change
		test = rand 10000
		object['employee_id'] = test
		object['project_id'] = test
		@ec.save

		# check
		qualifier = Qualifier.format("(employee_id == %@) and (project_id == %@)",
			[test, test])
		fetchspec = FetchSpec.new('EmployeeProject', qualifier)
		fetchspec.limit = 1
		fetchspec.refresh = true
		objects = @ec.fetch fetchspec
		assert_equal(false, objects.empty?)
	end

	def test_04_delete
		# setup
		fetchspec = FetchSpec.new 'EmployeeProject'
		fetchspec.limit = 1
		objects = @ec.fetch fetchspec
		object  = objects.first

		employee_id = object['employee_id']
		project_id  = object['project_id']

		# delete
		@ec.delete object
		@ec.save

		# check
		q = Qualifier.format("(employee_id == %@) and (project_id == %@)",
			[employee_id, project_id])
		fetchspec = FetchSpec.new('EmployeeProject', q)
		fetchspec.limit = 1
		objects = @ec.fetch fetchspec
		assert objects.empty?
	end

end
