# propagate_delete

class TestClassDescription < Test::Unit::TestCase
	include TapKit

	def setup
		@app    = Application.new MODELS
		@ec     = @app.create_editing_context
		@entity = @app.model_group.entity 'Book'
		@cd     = @entity.class_description

		@entity2 = @app.model_group.entity 'Publisher'
		@cd2     = @entity2.class_description
	end


	# property keys

	def test_attribute_keys
		all_keys = ['book_id', 'title', 'publisher_id']
		keys     = ['title']

		assert_equal(all_keys, @cd.all_attribute_keys)
		assert_equal(keys, @cd.attribute_keys)
	end

	def test_to_one_keys
		all_keys = ['publisher']
		keys     = ['publisher']

		assert_equal(all_keys, @cd.all_to_one_relationship_keys)
		assert_equal(keys, @cd.to_one_relationship_keys)
	end

	def test_to_many_keys
		all_keys = ['books']
		keys     = ['books']

		assert_equal(all_keys, @cd2.all_to_many_relationship_keys)
		assert_equal(keys, @cd2.to_many_relationship_keys)
	end

	def test_property_keys
		all_keys = ['book_id', 'title', 'publisher_id', 'publisher']
		keys     = ['title', 'publisher']

		assert_equal(all_keys, @cd.all_property_keys)
		assert_equal(keys, @cd.property_keys)
	end


	# validation

	def test_validate_value
		assert_raises(ValidationError) { @cd.validate_value('title', nil) }
		assert_raises(ValidationError) { @cd.validate_value('publisher', 'dummy') }
		assert_raises(ValidationError) { @cd.validate_value('notfound', nil) }
	end

	def test_validate_object_for_save
		object = @ec.create 'Book'
		assert_raises(ValidationError) { @cd.validate_object_for_save(object) }
	end

	def test_validate_object_for_delete
		# change delete rule to deny
		entity = @app.entity 'Book'
		rel = entity.relationship 'publisher'
		rel.delete_rule = Relationship::DELETE_RULE_DENY

		object = @ec.create 'Book'
		object.take_stored_value('publisher', 'dummy')
		cd = object.class_description
		assert_raises(ValidationError) { cd.validate_object_for_delete(object) }
	end


	# other methods

	def test_create
		gid    = TemporaryGlobalID.new
		object = @cd.create(@ec, gid)

		assert_kind_of(DatabaseObject, object)
	end

	def test_entity
		assert_equal(@entity, @cd.entity)
		assert_equal(@entity.name, @cd.entity_name)
	end

	def test_delete_rule
		keys = {
			'publisher' => ClassDescription::DELETE_RULE_NULLIFY
		}

		keys.each do |key, rule|
			assert_equal(rule, @cd.delete_rule(key))
		end
	end

	def test_class_description
		key1     = 'publisher'
		key2     = 'books'
		expected = 'Publisher'

		cd = @cd.class_description key1
		assert_equal(expected, cd.entity_name)
	end
end
