class TestGlobalIDStore < Test::Unit::TestCase
	include TapKit

	def setup
		@app = Application.new MODELS
		@ec  = @app.create_editing_context
		@store = GlobalIDStore.new
	end

	def test_add
		gid1 = GlobalID.new
		gid2 = GlobalID.new
		object = '1' # dummy

		@store.add(gid1, object)
		@store.add(gid2, object)

		assert_equal(1, @store.objects.size)
	end
end



class TestKeyGlobalID < Test::Unit::TestCase
	include TapKit

	def test_equal
		name = 'test'
		values = {:key => :value}
		gid1 = KeyGlobalID.new(name, values)
		gid2 = KeyGlobalID.new(name, values)

		assert_not_equal(gid1.id, gid2.id)
		assert_equal(gid1, gid2)
	end
end
