##
## test data
##

class KVCObject
	include TapKit::KeyValueCoding
	include TapKit::KeyValueCodingAdditions

	attr_accessor :message2, :link

	def initialize
		@message  = 'hello'
		@message2 = 'world'
		@link     = self
	end

	def message
		@message.dup
	end

	def message=( str )
		@message = str.dup
	end
end

class KVCDirectlyObject < KVCObject
	undef message
	undef message=

	class << self
		def access_instance_variables?
			true
		end
	end
end


##
## test
##

class TestKeyValueCoding < Test::Unit::TestCase
	include TapKit

	def setup
		@kvc  = KVCObject.new
		@kvcd = KVCDirectlyObject.new
		@msg  = 'hello'
	end

	def test_retrieve_value
		value = @kvc.retrieve_value('message')
		assert_equal(@msg, value)
		assert_not_equal(@kvc.retrieve_value('message').id,
			@kvc.retrieve_value('message').id)
	end

	def test_take_value
		value = 'test'
		@kvc.take_value('message', value)
		assert_equal(value, @kvc.retrieve_value('message'))
		assert_not_equal(@kvc.retrieve_value('message').id,
			@kvc.retrieve_value('message').id)
	end

	def test_directly_retrieve_value
		value = @kvcd.retrieve_value('message')
		assert_equal(@msg, value)
		assert_equal(@kvcd.retrieve_value('message').id,
			@kvcd.retrieve_value('message').id)
	end

	def test_directly_take_value
		value = 'test'
		@kvcd.take_value('message', value)
		assert_equal(value, @kvcd.retrieve_value('message'))
		assert_equal(@kvcd.retrieve_value('message').id,
			@kvcd.retrieve_value('message').id)
	end

end


class TestKeyValueCodingAdditions < Test::Unit::TestCase
	include TapKit

	def setup
		@kvc  = KVCObject.new
		@kvcd = KVCDirectlyObject.new
		@msg1 = 'hello'
		@msg2 = 'world'
	end

	def test_retrieve_value_for_keypath
		value = @kvc.retrieve_value_for_keypath 'link.message'
		assert_equal(@msg1, value)
	end

	def test_take_value_for_keypath
		@kvc.take_value_for_keypath('link.message', @msg2)
		value = @kvc.retrieve_value_for_keypath 'link.message'
		assert_equal(@msg2, value)
	end

	def test_retrieve_values
		keys     = ['message', 'message2']
		values   = @kvc.retrieve_values keys
		expected = {'message' => @msg1, 'message2' => @msg2}
		assert_equal(expected, values)
	end

	def test_take_values
		values = {'message' => @msg2, 'message2' => @msg1}
		@kvc.take_values values

		keys   = ['message', 'message2']
		assert_equal(values, @kvc.retrieve_values(keys))
	end

end


class TestStoredKeyValueCoding < Test::Unit::TestCase
	include TapKit

	def setup
		file = '../examples/model/single_entity.yaml'
		@app = Application.new file
	end

	def test_retrieve_stored_value
		qualifier = Qualifier.new_with_format("title like 'Let*'")
		fetch_spec = FetchSpec.new('cd', qualifier)
		fetch_spec.limit = 1
		objects = @app.shared_editing_context.fetch fetch_spec
		object = objects.first

		assert_equal('Let It Be', object.retrieve_stored_value('title'))
	end

	def test_take_stored_value
		value = 'test'
		ec = @app.create_editing_context
		object = ec.create 'cd'
		object.take_stored_value('title', value)

		assert_equal(value, object['title'])
	end

end
