<?php
/*
 * yuupack.php 2002/04/23  TAMURA Toshihiko (tamura@bitscope.co.jp)
 *
 * YuuPack Shipping Calculator.
 * Calculate shipping costs.
 */
/*
  $rate = new _YuuPack();
  $rate->SetOrigin('01', 'JP');  // ̳ƻ
  $rate->SetDest('13', 'JP');    // Ԥޤ
  $rate->SetWeight(10);      // kg
  $quote = $rate->GetQuote();
  print $quote['Service'] . "<br>";
  print $quote['TotalCharges'] . "\n";
*/
class _YuuPack {
  var $OriginZone;
  var $OriginCountryCode = 'JP';
  var $DestZone;
  var $DestCountryCode = 'JP';
  var $Weight = 0;
  var $Length = 0;
  var $Width  = 0;
  var $Height = 0;

  // 󥹥ȥ饯
  // $zone: ƻܸ '01''47'
  // $country: country code
  function _YuuPack($zone = NULL, $country = NULL) {
    if($zone) {
      $this->SetOrigin($zone, $country);
    }
  }
  // ȯ򥻥åȤ
  // $zone: ƻܸ '01''47'
  // $country: country code
  function SetOrigin($zone, $country = NULL) {
    $this->OriginZone = $zone;
    if($country) {
      $this->OriginCountryCode = $country;
    }
  }
  function SetDest($zone, $country = NULL) {
    $this->DestZone = $zone;
    if($country) {
      $this->DestCountryCode = $country;
    }
  }
  function SetWeight($weight) {
    $this->Weight = $weight;
  }
  function SetSize($length = NULL, $width = NULL, $height = NULL) {
    if($length) {
      $this->Length = $length;
    }
    if($width) {
      $this->Width = $width;
    }
    if($height) {
      $this->Height = $height;
    }
  }
  // ʬ(04)֤
  // ʳξ9֤
  //
  // ʬ շ    
  // ---------------------------------
  // 0    150cmޤ  2kgޤ
  // 1    150cmޤ  4kgޤ
  // 2    150cmޤ  6kgޤ
  // 3    150cmޤ  8kgޤ
  // 4    150cmޤ 10kgޤ
  // 5    150cmޤ 12kgޤ
  // 6    150cmޤ 14kgޤ
  // 7    150cmޤ 16kgޤ
  // 8    150cmޤ 18kgޤ
  // 9    150cmޤ 20kgޤ
  // 10   ʳ    
  function GetSizeClass() {
    $a_classes = array(
      array(0, 150,  2),  // ʬ,շ(cmޤ),(kgޤ)
      array(1, 150,  4),
      array(2, 150,  6),
      array(3, 150,  8),
      array(4, 150, 10),
      array(5, 150, 12),
      array(6, 150, 14),
      array(7, 150, 16),
      array(8, 150, 18),
      array(9, 150, 20),
    );

    $n_totallength = $this->Length + $this->Width + $this->Height;

    while (list($n_index, $a_limit) = each($a_classes)) {
      if ($n_totallength <= $a_limit[1] && $this->Weight <= $a_limit[2]) {
        return $a_limit[0];
      }
    }
    return -1;  // ʳ
  }
  // ո褫ӥ(14)
  //
  function GetDistRank() {
    //  - Ӵ֤βʥ
    // () http://www.post.yusei.go.jp/service/ipankodutumi.shtm
    $a_dist_to_rank = array(
    array(1), // :̳ƻ - :̳ƻ
    array(1,1), // :Ŀ - :̳ƻ,Ŀ
    array(2,1,1),
    array(3,1,1,1),
    array(2,1,1,1,1),
    array(3,1,1,1,1,1),
    array(3,1,1,1,1,1,1),
    array(4,1,1,1,1,1,1,1),
    array(4,1,1,1,1,1,1,1,1),
    array(4,2,2,1,1,1,1,1,1,1),
    array(4,2,2,1,2,1,1,1,1,1,1),
    array(4,2,2,1,2,1,1,1,1,1,1,1),
    array(4,2,2,1,2,1,1,1,1,1,1,1,1),
    array(4,2,2,1,2,1,1,1,1,1,1,1,1,1),
    array(3,1,1,1,1,1,1,1,1,1,1,1,1,1,1),
    array(4,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1),
    array(4,3,3,2,2,2,2,2,1,1,1,2,1,1,1,1,1),
    array(4,3,3,2,3,2,2,2,1,1,1,2,1,1,1,1,1,1),
    array(4,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1),
    array(4,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1),
    array(4,3,3,2,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1),
    array(4,3,2,2,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1),
    array(4,3,3,2,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1),
    array(4,3,3,2,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1),
    array(4,4,4,3,3,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1),
    array(4,4,4,3,3,3,2,2,2,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1),
    array(4,4,4,3,3,3,3,2,2,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1),
    array(4,4,4,3,3,3,3,2,2,2,2,2,2,2,2,1,1,1,2,1,1,1,1,1,1,1,1,1),
    array(4,4,4,3,3,3,3,2,2,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1),
    array(4,4,4,3,3,3,3,2,2,2,2,2,2,2,2,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1),
    array(4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1),
    array(4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,2,2,2,3,3,1,2,2,2,1,1,1,1,1,1,1,1),
    array(4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1),
    array(4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,2,2,2,3,3,1,2,2,2,1,1,1,1,1,1,1,1,1,1),
    array(4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,2,2,2,3,3,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1),
    array(4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1),
    array(4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1),
    array(4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,2,2,2,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1),
    array(4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,2,2,2,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1),
    array(4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,4,4,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,2,1,1,2,1),
    array(4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,4,4,3,3,3,3,3,3,2,2,3,3,1,1,1,1,1,2,1,1,2,1,1),
    array(4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,4,4,3,3,3,3,3,3,2,2,3,3,2,1,2,1,1,2,2,1,2,1,1,1),
    array(4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,4,4,3,3,3,3,3,3,2,2,3,3,2,1,2,1,1,2,1,1,2,1,1,1,1),
    array(4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,4,4,3,3,3,3,3,3,2,2,3,3,2,1,2,1,1,1,1,1,1,1,1,1,1,1),
    array(4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,2,2,2,2,1,2,2,1,2,1,1,1,1,1,1),
    array(4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,2,2,2,2,1,2,2,1,2,1,1,1,1,1,1,1),
    array(4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1),
    );

    $n_rank = 0;
    if ( $this->OriginZone && $this->DestZone ) {
      $n_z1 = (int)$this->OriginZone - 1; // ꥸѴ
      $n_z2 = (int)$this->DestZone   - 1;

      // 󥯤
      if ( $n_z1 <= $n_z2 ) {
        $n_rank = $a_dist_to_rank[$n_z2][$n_z1];
      } else {
        $n_rank = $a_dist_to_rank[$n_z1][$n_z2];
      }
    }
    return $n_rank;
  }

  function GetQuote() {
    // Υ̤βʥ:  => ([2],[4],[6],[8],[10],[12],[14],[16],[18],[20])
    $a_pricerank = array(
    array( 510, 630, 750, 810, 870, 930, 990,1050,1110,1170),// 裱() Υ
    array( 610, 770, 930,1010,1090,1170,1250,1330,1410,1490),// 裱(¾) 
    array( 710, 870,1030,1110,1190,1270,1350,1430,1510,1590),// 裲
    array( 820, 980,1140,1220,1300,1380,1460,1540,1620,1700),// 裳         
    array(1020,1180,1340,1420,1500,1580,1660,1740,1820,1900) // 裴       Υ
    );

    $a_quote['Service'] = MODULE_SHIPPING_YUUPACK_TEXT_TITLE;

    if ( $this->OriginCountryCode == 'JP' && $this->DestCountryCode == 'JP' ) {
      $n_rank = $this->GetDistRank();
      if ( $n_rank ) {
        $n_sizeclass = $this->GetSizeClass();
        if ($n_sizeclass < 0) {
          $a_quote['ErrorNbr'] = 1;
          $a_quote['Error'] = MODULE_SHIPPING_YUUPACK_TEXT_OVERSIZE;
        } else {
          // Ʊƻܸ
          // if ( $this->OriginZone == $this->DestZone ) {
          //   $s_pattern = ($this->OriginZone == '13') ? '^(.+)' : '^(.+)';
          // }
          $a_quote['TotalCharges'] = $a_pricerank[$n_rank][$n_sizeclass];
        }
      // $a_quote['DEBUG'] = ' zone=' . $this->OriginZone . '=>' . $this->DestZone  //DEBUG
      // . ' cost=' . $a_pricerank[$n_rank][$n_sizeclass];      //DEBUG
      } else {
        $a_quote['ErrorNbr'] = 1;
        $a_quote['Error'] = MODULE_SHIPPING_YUUPACK_TEXT_ILLEGAL_ZONE
         . ' (' . $this->OriginZone . '=>' . $this->DestZone . ')';
      }
    } else {
      $a_quote['ErrorNbr'] = 1;
      $a_quote['Error'] = MODULE_SHIPPING_YUUPACK_TEXT_NOTAVAILABLE
       . ' (' . $this->OriginCountryCode . '=>' . $this->DestCountryCode . ')';
    }

    return $a_quote;
  }
}
?>
