<?php
/*
  $Id: secpay.php,v 1.18 2002/03/08 15:26:27 project3000 Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2002 osCommerce

  Released under the GNU General Public License
*/

  class secpay {
    var $code, $title, $description, $enabled;

// class constructor
    function secpay() {
      $this->code = 'secpay';
      $this->title = MODULE_PAYMENT_SECPAY_TEXT_TITLE;
      $this->description = MODULE_PAYMENT_SECPAY_TEXT_DESCRIPTION;
      $this->enabled = MODULE_PAYMENT_SECPAY_STATUS;
    }

// class methods
    function javascript_validation() {
      return false;
    }

    function selection() {
      return false;
    }

    function pre_confirmation_check() {
      return false;
    }

    function confirmation() {
	  global $checkout_form_action;

      $checkout_form_action = 'https://www.secpay.com/java-bin/ValCard?';
    }

    function process_button() {
      global $HTTP_POST_VARS, $shipping_cost, $shipping_method, $total_cost, $total_tax, $currencies, $customer_id, $sendto;

      $customer_query = tep_db_query("select c.customers_firstname, c.customers_lastname, c.customers_telephone, c.customers_fax, c.customers_email_address, ab.entry_street_address, ab.entry_suburb, ab.entry_city, ab.entry_country_id, ab.entry_zone_id, ab.entry_state, ab.entry_postcode from " . TABLE_CUSTOMERS . " c left join " . TABLE_ADDRESS_BOOK . " ab on c.customers_default_address_id = ab.address_book_id and c.customers_id = ab.customers_id where c.customers_id = '" . $customer_id . "'");
      $customer_values = tep_db_fetch_array($customer_query);
      $delivery_query = tep_db_query("select ab.entry_firstname, ab.entry_lastname, ab.entry_street_address, ab.entry_suburb, ab.entry_city, ab.entry_country_id, ab.entry_zone_id, ab.entry_state, ab.entry_postcode from " . TABLE_ADDRESS_BOOK . " ab where ab.address_book_id = '" . $sendto . "' and ab.customers_id = '" . $customer_id . "'");
      $delivery_values = tep_db_fetch_array($delivery_query);

      $process_button_string = tep_draw_hidden_field('merchant', MODULE_PAYMENT_SECPAY_MERCHANT_ID) .
                               tep_draw_hidden_field('trans_id', STORE_NAME . date('Ymdhis')) .
                               tep_draw_hidden_field('amount', number_format(($total_cost + $total_tax + $shipping_cost) * $currencies->get_value(MODULE_PAYMENT_SECPAY_CURRENCY), 2)) .
                               tep_draw_hidden_field('bill_name', $customer_values['customers_firstname'] . ' ' . $customer_values['customers_lastname']) .
                               tep_draw_hidden_field('bill_addr_1', $customer_values['entry_street_address']) .
                               tep_draw_hidden_field('bill_addr_2', $customer_values['entry_suburb']) .
                               tep_draw_hidden_field('bill_city', $customer_values['entry_city']) .
                               tep_draw_hidden_field('bill_state', tep_get_zone_name($customer_values['entry_country_id'], $customer_values['entry_zone_id'], $customer_values['entry_state'])) .
                               tep_draw_hidden_field('bill_post_code', $customer_values['entry_postcode']) .
                               tep_draw_hidden_field('bill_country', tep_get_country_name($customer_values['entry_country_id'])) .
                               tep_draw_hidden_field('bill_tel', $customer_values['customers_telephone']) .
                               tep_draw_hidden_field('bill_fax', $customer_values['customers_fax']) .
                               tep_draw_hidden_field('bill_email', $customer_values['customers_email_address']) .
                               tep_draw_hidden_field('ship_name', $delivery_values['entry_firstname'] . ' ' . $delivery_values['entry_lastname']) .
                               tep_draw_hidden_field('ship_addr_1', $delivery_values['entry_street_address']) .
                               tep_draw_hidden_field('ship_addr_2', $delivery_values['entry_suburb']) .
                               tep_draw_hidden_field('ship_city', $delivery_values['entry_city']) .
                               tep_draw_hidden_field('ship_state', tep_get_zone_name($delivery_values['entry_country_id'], $delivery_values['entry_zone_id'], $delivery_values['entry_state'])) .
                               tep_draw_hidden_field('ship_post_code', $delivery_values['entry_postcode']) .
                               tep_draw_hidden_field('ship_country', tep_get_country_name($delivery_values['entry_country_id'])) .
                               tep_draw_hidden_field('currency', MODULE_PAYMENT_SECPAY_CURRENCY) .
                               tep_draw_hidden_field('callback', tep_href_link(FILENAME_CHECKOUT_PROCESS, 'shipping_cost=' . $shipping_cost . '&shipping_method=' . urlencode($shipping_method)), true) .
                               tep_draw_hidden_field(tep_session_name(), tep_session_id()) .
                               tep_draw_hidden_field('options', 'test_status=' . MODULE_PAYMENT_SECPAY_TEST_STATUS . ',dups=false,cb_post=true,cb_flds=payment:shipping_cost:shipping_method:' . tep_session_name());

      return $process_button_string;
    }

    function before_process() {
      global $HTTP_POST_VARS;

      $remote_host = getenv('REMOTE_HOST');
      if ( ($remote_host != 'secpay.com') && ($HTTP_POST_VARS['valid'] == 'true') ) {
        $remote_host = gethostbyaddr($remote_host);
      }
      if ( ($remote_host != 'secpay.com') || ($HTTP_POST_VARS['valid'] != 'true') ) {
        tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, tep_session_name() . '=' . $HTTP_POST_VARS['session'] . '&error_message=' . urlencode(MODULE_PAYMENT_SECPAY_TEXT_ERROR_MESSAGE), 'SSL', true, false));
      }
    }

    function after_process() {
	  return false;
    }

    function output_error() {
      return false;
    }

    function check() {
      if (!isset($this->check)) {
        $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_SECPAY_STATUS'");
        $this->check = tep_db_num_rows($check_query);
      }
      return $this->check;
    }

    function install() {
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Allow SECpay', 'MODULE_PAYMENT_SECPAY_STATUS', '1', 'Do you want to accept SECPay payments?', '6', '1', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('SECPay ID', 'MODULE_PAYMENT_SECPAY_ID', 'secpay-99874296', 'Your SECPay ID.', '6', '2', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Merchant ID', 'MODULE_PAYMENT_SECPAY_MERCHANT_ID', 'secpay', 'Your Merchant ID.', '6', '3', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('SECPay Currency', 'MODULE_PAYMENT_SECPAY_CURRENCY', 'GBP', 'The currency SECPay should charge in.', '6', '4', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('SECPay Test Status', 'MODULE_PAYMENT_SECPAY_TEST_STATUS', 'true', 'true/false/live', '6', '5', now())");
    }

    function remove() {
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_SECPAY_STATUS'");
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_SECPAY_ID'");
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_SECPAY_MERCHANT_ID'");
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_SECPAY_CURRENCY'");
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_SECPAY_TEST_STATUS'");
    }

    function keys() {
      $keys = array('MODULE_PAYMENT_SECPAY_STATUS', 'MODULE_PAYMENT_SECPAY_ID', 'MODULE_PAYMENT_SECPAY_MERCHANT_ID', 'MODULE_PAYMENT_SECPAY_CURRENCY', 'MODULE_PAYMENT_SECPAY_TEST_STATUS');

      return $keys;
    }
  }
?>
