<?php
/*
  sagawaex.php 2003/04/13

  The Exchange Project - Community Made Shopping!
  http://www.theexchangeproject.org

  Copyright (c) 2000,2001 The Exchange Project

  Released under the GNU General Public License

  ⥸塼 (̾)
  TAMURA Toshihiko (tamura@bitscope.co.jp)

  [Ϣե]
  catalog/includes/classes/_sagawaex.php
  catalog/includes/languages/japanese/modules/shipping/sagawaex.php
  catalog/includes/modules/shipping/sagawaex.php

  []
  catalog/checkout_payment.php ˤơ$address_values['zone_id'] 褦ѹ
*/
  class sagawaex {
    var $code, $title, $description, $icon, $enabled, $sagawaex_countries, $sagawaex_countries_nbr;
    var $quote;

// class constructor
    function sagawaex() {
      $this->code = 'sagawaex';
      $this->title = MODULE_SHIPPING_SAGAWAEX_TEXT_TITLE;
      $this->description = MODULE_SHIPPING_SAGAWAEX_TEXT_DESCRIPTION;
      $this->icon = DIR_WS_ICONS . 'shipping_sagawaex.gif';
      $this->enabled = MODULE_SHIPPING_SAGAWAEX_STATUS;

      // only these three are needed since SagawaEx only ships to them
      // convert TEP country id to ISO 3166 id
      $this->sagawaex_countries = array(107 => 'JP');
      $this->sagawaex_countries_nbr = array(107);
    }

// class methods
    function selection() {
      $selection_string = '<table border="0" cellspacing="0" cellpadding="0" width="100%">' . "\n" .
                          '  <tr>' . "\n" .
                          '    <td class="main">' . (($this->icon) ? tep_image($this->icon, $this->title) : '') . ' ' . MODULE_SHIPPING_SAGAWAEX_TEXT_TITLE . '</td>' . "\n" .
                          '    <td align="right" class="main">' . tep_draw_checkbox_field('shipping_quote_sagawaex', '1', true) . '</td>' . "\n" .
                          '  </tr>' . "\n" .
                          '</table>' . "\n";

      return $selection_string;
    }

    function quote() {
      global $shipping_quoted, $address_values, $shipping_weight, $shipping_num_boxes;
      global $shipping_sagawaex_cost, $shipping_sagawaex_method;

      if ( ($GLOBALS['shipping_quote_all'] == '1') || ($GLOBALS['shipping_quote_sagawaex'] == '1') ) {
        $shipping_quoted = 'sagawaex';
        // only calculate if SagawaEx ships there.
        if(in_array($address_values['country_id'], $this->sagawaex_countries_nbr)) {
          $zoneinfo = tep_db_query("SELECT zone_code FROM zones WHERE zone_id = '" . $address_values['zone_id'] . "'");
          $a_zonevalues = tep_db_fetch_array($zoneinfo);
          $s_zone_code = $a_zonevalues['zone_code'];

          include(DIR_WS_CLASSES . '_sagawaex.php');
          $rate = new _SagawaEx(STORE_ORIGIN_ZONE, STORE_ORIGIN_COUNTRY);
          $rate->SetDest($s_zone_code, $this->sagawaex_countries[$address_values['country_id']]);
          $rate->SetWeight($shipping_weight);
          $this->quote = $rate->GetQuote();
          // SHIPPING_HANDLING  configuration ơ֥˵Ͽ
          $shipping_sagawaex_cost = $shipping_num_boxes * (SHIPPING_HANDLING + $this->quote['TotalCharges']);
          $shipping_sagawaex_method = $this->quote['Service'] . ' ' . $shipping_num_boxes . ' X ' . $shipping_weight;
        //  $shipping_sagawaex_method .= $this->quote['Error'] . $this->quote['DEBUG'];	// DEBUG
        } else {
          $this->quote['ErrorNbr'] = 1;
          $this->quote['Error'] = MODULE_SHIPPING_SAGAWAEX_TEXT_NOTAVAILABLE;
        }
      }
    }

    function cheapest() {
      global $address_values, $shipping_count, $shipping_cheapest, $shipping_cheapest_cost;
      global $shipping_sagawaex_cost;

      if ( ($GLOBALS['shipping_quote_all'] == '1') || ($GLOBALS['shipping_quote_sagawaex'] == '1') ) {
        // only calculate if SagawaEx ships there.
        if(in_array($address_values['country_id'], $this->sagawaex_countries_nbr) && !$this->quote['ErrorNbr']) {
          if($shipping_count == 0) {
            $shipping_cheapest = 'sagawaex';
            $shipping_cheapest_cost = $shipping_sagawaex_cost;
          } else {
            if($shipping_sagawaex_cost < $shipping_cheapest_cost) {
              $shipping_cheapest = 'sagawaex';
              $shipping_cheapest_cost = $shipping_sagawaex_cost;
            }
          }
        }
        $shipping_count++;
      }
    }

    // ʧˡ
    function display() {
      global $HTTP_GET_VARS, $currencies;
      global $shipping_sagawaex_method, $shipping_sagawaex_cost, $shipping_cheapest, $shipping_selected;
      global $a_sagawaex_time;

// set a global for the radio field (auto select cheapest shipping method)
      if (!$HTTP_GET_VARS['shipping_selected']) $shipping_selected = $shipping_cheapest;

      $display_string = '';
      if ( ($GLOBALS['shipping_quote_all'] == '1') || ($GLOBALS['shipping_quote_sagawaex'] == '1') ) {
        // check for errors
        if($this->quote['ErrorNbr']) {
          $display_string .= '<table border="0" width="100%" cellspacing="0" cellpadding="0">' . "\n" .
                             '  <tr>' . "\n" .
                             '    <td class="main">' . (($this->icon) ? tep_image($this->icon, $this->title) : '') . ' ' . MODULE_SHIPPING_SAGAWAEX_TEXT_TITLE . '</td>' . "\n" .
                             '    <td class="main"><font color="#ff0000">顼:</font> ' . $this->quote['Error'] . '</td>' . "\n" .
                             '  </tr>' . "\n" .
                             '</table>' . "\n";
        }
        else {
          $display_string .= '<table border="0" width="100%" cellspacing="0" cellpadding="0">' . "\n" .
                             '  <tr>' . "\n" .
                             '    <td class="main">' . (($this->icon) ? tep_image($this->icon, $this->title) : '') .
                             ' ' . MODULE_SHIPPING_SAGAWAEX_TEXT_TITLE . ' <small><i>(' . $shipping_sagawaex_method . ')</i></small></td>' . "\n" .
                             '    <td align="right" class="main">' . $currencies->format($shipping_sagawaex_cost);

          if (tep_count_shipping_modules() > 1) {
            $display_string .= tep_draw_radio_field('shipping_selected', 'sagawaex') .
                               tep_draw_hidden_field('shipping_sagawaex_cost', $shipping_sagawaex_cost) .
                               tep_draw_hidden_field('shipping_sagawaex_method', $shipping_sagawaex_method) . '</td>' . "\n";
          } else {
            $display_string .= tep_draw_hidden_field('shipping_selected', 'sagawaex') .
                               tep_draw_hidden_field('shipping_sagawaex_cost', $shipping_sagawaex_cost) .
                               tep_draw_hidden_field('shipping_sagawaex_method', $shipping_sagawaex_method) . '</td>' . "\n";
          }
          $display_string .= '  </tr>' . "\n";

          $display_string .= '  <tr>' . "\n" .
                             '    <td class="main">&nbsp;&nbsp;' . MODULE_SHIPPING_SAGAWAEX_TEXT_TIME_SPECIFY . '&nbsp;' .
                             tep_draw_pull_down_menu('shipping_sagawaex_time_specify', $a_sagawaex_time, 'none') . '</td>' . "\n" .
                             '  <td></td></tr>' . "\n";

          $display_string .= '</table>' . "\n";
        }
      }

      return $display_string;
    }

    function confirm() {
      global $HTTP_POST_VARS, $shipping_cost, $shipping_method;
      global $a_sagawaex_time, $comments;

      if ($HTTP_POST_VARS['shipping_selected'] == 'sagawaex') {
        $shipping_cost = $HTTP_POST_VARS['shipping_sagawaex_cost'];
        $shipping_method = $HTTP_POST_VARS['shipping_sagawaex_method'];

        // Ӥλ
        // 򤵤줿֥˥塼õ
        $s_add_head = '';
        $s_add_bottom = '';
		// ʬλӤλ
        $comments = trim(
            ereg_replace('(^' . $s_add_head . MODULE_SHIPPING_SAGAWAEX_TEXT_TIME_SPECIFY . ".*" . $s_add_bottom . ')',
            '',
            $comments)
          );

        for ($i=0; $i<sizeof($a_sagawaex_time); $i++) {
          if ( $a_sagawaex_time[$i]['id'] == $HTTP_POST_VARS['shipping_sagawaex_time_specify'] ) {
            if (!tep_session_is_registered('comments')) {
              tep_session_register('comments');
            }
            $comments = $s_add_head . MODULE_SHIPPING_SAGAWAEX_TEXT_TIME_SPECIFY . $a_sagawaex_time[$i]['text'] . $s_add_bottom . "\n" . $comments;
            break;
          }
        }
      }
    }

    function check() {
      if (!isset($this->check)) {
        $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_SAGAWAEX_STATUS'");
        $this->check = tep_db_num_rows($check_query);
      }
      return $this->check;
    }

    function install() {
      tep_db_query("insert into " . TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('ؤͭˤ', 'MODULE_SHIPPING_SAGAWAEX_STATUS', '1', '(̾)󶡤ޤ?', '6', '11', now())");
    }

    function remove() {
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_SAGAWAEX_STATUS'");
    }

    function keys() {
      $keys = array('MODULE_SHIPPING_SAGAWAEX_STATUS');

      return $keys;
    }
  }
?>
