<?php
/*
  yamato_d.php 2003/09/19

  The Exchange Project - Community Made Shopping!
  http://www.theexchangeproject.org

  Copyright (c) 2000,2002 The Exchange Project

  Released under the GNU General Public License

  ⥸塼 ޥ(ǥб)
  TAMURA Toshihiko (tamura@bitscope.co.jp)

  [Ϣե]
  catalog/includes/classes/_yamato.php (̾)
  catalog/includes/languages/japanese/modules/shipping/yamato_d.php (Ƥ̾ǤƱ)
  catalog/includes/modules/shipping/yamato_d.php (Υե)

  []
  catalog/checkout_payment.php ˤơ$address_values['zone_id'] 褦ѹ

  ̾(yamato.php)ƱѤƤ뤿ᡢ̾ǤƱ˥⥸塼
  Ȥ߹ळȤϤǤޤɬ̾ǥ⥸塼곰ƻѤƤ
  ϡ⻻Х饹 _yamato ̾ǤȶѤ뤿֤Ǥ
*/
  class yamato_d {
    var $code, $title, $description, $icon, $enabled, $yamato_countries, $yamato_countries_nbr;
    var $quote;

// class constructor
    function yamato_d() {
      $this->code = 'yamato_d';
      $this->title = MODULE_SHIPPING_YAMATO_TEXT_TITLE;
      $this->description = MODULE_SHIPPING_YAMATO_TEXT_DESCRIPTION;
      $this->icon = DIR_WS_ICONS . 'shipping_yamato.gif';
      $this->enabled = MODULE_SHIPPING_YAMATO_D_STATUS;

      // only these three are needed since Yamato only ships to them
      // convert TEP country id to ISO 3166 id
      $this->yamato_countries = array(107 => 'JP');
      $this->yamato_countries_nbr = array(107);
    }

// class methods
    function selection() {
      $selection_string = '<table border="0" cellspacing="0" cellpadding="0" width="100%">' . "\n" .
                          '  <tr>' . "\n" .
                          '    <td class="main">' . (($this->icon) ? tep_image($this->icon, $this->title) : '') . ' ' . MODULE_SHIPPING_YAMATO_TEXT_TITLE . '</td>' . "\n" .
                          '    <td align="right" class="main">' . tep_draw_checkbox_field('shipping_quote_yamato', '1', true) . '</td>' . "\n" .
                          '  </tr>' . "\n" .
                          '</table>' . "\n";

      return $selection_string;
    }

    function quote() {
      global $shipping_quoted, $address_values, $shipping_weight, $shipping_num_boxes;
      global $shipping_yamato_cost, $shipping_yamato_method;
      global $cart;

      if ( ($GLOBALS['shipping_quote_all'] == '1') || ($GLOBALS['shipping_quote_yamato'] == '1') ) {
        $shipping_quoted = 'yamato_d';
        // only calculate if Yamato ships there.
        if(in_array($address_values['country_id'], $this->yamato_countries_nbr)) {
          $zoneinfo = tep_db_query("SELECT zone_code FROM zones WHERE zone_id = '" . $address_values['zone_id'] . "'");
          $a_zonevalues = tep_db_fetch_array($zoneinfo);
          $s_zone_code = $a_zonevalues['zone_code'];

          include(DIR_WS_CLASSES . '_yamato.php');
          $rate = new _Yamato(STORE_ORIGIN_ZONE, STORE_ORIGIN_COUNTRY);
          $rate->SetDest($s_zone_code, $this->yamato_countries[$address_values['country_id']]);
          $rate->SetWeight($shipping_weight);

          if (!defined('SHIPPING_YAMATO_D_BORDER') || (int)$cart->show_total() < (int)SHIPPING_YAMATO_D_BORDER) {
            $this->quote = $rate->GetQuote();
            if (defined('SHIPPING_YAMATO_D_DISCOUNT') && 0 < (int)SHIPPING_YAMATO_D_DISCOUNT) {
              $this->quote['TotalCharges'] -= $this->quote['TotalCharges'] * SHIPPING_YAMATO_D_DISCOUNT / 100;
            }
          } else {
            $this->quote['TotalCharges'] = 0;
          }
          // $this->quote['DEBUG'] .= ' total:' . $cart->show_total();// DEBUG
 
          // SHIPPING_HANDLING  configuration ơ֥˵Ͽ
          $shipping_yamato_cost = $shipping_num_boxes * (SHIPPING_HANDLING + $this->quote['TotalCharges']);
          $shipping_yamato_method = $this->quote['Service'] . ' ' . $shipping_num_boxes . ' X ' . $shipping_weight;
          // $shipping_yamato_method .= ($this->quote['Error'] . $this->quote['DEBUG']);	// DEBUG
        } else {
          $this->quote['ErrorNbr'] = 1;
          $this->quote['Error'] = MODULE_SHIPPING_YAMATO_TEXT_NOTAVAILABLE;
        }
      }
    }

    function cheapest() {
      global $address_values, $shipping_count, $shipping_cheapest, $shipping_cheapest_cost;
      global $shipping_yamato_cost;

      if ( ($GLOBALS['shipping_quote_all'] == '1') || ($GLOBALS['shipping_quote_yamato'] == '1') ) {
        // only calculate if Yamato ships there.
        if(in_array($address_values['country_id'], $this->yamato_countries_nbr) && !$this->quote['ErrorNbr']) {
          if($shipping_count == 0) {
            $shipping_cheapest = 'yamato_d';
            $shipping_cheapest_cost = $shipping_yamato_cost;
          } else {
            if($shipping_yamato_cost < $shipping_cheapest_cost) {
              $shipping_cheapest = 'yamato_d';
              $shipping_cheapest_cost = $shipping_yamato_cost;
            }
          }
        }
        $shipping_count++;
      }
    }

    function display() {
      global $HTTP_GET_VARS, $currencies;
      global $shipping_yamato_method, $shipping_yamato_cost, $shipping_cheapest, $shipping_selected;
      global $a_yamato_time;

// set a global for the radio field (auto select cheapest shipping method)
      if (!$HTTP_GET_VARS['shipping_selected']) $shipping_selected = $shipping_cheapest;

      $display_string = '';
      if ( ($GLOBALS['shipping_quote_all'] == '1') || ($GLOBALS['shipping_quote_yamato'] == '1') ) {
        // check for errors
        if($this->quote['ErrorNbr']) {
          $display_string .= '<table border="0" width="100%" cellspacing="0" cellpadding="0">' . "\n" .
                             '  <tr>' . "\n" .
                             '    <td class="main">' . (($this->icon) ? tep_image($this->icon, $this->title) : '') . ' ' . MODULE_SHIPPING_YAMATO_TEXT_TITLE . '</td>' . "\n" .
                             '    <td class="main"><font color="#ff0000">顼:</font> ' . $this->quote['Error'] . '</td>' . "\n" .
                             '  </tr>' . "\n" .
                             '</table>' . "\n";
        }
        else {
          $display_string .= '<table border="0" width="100%" cellspacing="0" cellpadding="0">' . "\n" .
                             '  <tr>' . "\n" .
                             '    <td class="main">' . (($this->icon) ? tep_image($this->icon, $this->title) : '') .
                             ' ' . MODULE_SHIPPING_YAMATO_TEXT_TITLE . ' <small><i>(' . $shipping_yamato_method . ')</i></small></td>' . "\n" .
                             '    <td align="right" class="main">' . $currencies->format($shipping_yamato_cost);
          if (tep_count_shipping_modules() > 1) {
            $display_string .= tep_draw_radio_field('shipping_selected', 'yamato_d') .
                               tep_draw_hidden_field('shipping_yamato_cost', $shipping_yamato_cost) .
                               tep_draw_hidden_field('shipping_yamato_method', $shipping_yamato_method) . '</td>' . "\n";
          } else {
            $display_string .= tep_draw_hidden_field('shipping_selected', 'yamato_d') .
                               tep_draw_hidden_field('shipping_yamato_cost', $shipping_yamato_cost) .
                               tep_draw_hidden_field('shipping_yamato_method', $shipping_yamato_method) . '</td>' . "\n";
          }
          $display_string .= '  </tr>' . "\n";

          $display_string .= '  <tr>' . "\n" .
                             '    <td class="main">&nbsp;&nbsp;' . MODULE_SHIPPING_YAMATO_TEXT_TIME_SPECIFY . '&nbsp;' .
                             tep_draw_pull_down_menu('shipping_yamato_time_specify', $a_yamato_time, 'none') . '</td>' . "\n";
                             '    <td></td>' . "\n";
                             '  </tr>' . "\n";

          $display_string .= '</table>' . "\n";
        }
      }

      return $display_string;
    }

    function confirm() {
      global $HTTP_POST_VARS, $shipping_cost, $shipping_method;
      global $a_yamato_time, $comments;

      if ($HTTP_POST_VARS['shipping_selected'] == 'yamato_d') {
        $shipping_cost = $HTTP_POST_VARS['shipping_yamato_cost'];
        $shipping_method = $HTTP_POST_VARS['shipping_yamato_method'];

        // Ӥλ
        // 򤵤줿֥˥塼õ
        $s_add_head = '';
        $s_add_bottom = '';
		// ʬλӤλ
        $comments = trim(
            ereg_replace('(^' . $s_add_head . MODULE_SHIPPING_YAMATO_TEXT_TIME_SPECIFY . ".*" . $s_add_bottom . ')',
            '',
            $comments)
          );

        for ($i=0; $i<sizeof($a_yamato_time); $i++) {
          if ( $a_yamato_time[$i]['id'] == $HTTP_POST_VARS['shipping_yamato_time_specify'] ) {
            if (!tep_session_is_registered('comments')) {
              tep_session_register('comments');
            }
            $comments = $s_add_head . MODULE_SHIPPING_YAMATO_TEXT_TIME_SPECIFY . $a_yamato_time[$i]['text'] . $s_add_bottom . "\n" . $comments;
            break;
          }
        }
      }
    }

    function check() {
      if (!isset($this->check)) {
        $check_query = tep_db_query("select configuration_value from "
          . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_YAMATO_D_STATUS'");
        $this->check = tep_db_num_rows($check_query);
      }
      return $this->check;
    }

    function install() {
      tep_db_query("insert into " . TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('ޥ(ǥ)ͭˤ', 'MODULE_SHIPPING_YAMATO_D_STATUS', '1', 'ޥ(ǥ)󶡤ޤ?', '6', '20', now())");

      tep_db_query("INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ޥؤ̵ˤ', 'SHIPPING_YAMATO_D_BORDER', '5000', 'ζ۰ʾξ̵ˤޤ.()', '6', '20', now())");

      tep_db_query("INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ޥؤͰΨ', 'SHIPPING_YAMATO_D_DISCOUNT', '0', 'ͰΨǻꤷޤ.', '6', '20', now())");

    }

    function remove() {
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_YAMATO_D_STATUS'");
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key = 'SHIPPING_YAMATO_D_BORDER'");
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key = 'SHIPPING_YAMATO_D_DISCOUNT'");
    }

    function keys() {
      $keys = array('MODULE_SHIPPING_YAMATO_D_STATUS',
                    'SHIPPING_YAMATO_D_BORDER',
                    'SHIPPING_YAMATO_D_DISCOUNT');

      return $keys;
    }
  }
?>
