/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.struts.taglib;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import jp.terasoluna.fw.util.PropertyUtil;
import jp.terasoluna.fw.web.struts.taglib.RandomUtil;
import org.apache.struts.action.ActionMessages;

public class MessagesPopupTag
extends TagSupport {
    private static final long serialVersionUID = 1148524236499924202L;
    public static final String ON_LOAD_KEY = "ON_LOAD";
    public static final String POPUP_ERROR_KEY = "popup_error_key";
    public static final String POPUP_MESSAGE_KEY = "popup_message_key";
    private static final String DEFAULT_TITLE = "popup";
    private String popup = null;
    private String title = "popup";
    private String param = null;
    private String paramFunc = null;
    private String windowId = null;

    public void setPopup(String value) {
        this.popup = value;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public void setParam(String value) {
        this.param = value;
    }

    public void setParamType(String value) {
        this.param = PropertyUtil.getProperty((String)("messages.popup.param." + value));
    }

    public void setParamFunc(String value) {
        this.paramFunc = value;
    }

    public void setWindowId(String value) {
        this.windowId = value;
    }

    public int doStartTag() throws JspException {
        HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
        if (req.getAttribute("org.apache.struts.action.ERROR") == null && req.getAttribute("org.apache.struts.action.ACTION_MESSAGE") == null) {
            return 1;
        }
        ActionMessages errors = (ActionMessages)req.getAttribute("org.apache.struts.action.ERROR");
        ActionMessages messages = (ActionMessages)req.getAttribute("org.apache.struts.action.ACTION_MESSAGE");
        String errorKey = null;
        String messageKey = null;
        HttpSession session = this.pageContext.getSession();
        if (errors != null && !errors.isEmpty()) {
            errorKey = RandomUtil.generateRandomID();
            session.setAttribute(errorKey, (Object)errors);
        }
        if (messages != null && !messages.isEmpty()) {
            messageKey = RandomUtil.generateRandomID();
            session.setAttribute(messageKey, (Object)messages);
        }
        String script = this.getOnLoadScript(req, errorKey, messageKey);
        req.setAttribute(ON_LOAD_KEY, (Object)script);
        return 1;
    }

    private String getOnLoadScript(HttpServletRequest req, String errorKey, String messageKey) {
        if (errorKey == null && messageKey == null) {
            return null;
        }
        StringBuilder onLoad = new StringBuilder();
        onLoad.append("  ");
        if (this.windowId != null) {
            onLoad.append(this.windowId);
            onLoad.append(" = ");
        }
        onLoad.append("window.open(\"");
        onLoad.append(req.getContextPath());
        onLoad.append(this.popup);
        onLoad.append(this.getRequestParameterKey(errorKey, messageKey));
        onLoad.append("\", \"");
        if (this.title != null) {
            onLoad.append(this.title);
        }
        onLoad.append("\", ");
        if (this.paramFunc != null) {
            onLoad.append(this.paramFunc);
        } else {
            onLoad.append("\"");
            if (this.param != null) {
                onLoad.append(this.param);
            }
            onLoad.append("\"");
        }
        onLoad.append(");" + System.getProperty("line.separator"));
        return onLoad.toString();
    }

    private String getRequestParameterKey(String errorKey, String messageKey) {
        StringBuilder param = new StringBuilder();
        param.append("?");
        if (errorKey != null) {
            param.append(POPUP_ERROR_KEY);
            param.append("=");
            param.append(errorKey);
        }
        if (errorKey != null && messageKey != null) {
            param.append("&");
        }
        if (messageKey != null) {
            param.append(POPUP_MESSAGE_KEY);
            param.append("=");
            param.append(messageKey);
        }
        return param.toString();
    }

    public int doEndTag() throws JspException {
        return 6;
    }

    public void release() {
        super.release();
        this.popup = null;
        this.title = DEFAULT_TITLE;
        this.param = null;
        this.paramFunc = null;
        this.windowId = null;
    }
}

