/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.ex.web.struts.taglib;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import jp.terasoluna.fw.util.PropertyUtil;
import jp.terasoluna.fw.web.struts.form.ActionFormUtil;
import jp.terasoluna.fw.web.struts.taglib.PageLinksTag;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.taglib.TagUtils;

public class PageLinksTagEx
extends PageLinksTag {
    private static final long serialVersionUID = -6012015988097621650L;
    private static Log log = LogFactory.getLog(PageLinksTag.class);
    protected String url = null;
    protected String formName = null;
    protected boolean pageJump = false;
    protected static final String START_LINKS = "start";
    protected static final String END_LINKS = "end";
    protected static final String FIRST_LINKS = "first";
    protected static final String LAST_LINKS = "last";
    protected static final String JUMPFORM_SUBMIT_DEFAULT = "submit";
    protected static String PAGEJUMP_JAVASCRIPT_KEY = "pageJumpJavaScriptKey";
    protected static final String START_PAGELINKS_TAG = "pageLinks.start.tag";
    protected static final String END_PAGELINKS_TAG = "pageLinks.end.tag";
    protected static final String START_PAGE_TAG = "pageLinks.start.page.tag";
    protected static final String END_PAGE_TAG = "pageLinks.end.page.tag";
    protected static final String START_PREV_TAG = "pageLinks.start.prev.tag";
    protected static final String END_PREV_TAG = "pageLinks.end.prev.tag";
    protected static final String START_NEXT_TAG = "pageLinks.start.next.tag";
    protected static final String END_NEXT_TAG = "pageLinks.end.next.tag";
    protected static final String START_FIRST_TAG = "pageLinks.start.first.tag";
    protected static final String END_FIRST_TAG = "pageLinks.end.first.tag";
    protected static final String START_LAST_TAG = "pageLinks.start.last.tag";
    protected static final String END_LAST_TAG = "pageLinks.end.last.tag";
    protected static final String START_ACTIVE_TAG = "pageLinks.start.active.tag";
    protected static final String END_ACTIVE_TAG = "pageLinks.end.active.tag";
    protected static final String START_DISABLE_TAG = "pageLinks.start.disable.tag";
    protected static final String END_DISABLE_TAG = "pageLinks.end.disable.tag";
    protected static final String START_JUMPFORM_TAG = "pageLinks.start.jump.tag";
    protected static final String END_JUMPFORM_TAG = "pageLinks.end.jump.tag";
    protected static final String JUMPFORM_TEXT_ATTRIBUTES = "pageLinks.jump.text.attributes";
    protected static final String JUMPFORM_SUBMIT_ATTRIBUTES = "pageLinks.jump.submit.attributes";
    protected static final String JUMPFORM_SUBMIT_VALUE = "pageLinks.jump.submit.char";
    protected String startPageLinksTag = null;
    protected String endPageLinksTag = null;
    protected String startPageTag = null;
    protected String endPageTag = null;
    protected String startPrevTag = null;
    protected String endPrevTag = null;
    protected String startNextTag = null;
    protected String endNextTag = null;
    protected String startFirstTag = null;
    protected String endFirstTag = null;
    protected String startLastTag = null;
    protected String endLastTag = null;
    protected String startActiveTag = null;
    protected String endActiveTag = null;
    protected String startDisableTag = null;
    protected String endDisableTag = null;
    protected String startJumpFormTag = null;
    protected String endJumpFormTag = null;
    protected String jumpFormTextAttributes = null;
    protected String jumpFormSubmitAttributes = null;
    protected String jumpFormSubmitValue = "submit";

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public boolean getPageJump() {
        return this.pageJump;
    }

    public void setPageJump(boolean pageJump) {
        this.pageJump = pageJump;
    }

    public int doStartTag() throws JspException {
        if (!this.submit && (this.action == null || "".equals(this.action))) {
            log.error((Object)ERROR_MESSAGE_ACTION_REQUIRED);
            throw new JspException(ERROR_MESSAGE_ACTION_REQUIRED);
        }
        this.initTagProperty();
        TagUtils tagUtils = TagUtils.getInstance();
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        this.setUrl(response.encodeURL(tagUtils.getActionMappingURL(this.action, this.pageContext)));
        this.setFormName(ActionFormUtil.getActionFormName((HttpServletRequest)((HttpServletRequest)this.pageContext.getRequest())));
        this.initTagProperty();
        this.getLinkProperty();
        Object objRow = this.lookup(this.pageContext, this.name, this.rowProperty, this.scope);
        int row = this.getInt(objRow);
        if (row <= 0) {
            if (log.isWarnEnabled()) {
                log.warn((Object)WARN_MESSAGE_ILLEGAL_ROW);
            }
            return 1;
        }
        Object objIndex = this.lookup(this.pageContext, this.name, this.indexProperty, this.scope);
        int startIndex = this.getInt(objIndex);
        Object objTotal = this.lookup(this.pageContext, this.name, this.totalProperty, this.scope);
        int totalCount = this.getInt(objTotal);
        StringBuilder sb = new StringBuilder();
        this.attributePageCount(this.getPageIndex(row, startIndex), this.getPageCount(row, totalCount));
        sb.append(this.startPageLinksTag);
        if (this.submit) {
            this.defineHtml(row, startIndex, totalCount);
            this.addSubmitJS();
            this.addFirstSubmit(sb, row, startIndex, totalCount);
            this.addPrevSubmit(sb, row, startIndex, totalCount);
            this.addDirectSubmit(sb, row, startIndex, totalCount);
            this.addNextSubmit(sb, row, startIndex, totalCount);
            this.addLastSubmit(sb, row, startIndex, totalCount);
        } else {
            this.addFirstLink(sb, row, startIndex, totalCount);
            this.addPrevLink(sb, row, startIndex, totalCount);
            this.addDirectLink(sb, row, startIndex, totalCount);
            this.addNextLink(sb, row, startIndex, totalCount);
            this.addLastLink(sb, row, startIndex, totalCount);
            if (this.pageJump) {
                this.addJumpFormJS(row, this.getPageIndex(row, startIndex), this.getPageCount(row, totalCount));
                this.addJumpForm(sb, row, startIndex);
            }
        }
        sb.append(this.endPageLinksTag);
        if (this.id == null || "".equals(this.id)) {
            try {
                JspWriter writer = this.pageContext.getOut();
                writer.println(sb.toString());
            }
            catch (IOException e) {
                log.error((Object)e.getMessage());
                throw new JspTagException(e.toString());
            }
        } else {
            this.pageContext.setAttribute(this.id, (Object)sb.toString());
        }
        return 1;
    }

    protected void defineHtml(int row, int startIndex, int totalCount) throws JspException {
        JspWriter writer = this.pageContext.getOut();
        try {
            if (!this.getPageContextFlg(this.pageContext, PAGELINKS_JAVASCRIPT_KEY + this.rowProperty)) {
                writer.println("<input type=\"hidden\" name=\"" + this.rowProperty + "\" value=\"" + row + "\"/>");
                this.setPageContextFlg(this.pageContext, PAGELINKS_JAVASCRIPT_KEY + this.rowProperty);
            }
            if (!this.getPageContextFlg(this.pageContext, PAGELINKS_JAVASCRIPT_KEY + this.indexProperty)) {
                writer.println("<input type=\"hidden\" name=\"" + this.indexProperty + "\" value=\"" + startIndex + "\"/>");
                this.setPageContextFlg(this.pageContext, PAGELINKS_JAVASCRIPT_KEY + this.indexProperty);
            }
            if (!this.getPageContextFlg(this.pageContext, PAGELINKS_JAVASCRIPT_KEY + this.event) && this.forward) {
                writer.println("<input type=\"hidden\" name=\"" + this.event + "\" value=\"\"/>");
                this.setPageContextFlg(this.pageContext, PAGELINKS_JAVASCRIPT_KEY + this.event);
            }
            if (!this.getPageContextFlg(this.pageContext, PAGELINKS_JAVASCRIPT_KEY + "resetIndex") && this.resetIndex) {
                int endIndex;
                if (!"startIndex".equals(this.indexProperty)) {
                    writer.println("<input type=\"hidden\" name=\"startIndex\" value=\"" + startIndex + "\"/>");
                }
                if ((endIndex = startIndex + row - 1) >= totalCount) {
                    writer.println("<input type=\"hidden\" name=\"endIndex\" value=\"" + (totalCount - 1) + "\"/>");
                } else {
                    writer.println("<input type=\"hidden\" name=\"endIndex\" value=\"" + endIndex + "\"/>");
                }
                this.setPageContextFlg(this.pageContext, PAGELINKS_JAVASCRIPT_KEY + "resetIndex");
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
            throw new JspTagException(e.toString());
        }
    }

    protected void addSubmitJS() throws JspException {
        if (this.getPageContextFlg(this.pageContext, PAGELINKS_JAVASCRIPT_KEY)) {
            return;
        }
        JspWriter writer = this.pageContext.getOut();
        try {
            writer.println("");
            writer.println("<script type=\"text/javascript\">");
            writer.println("<!--");
            writer.println("  if(typeof(teralib) === \"undefined\"){");
            writer.println("    teralib = {};");
            writer.println("  }");
            writer.println("  teralib.pageLinkSubmit = function(rowProperty, indexProperty, row, startIndex){");
            writer.println("    var submitForm = document.getElementById('" + this.formName + "_pageLinks');");
            writer.println("    submitForm[rowProperty].value = row;");
            writer.println("    submitForm[indexProperty].value = startIndex;");
            if (this.forward) {
                writer.println("    submitForm." + this.event + ".value = \"" + FORWARD_NAME + "\";");
            }
            writer.println("    submitForm.submit();");
            writer.println("  }");
            writer.println("// -->");
            writer.println("</script>");
            writer.println("");
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
            throw new JspException(e.toString());
        }
        this.setPageContextFlg(this.pageContext, PAGELINKS_JAVASCRIPT_KEY);
    }

    protected void addFirstSubmit(StringBuilder sb, int row, int startIndex, int totalCount) {
        String startKey = FIRST_LINKS + CHAR_LINKS;
        String startValue = (String)this.links.get(startKey);
        if (startValue != null && !"".equals(startValue)) {
            if (startIndex == 0 || totalCount <= 0) {
                PageLinksTagEx.appendIfNotEmpty(sb, this.startDisableTag, this.startPageTag);
                sb.append(startValue);
                PageLinksTagEx.appendIfNotEmpty(sb, this.endDisableTag, this.endPageTag);
            } else {
                PageLinksTagEx.appendIfNotEmpty(sb, this.startFirstTag, this.startPrevTag, this.startPageTag);
                this.appendSubmitAnchor(sb, this.rowProperty, row, this.indexProperty, 0, startValue);
                PageLinksTagEx.appendIfNotEmpty(sb, this.endFirstTag, this.endPrevTag, this.endPageTag);
            }
        }
    }

    protected void addPrevSubmit(StringBuilder sb, int row, int startIndex, int totalCount) {
        for (int i = this.maxLinkNo; i > 0; --i) {
            String linkKey = PREV_LINKS + i + CHAR_LINKS;
            String linkValue = (String)this.links.get(linkKey);
            if (linkValue == null || "".equals(linkValue)) continue;
            int index = startIndex - i * row;
            if (index < 0) {
                PageLinksTagEx.appendIfNotEmpty(sb, this.startDisableTag, this.startPageTag);
                sb.append(linkValue);
                PageLinksTagEx.appendIfNotEmpty(sb, this.endDisableTag, this.endPageTag);
                continue;
            }
            PageLinksTagEx.appendIfNotEmpty(sb, this.startPrevTag, this.startPageTag);
            this.appendSubmitAnchor(sb, this.rowProperty, row, this.indexProperty, index, linkValue);
            PageLinksTagEx.appendIfNotEmpty(sb, this.endPrevTag, this.endPageTag);
        }
    }

    protected void addDirectSubmit(StringBuilder sb, int row, int startIndex, int totalCount) {
        this.addDirectAnchor(sb, row, startIndex, totalCount);
    }

    protected void addNextSubmit(StringBuilder sb, int row, int startIndex, int totalCount) {
        for (int i = 1; i <= this.maxLinkNo; ++i) {
            String linkKey = NEXT_LINKS + i + CHAR_LINKS;
            String linkValue = (String)this.links.get(linkKey);
            if (linkValue == null || "".equals(linkValue)) continue;
            int index = startIndex + i * row;
            if (index > totalCount - 1) {
                PageLinksTagEx.appendIfNotEmpty(sb, this.startDisableTag, this.startPageTag);
                sb.append(linkValue);
                PageLinksTagEx.appendIfNotEmpty(sb, this.endDisableTag, this.endPageTag);
                continue;
            }
            PageLinksTagEx.appendIfNotEmpty(sb, this.startNextTag, this.startPageTag);
            this.appendSubmitAnchor(sb, this.rowProperty, row, this.indexProperty, index, linkValue);
            PageLinksTagEx.appendIfNotEmpty(sb, this.endNextTag, this.endPageTag);
        }
    }

    protected void addLastSubmit(StringBuilder sb, int row, int startIndex, int totalCount) {
        String endKey = LAST_LINKS + CHAR_LINKS;
        String endValue = (String)this.links.get(endKey);
        int endPageStartIndex = this.getEndPageStartIndex(row, totalCount);
        if (endValue != null && !"".equals(endValue)) {
            if (endPageStartIndex == startIndex || totalCount <= 0) {
                PageLinksTagEx.appendIfNotEmpty(sb, this.startDisableTag, this.startPageTag);
                sb.append(endValue);
                PageLinksTagEx.appendIfNotEmpty(sb, this.endDisableTag, this.endPageTag);
            } else {
                PageLinksTagEx.appendIfNotEmpty(sb, this.startLastTag, this.startNextTag, this.startPageTag);
                this.appendSubmitAnchor(sb, this.rowProperty, row, this.indexProperty, endPageStartIndex, endValue);
                PageLinksTagEx.appendIfNotEmpty(sb, this.endLastTag, this.endNextTag, this.endPageTag);
            }
        }
    }

    protected void addFirstLink(StringBuilder sb, int row, int startIndex, int totalCount) {
        String startKey = FIRST_LINKS + CHAR_LINKS;
        String startValue = (String)this.links.get(startKey);
        if (startValue != null && !"".equals(startValue)) {
            if (startIndex == 0 || totalCount <= 0) {
                PageLinksTagEx.appendIfNotEmpty(sb, this.startDisableTag, this.startPageTag);
                sb.append(startValue);
                PageLinksTagEx.appendIfNotEmpty(sb, this.endDisableTag, this.endPageTag);
            } else {
                PageLinksTagEx.appendIfNotEmpty(sb, this.startFirstTag, this.startPrevTag, this.startPageTag);
                this.appendLinkAnchor(sb, this.rowProperty, row, this.indexProperty, 0, startValue);
                PageLinksTagEx.appendIfNotEmpty(sb, this.endFirstTag, this.endPrevTag, this.endPageTag);
            }
        }
    }

    protected void addPrevLink(StringBuilder sb, int row, int startIndex, int totalCount) {
        for (int i = this.maxLinkNo; i > 0; --i) {
            String linkKey = PREV_LINKS + i + CHAR_LINKS;
            String linkValue = (String)this.links.get(linkKey);
            if (linkValue == null || "".equals(linkValue)) continue;
            int index = startIndex - i * row;
            if (index < 0) {
                PageLinksTagEx.appendIfNotEmpty(sb, this.startDisableTag, this.startPageTag);
                sb.append(linkValue);
                PageLinksTagEx.appendIfNotEmpty(sb, this.endDisableTag, this.endPageTag);
                continue;
            }
            PageLinksTagEx.appendIfNotEmpty(sb, this.startPrevTag, this.startPageTag);
            this.appendLinkAnchor(sb, this.rowProperty, row, this.indexProperty, index, linkValue);
            PageLinksTagEx.appendIfNotEmpty(sb, this.endPrevTag, this.endPageTag);
        }
    }

    protected void addDirectLink(StringBuilder sb, int row, int startIndex, int totalCount) {
        this.addDirectAnchor(sb, row, startIndex, totalCount);
    }

    protected void addNextLink(StringBuilder sb, int row, int startIndex, int totalCount) {
        for (int i = 1; i <= this.maxLinkNo; ++i) {
            String linkKey = NEXT_LINKS + i + CHAR_LINKS;
            String linkValue = (String)this.links.get(linkKey);
            if (linkValue == null || "".equals(linkValue)) continue;
            int index = startIndex + i * row;
            if (index > totalCount - 1) {
                PageLinksTagEx.appendIfNotEmpty(sb, this.startDisableTag, this.startPageTag);
                sb.append(linkValue);
                PageLinksTagEx.appendIfNotEmpty(sb, this.endDisableTag, this.endPageTag);
                continue;
            }
            PageLinksTagEx.appendIfNotEmpty(sb, this.startNextTag, this.startPageTag);
            this.appendLinkAnchor(sb, this.rowProperty, row, this.indexProperty, index, linkValue);
            PageLinksTagEx.appendIfNotEmpty(sb, this.endNextTag, this.endPageTag);
        }
    }

    protected void addLastLink(StringBuilder sb, int row, int startIndex, int totalCount) {
        String endKey = LAST_LINKS + CHAR_LINKS;
        String endValue = (String)this.links.get(endKey);
        int endPageStartIndex = this.getEndPageStartIndex(row, totalCount);
        if (endValue != null && !"".equals(endValue)) {
            if (endPageStartIndex == startIndex || totalCount <= 0) {
                PageLinksTagEx.appendIfNotEmpty(sb, this.startDisableTag, this.startPageTag);
                sb.append(endValue);
                PageLinksTagEx.appendIfNotEmpty(sb, this.endDisableTag, this.endPageTag);
            } else {
                PageLinksTagEx.appendIfNotEmpty(sb, this.startLastTag, this.startNextTag, this.startPageTag);
                this.appendLinkAnchor(sb, this.rowProperty, row, this.indexProperty, endPageStartIndex, endValue);
                PageLinksTagEx.appendIfNotEmpty(sb, this.endLastTag, this.endNextTag, this.endPageTag);
            }
        }
    }

    protected void addJumpFormJS(int row, int pageIndex, int pageCount) throws JspException {
        if (this.getPageContextFlg(this.pageContext, PAGEJUMP_JAVASCRIPT_KEY)) {
            return;
        }
        JspWriter writer = this.pageContext.getOut();
        try {
            writer.println("");
            writer.println("<script type=\"text/javascript\">");
            writer.println("<!--");
            writer.println("  if(typeof(teralib) === \"undefined\"){");
            writer.println("    teralib = {};");
            writer.println("  }");
            writer.println("  teralib.pageLinkJump = function(form, row, indexProperty){");
            writer.println("    var jump = form.elements['jumpIndex'];");
            writer.println("    var index = form.elements[indexProperty];");
            writer.println("    var idx;");
            writer.println("    var jumpValue = parseInt(jump.value,10);");
            writer.println("    if( jumpValue == " + pageIndex + " ){");
            writer.println("      return false;");
            writer.println("    } else if( 0 < jumpValue ){");
            writer.println("      idx = (jumpValue -1) * " + row + ";");
            writer.println("      index.value = idx;");
            writer.println("      return true;");
            writer.println("    } else {");
            writer.println("      return false;");
            writer.println("    }");
            writer.println("  }");
            writer.println("// -->");
            writer.println("</script>");
            writer.println("");
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
            throw new JspTagException(e.toString());
        }
        this.setPageContextFlg(this.pageContext, PAGEJUMP_JAVASCRIPT_KEY);
    }

    protected void addJumpForm(StringBuilder sb, int row, int startIndex) {
        PageLinksTagEx.appendIfNotEmpty(sb, this.startJumpFormTag, this.startPageTag);
        sb.append("<form name=\"");
        sb.append(this.name);
        sb.append("\" method=\"post\" action=\"");
        sb.append(this.url);
        sb.append("\" onsubmit=\"return teralib.pageLinkJump(this, ");
        sb.append(row).append(",'");
        sb.append(this.indexProperty);
        sb.append("')\"/>");
        sb.append("<input type=\"hidden\" name=\"");
        sb.append(this.rowProperty);
        sb.append("\" value=\"");
        sb.append(row);
        sb.append("\"/>");
        sb.append("<input type=\"hidden\" name=\"");
        sb.append(this.indexProperty);
        sb.append("\"/>");
        sb.append("<input type=\"text\" name=\"jumpIndex\" ");
        sb.append(this.jumpFormTextAttributes);
        sb.append("/>");
        sb.append("<input type=\"submit\" value=\"");
        sb.append(this.jumpFormSubmitValue);
        sb.append("\" ");
        sb.append(this.jumpFormSubmitAttributes);
        sb.append("/>");
        sb.append("</form>");
        PageLinksTagEx.appendIfNotEmpty(sb, this.endJumpFormTag, this.endPageTag);
    }

    protected void appendLinkAnchor(StringBuilder sb, String rowProperty, int row, String indexProperty, int startIndex, String text) {
        sb.append("<a href=\"" + this.url);
        if (this.url.indexOf("?") < 0) {
            sb.append("?");
        } else {
            sb.append("&");
        }
        sb.append(rowProperty).append("=").append(row);
        sb.append("&").append(indexProperty).append("=").append(startIndex);
        sb.append("\">");
        sb.append(text);
        sb.append("</a>");
    }

    protected void appendSubmitAnchor(StringBuilder sb, String rowProperty, int row, String indexProperty, int startIndex, String text) {
        sb.append("<a href=\"#\" onclick=\"return teralib.pageLinkSubmit('");
        sb.append(rowProperty).append("','");
        sb.append(indexProperty).append("',");
        sb.append(row).append(",");
        sb.append(startIndex).append(")\">");
        sb.append(text);
        sb.append("</a>");
    }

    protected void addDirectAnchor(StringBuilder sb, int row, int startIndex, int totalCount) {
        String directLinkNo = (String)this.links.get(MAX_DSP_SIZE);
        if (directLinkNo != null) {
            try {
                this.maxPageCount = Integer.parseInt(directLinkNo);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        int pageCount = this.getPageCount(row, totalCount);
        int pageIndex = this.getPageIndex(row, startIndex);
        int startPage = 0;
        int endPage = 0;
        if (pageCount > this.maxPageCount && pageIndex > this.maxPageCount / 2) {
            endPage = this.maxPageCount;
            startPage = pageIndex - endPage / 2 - 1;
            if (startPage + endPage > pageCount) {
                startPage = pageCount - endPage;
            }
        } else {
            endPage = pageCount < this.maxPageCount ? pageCount : this.maxPageCount;
            startPage = 0;
        }
        int size = startPage + endPage;
        for (int i = startPage; i < size; ++i) {
            int idx = i + 1;
            if (pageIndex == idx) {
                this.appendActiveTag(sb, idx);
                continue;
            }
            sb.append(this.startPageTag);
            if (this.submit) {
                this.appendSubmitAnchor(sb, this.rowProperty, row, this.indexProperty, i * row, String.valueOf(idx));
            } else {
                this.appendLinkAnchor(sb, this.rowProperty, row, this.indexProperty, i * row, String.valueOf(idx));
            }
            sb.append(this.endPageTag);
        }
    }

    protected void appendActiveTag(StringBuilder sb, int idx) {
        PageLinksTagEx.appendIfNotEmpty(sb, this.startActiveTag, this.startPageTag);
        sb.append(idx);
        PageLinksTagEx.appendIfNotEmpty(sb, this.endActiveTag, this.endPageTag);
    }

    protected int getEndPageStartIndex(int row, int totalCount) {
        int endPage = this.getPageCount(row, totalCount);
        int endPageStartIndex = endPage * row - row;
        return endPageStartIndex;
    }

    static void appendIfNotEmpty(StringBuilder sb, String value, String defaultValue) {
        if (value != null && !"".equals(value)) {
            sb.append(value);
        } else if (defaultValue != null) {
            sb.append(defaultValue);
        }
    }

    static void appendIfNotEmpty(StringBuilder sb, String value1, String value2, String defaultValue) {
        if (value1 != null && !"".equals(value1)) {
            sb.append(value1);
        } else {
            PageLinksTagEx.appendIfNotEmpty(sb, value2, defaultValue);
        }
    }

    private void getLinkProperty() {
        Enumeration enume = PropertyUtil.getPropertyNames((String)PAGE_LINKS_PREFIX);
        while (enume.hasMoreElements()) {
            String propName = (String)enume.nextElement();
            String id = propName.substring(PAGE_LINKS_PREFIX.length());
            String link = PropertyUtil.getProperty((String)propName);
            if (id != null && (id.startsWith(PREV_LINKS) || id.startsWith(NEXT_LINKS))) {
                String strLinkNo = id.substring(4, id.lastIndexOf(CHAR_LINKS));
                int intLinkNo = 0;
                try {
                    intLinkNo = Integer.parseInt(strLinkNo);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                if (intLinkNo > this.maxLinkNo) {
                    this.maxLinkNo = intLinkNo;
                }
                this.links.put(id, link);
                continue;
            }
            if (id != null && id.startsWith(FIRST_LINKS) || id.startsWith(LAST_LINKS)) {
                this.links.put(id, link);
                continue;
            }
            if (!MAX_DSP_SIZE.equals(id)) continue;
            this.links.put(id, link);
        }
    }

    private void initTagProperty() {
        this.startPageLinksTag = PropertyUtil.getProperty((String)START_PAGELINKS_TAG, (String)"");
        this.endPageLinksTag = PropertyUtil.getProperty((String)END_PAGELINKS_TAG, (String)"");
        this.startPageTag = PropertyUtil.getProperty((String)START_PAGE_TAG, (String)"");
        this.endPageTag = PropertyUtil.getProperty((String)END_PAGE_TAG, (String)"");
        this.startPrevTag = PropertyUtil.getProperty((String)START_PREV_TAG, (String)"");
        this.endPrevTag = PropertyUtil.getProperty((String)END_PREV_TAG, (String)"");
        this.startNextTag = PropertyUtil.getProperty((String)START_NEXT_TAG, (String)"");
        this.endNextTag = PropertyUtil.getProperty((String)END_NEXT_TAG, (String)"");
        this.startFirstTag = PropertyUtil.getProperty((String)START_FIRST_TAG, (String)"");
        this.endFirstTag = PropertyUtil.getProperty((String)END_FIRST_TAG, (String)"");
        this.startLastTag = PropertyUtil.getProperty((String)START_LAST_TAG, (String)"");
        this.endLastTag = PropertyUtil.getProperty((String)END_LAST_TAG, (String)"");
        this.startActiveTag = PropertyUtil.getProperty((String)START_ACTIVE_TAG, (String)"");
        this.endActiveTag = PropertyUtil.getProperty((String)END_ACTIVE_TAG, (String)"");
        this.startDisableTag = PropertyUtil.getProperty((String)START_DISABLE_TAG, (String)"");
        this.endDisableTag = PropertyUtil.getProperty((String)END_DISABLE_TAG, (String)"");
        this.startJumpFormTag = PropertyUtil.getProperty((String)START_JUMPFORM_TAG, (String)"");
        this.endJumpFormTag = PropertyUtil.getProperty((String)END_JUMPFORM_TAG, (String)"");
        this.jumpFormTextAttributes = PropertyUtil.getProperty((String)JUMPFORM_TEXT_ATTRIBUTES, (String)"");
        this.jumpFormSubmitAttributes = PropertyUtil.getProperty((String)JUMPFORM_SUBMIT_ATTRIBUTES, (String)"");
        this.jumpFormSubmitValue = PropertyUtil.getProperty((String)JUMPFORM_SUBMIT_VALUE, (String)JUMPFORM_SUBMIT_DEFAULT);
    }

    public void release() {
        super.release();
        this.startPageLinksTag = null;
        this.endPageLinksTag = null;
        this.startPageTag = null;
        this.endPageTag = null;
        this.startPrevTag = null;
        this.endPrevTag = null;
        this.startNextTag = null;
        this.endNextTag = null;
        this.startFirstTag = null;
        this.endFirstTag = null;
        this.startLastTag = null;
        this.endLastTag = null;
        this.startActiveTag = null;
        this.endActiveTag = null;
        this.startDisableTag = null;
        this.endDisableTag = null;
        this.startJumpFormTag = null;
        this.endJumpFormTag = null;
        this.jumpFormTextAttributes = null;
        this.jumpFormSubmitAttributes = null;
        this.jumpFormSubmitValue = JUMPFORM_SUBMIT_DEFAULT;
        this.url = null;
        this.pageJump = false;
    }
}

