/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.struts.actions;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.service.thin.BLogicIO;
import jp.terasoluna.fw.service.thin.BLogicIOUtil;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.web.struts.action.ActionMappingEx;
import jp.terasoluna.fw.web.struts.actions.AbstractBLogicAction;
import jp.terasoluna.fw.web.struts.actions.DownloadProcessor;
import jp.terasoluna.fw.web.struts.actions.FileDownloadUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationBLogicAction<P>
extends AbstractBLogicAction<P> {
    private static Log log = LogFactory.getLog(AbstractAnnotationBLogicAction.class);
    protected DownloadProcessor downloadProcessor = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward doExecute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("*** doExecute() called. action path=[" + mapping.getPath() + "] ***"));
        }
        ActionMappingEx mappingEx = null;
        try {
            mappingEx = (ActionMappingEx)mapping;
        }
        catch (ClassCastException e) {
            log.error((Object)"Illegal ActionMapping.");
            throw new SystemException((Throwable)e, "errors.blogic.mapping");
        }
        P params = this.getBLogicParams(mappingEx, request, response);
        if (log.isDebugEnabled()) {
            log.debug((Object)"*** BLogicParams is prepared. ***");
            if (params != null) {
                log.debug((Object)("BLogicParams:" + params.toString()));
            } else {
                log.debug((Object)"BLogicParams:null");
            }
        }
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("*** starting blogic action[");
            sb.append(this.getTargetClass().getName()).append("] ***");
            log.debug((Object)sb.toString());
        }
        BLogicResult result = null;
        this.preDoExecuteBLogic(request, response, params);
        try {
            result = this.doExecuteBLogic(params);
        }
        finally {
            this.postDoExecuteBLogic(request, response, params, result);
        }
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("*** finished blogic action[");
            sb.append(this.getTargetClass().getName()).append("] ***");
            log.debug((Object)sb.toString());
        }
        if (result != null) {
            this.evaluateBLogicResult(result, request, response, mappingEx);
            return mapping.findForward(result.getResultString());
        }
        log.error((Object)"BLogicResult is null.");
        throw new SystemException((Throwable)new NullPointerException(), "errors.blogic.result.null");
    }

    protected P getBLogicParams(ActionMappingEx mapping, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Class<?> targetClass = this.getTargetClass();
        Class<Object> inputBeanClass = null;
        inputBeanClass = BLogicIOUtil.getInputClassCache(targetClass);
        if (inputBeanClass == null) {
            inputBeanClass = this.getInputBeanClass();
            BLogicIOUtil.setInputClassCache(targetClass, inputBeanClass);
        }
        BLogicIO io = BLogicIOUtil.createBLogicIOForBLogicParams(inputBeanClass);
        Object bean = this.getBLogicMapper(request).mapBLogicParams(request, response, io);
        return (P)bean;
    }

    protected Class<?> getTargetClass() {
        if (AopUtils.isAopProxy((Object)((Object)this))) {
            return AopUtils.getTargetClass((Object)((Object)this));
        }
        return ((Object)((Object)this)).getClass();
    }

    protected void processBLogicResult(BLogicResult result, HttpServletRequest request, HttpServletResponse response, ActionMappingEx mappingEx) {
        Object resultObject = null;
        Class<?> resultClass = null;
        BLogicIO io = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"*** setting result into web layer. ***");
        }
        if (result != null) {
            resultObject = result.getResultObject();
        }
        if (resultObject != null) {
            resultClass = resultObject.getClass();
        }
        if (resultClass != null && (io = BLogicIOUtil.getBlogicResultCache(resultClass)) == null && (io = BLogicIOUtil.createBLogicIOForBLogicResult(resultClass)) != null) {
            BLogicIOUtil.setBlogicResultCache(resultClass, io);
        }
        this.getBLogicMapper(request).mapBLogicResult(request, response, io, result);
        if (result.getResultString() == null) {
            this.processDownload(resultObject, result, request, response, mappingEx);
        }
    }

    protected void processDownload(Object resultObject, BLogicResult result, HttpServletRequest request, HttpServletResponse response, ActionMappingEx mappingEx) {
        if (this.downloadProcessor != null) {
            this.downloadProcessor.processDownload(resultObject, result, request, response, mappingEx);
        } else {
            FileDownloadUtil.download((Object)resultObject, (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    protected Class<P> getInputBeanClass() {
        return this.getInputBeanClass((Object)this);
    }

    protected Class<P> getInputBeanClass(Object blogic) {
        Class<?> childClass = null;
        childClass = AopUtils.isAopProxy((Object)blogic) ? AopUtils.getTargetClass((Object)blogic) : blogic.getClass();
        while (childClass.getSuperclass() != AbstractAnnotationBLogicAction.class) {
            childClass = childClass.getSuperclass();
        }
        Type terasolunaControllerType = childClass.getGenericSuperclass();
        if (!(terasolunaControllerType instanceof ParameterizedType)) {
            log.error((Object)"Controller class must be set ParameterizedType");
            throw new IllegalStateException("Controller class must be set ParameterizedType");
        }
        ParameterizedType pt = (ParameterizedType)terasolunaControllerType;
        Type type = pt.getActualTypeArguments()[0];
        if (type instanceof Class) {
            return (Class)type;
        }
        return null;
    }

    @Autowired(required=false)
    public void setDownloadProcessor(DownloadProcessor downloadProcessor) {
        this.downloadProcessor = downloadProcessor;
    }
}

