/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.ex.web.thin;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ParameterTrimmedHttpServletRequest
extends HttpServletRequestWrapper {
    private String trimPattern;

    public ParameterTrimmedHttpServletRequest(HttpServletRequest request, String trimPattern) {
        super(request);
        this.trimPattern = trimPattern;
    }

    public final String getParameter(String name) {
        String value = super.getParameter(name);
        return this.trim(value);
    }

    public final String[] getParameterValues(String name) {
        String[] values = super.getParameterValues(name);
        if (values == null) {
            return null;
        }
        String[] trimmedValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            trimmedValues[i] = this.trim(values[i]);
        }
        return trimmedValues;
    }

    public final Map getParameterMap() {
        Map map = super.getParameterMap();
        if (map == null) {
            return null;
        }
        HashMap<String, String[]> trimmedMap = new HashMap<String, String[]>();
        Iterator it = map.keySet().iterator();
        String[] trimmedValues = null;
        while (it.hasNext()) {
            String key = (String)it.next();
            String[] values = (String[])map.get(key);
            if (values != null) {
                trimmedValues = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    trimmedValues[i] = this.trim(values[i]);
                }
            }
            trimmedMap.put(key, trimmedValues);
        }
        return trimmedMap;
    }

    protected final String trim(String value) {
        if (value == null) {
            return null;
        }
        return value.replaceAll(this.trimPattern, "");
    }
}

