/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.ex.web.thin;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SetCharacterEncodingFilter
implements Filter {
    private static Log log = LogFactory.getLog(SetCharacterEncodingFilter.class);
    private static final String THRU_FILTER_KEY = "THRU_FILTER_ENCODING";
    private boolean moreFlag = false;
    private String encoding = null;
    private boolean ignoreFlag = false;

    public void init(FilterConfig filterConfig) throws ServletException {
        String moreValue;
        String ignoreValue;
        if (log.isDebugEnabled()) {
            log.debug((Object)"init() called.");
        }
        String encode = filterConfig.getInitParameter("encoding");
        try {
            if (!Charset.isSupported(encode)) {
                log.warn((Object)(encode + " is unsupported encoding."));
            } else {
                this.encoding = encode;
            }
        }
        catch (IllegalCharsetNameException e) {
            log.warn((Object)"The format of encoding is not correct.");
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)"encoding can not be null.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("this.encoding = " + this.encoding));
        }
        if ((ignoreValue = filterConfig.getInitParameter("ignore")) != null) {
            this.ignoreFlag = this.createFlag(ignoreValue);
        }
        if ((moreValue = filterConfig.getInitParameter("more")) != null) {
            this.moreFlag = this.createFlag(moreValue);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.moreFlag && request.getAttribute(THRU_FILTER_KEY) != null) {
            chain.doFilter(request, response);
            return;
        }
        if (!this.ignoreFlag && this.encoding != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("set encoding(" + this.encoding + ") to request."));
            }
            request.setCharacterEncoding(this.encoding);
        }
        request.setAttribute(THRU_FILTER_KEY, (Object)THRU_FILTER_KEY);
        chain.doFilter(request, response);
    }

    public void destroy() {
        this.encoding = null;
    }

    private boolean createFlag(String value) {
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        return "yes".equalsIgnoreCase(value);
    }
}

