/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.service.thin.BLogicIO;
import jp.terasoluna.fw.service.thin.BLogicIOUtil;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.web.struts.action.ActionMappingEx;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * rWlXWbNo̓Ame[VΉrWlXWbNNۃANVNXB
 * <p>
 * rWlXWbNo͒`LqɁA rWlXWbNo̓NX̃tB[hɐp̃Ame[V t^邱ƂłB<br>
 * ɂrWlXWbNo͒`̋Lqȗ邱ƂłB
 * </p>
 * <p>
 * resultStringnullŃUgIuWFNg{@link AbstractDownloadObject}̌pNXA<br>
 * UgIuWFNg{@link AbstractDownloadObject}̌pNX̃tB[hꍇ̓_E[hsB<br>
 * ܂A_E[h{@link DownloadProcessor}̎NXDI邱ƂŁA_E[h̓eύX邱ƂłB<br>
 * </p>
 * @param <P> rWlXWbNւ̓͒lƂȂJavaBeaň^
 * @see jp.terasoluna.fw.web.struts.actions.AbstractBLogicAction
 * @see jp.terasoluna.fw.web.struts.actions.AnnotationBLogicAction
 * @see jp.terasoluna.fw.web.struts.actions.DownloadProcessor
 */
public abstract class AbstractAnnotationBLogicAction<P> extends
                                                        AbstractBLogicAction<P> {

    /** Oo̓IuWFNg */
    private static Log log = LogFactory
            .getLog(AbstractAnnotationBLogicAction.class);

    /** _E[h */
    protected DownloadProcessor downloadProcessor = null;

    /**
     * rWlXWbNsB
     * <p>
     * OꍇłAK㏈sB
     */
    @Override
    public ActionForward doExecute(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response)
                                                                     throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("*** doExecute() called. action path=["
                    + mapping.getPath() + "] ***");
        }
        ActionMappingEx mappingEx = null;
        try {
            mappingEx = (ActionMappingEx) mapping;
        } catch (ClassCastException e) {
            log.error("Illegal ActionMapping.");
            throw new SystemException(e, BLOGIC_MAPPING_ILLEGAL_ERROR);
        }
        P params = getBLogicParams(mappingEx, request, response);
        if (log.isDebugEnabled()) {
            log.debug("*** BLogicParams is prepared. ***");
            if (params != null) {
                // params̐ݒ_vB
                log.debug("BLogicParams:" + params.toString());
            } else {
                // paramsnull̏ꍇ
                log.debug("BLogicParams:null");
            }
        }
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("*** starting blogic action[");
            sb.append(getTargetClass().getName()).append("] ***");
            log.debug(sb.toString());
        }
        BLogicResult result = null;
        // O
        preDoExecuteBLogic(request, response, params);
        try {
            // rWlXWbNN
            result = doExecuteBLogic(params);
        } finally {
            // ㏈
            postDoExecuteBLogic(request, response, params, result);
        }
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("*** finished blogic action[");
            sb.append(getTargetClass().getName()).append("] ***");
            log.debug(sb.toString());
        }
        if (result != null) {
            // BLogicResultnullŕԋpȂꍇ̂
            // ]sB
            evaluateBLogicResult(result, request, response, mappingEx);
            // ActionForward擾
            return mapping.findForward(result.getResultString());
        }
        log.error("BLogicResult is null.");
        // nullŕԋpꂽꍇSystemExceptionX[B
        throw new SystemException(new NullPointerException(),
                BLOGIC_RESULT_NULL_ERROR);
    }

    /**
     * v[e[Vwl擾ArWlXWbN͏IuWFNg\zĕԂB
     * @param mapping ANV}bsO
     * @param request NGXg
     * @param response X|X
     * @return rWlXWbN͏IuWFNg
     * @throws Exception \ʗOꍇ
     */
    @SuppressWarnings("unchecked")
    protected P getBLogicParams(ActionMappingEx mapping,
            HttpServletRequest request, HttpServletResponse response)
                                                                     throws Exception {
        Class<?> targetClass = getTargetClass();
        Class<P> inputBeanClass = null;

        // BLogic̓̓NX̃LbV擾
        inputBeanClass = (Class<P>) BLogicIOUtil
                .getInputClassCache(targetClass);

        if (inputBeanClass == null) {
            inputBeanClass = getInputBeanClass();
            // BLogic̓̓NX̃LbVɊi[
            BLogicIOUtil.setInputClassCache(targetClass, inputBeanClass);
        }

        // rWlXWbN͏NXBLogicIO擾
        BLogicIO io = BLogicIOUtil
                .createBLogicIOForBLogicParams(inputBeanClass);

        // tH[AZbV̐ݒl擾
        P bean = (P) getBLogicMapper(request).mapBLogicParams(request,
                response, io);

        return bean;
    }

    /**
     * ^[QbgNX擾
     * @return ^[QbgNX
     */
    protected Class<?> getTargetClass() {
        // AOPĂꍇɃ^[QbgNX擾
        if (AopUtils.isAopProxy(this)) {
            return AopUtils.getTargetClass(this);
        }
        return this.getClass();
    }

    /**
     * BLogicResultWebw̃IuWFNgւ̌ʔfsB
     * <p>
     * resultStringnullŁA<code>resultObject</code>ȉ̏ꍇA _E[hsB
     * <ul>
     * <li>{@link AbstractDownloadObject}pNXłꍇ</li>
     * <li>{@link AbstractDownloadObject}pNXvpeBƂĂPꍇ</li>
     * </ul>
     * L{@link DownloadProcessor}ݒ肵ȂꍇB<br>
     * {@link DownloadProcessor}ݒ肵ꍇ́uresultStringnullł邱ƁvȊȌDownloadProcessor̎ɏ]B
     * </p>
     */
    @Override
    protected void processBLogicResult(BLogicResult result,
            HttpServletRequest request, HttpServletResponse response,
            ActionMappingEx mappingEx) {
        Object resultObject = null;
        Class<?> resultClass = null;
        BLogicIO io = null;

        if (log.isDebugEnabled()) {
            log.debug("*** setting result into web layer. ***");
        }

        if (result != null) {
            resultObject = result.getResultObject();
        }

        if (resultObject != null) {
            resultClass = resultObject.getClass();
        }

        if (resultClass != null) {
            io = BLogicIOUtil.getBlogicResultCache(resultClass);

            if (io == null) {
                io = BLogicIOUtil.createBLogicIOForBLogicResult(resultClass);

                if (io != null) {
                    BLogicIOUtil.setBlogicResultCache(resultClass, io);
                }
            }
        }

        getBLogicMapper(request).mapBLogicResult(request, response, io, result);

        if (result.getResultString() == null) {
            processDownload(resultObject, result, request, response, mappingEx);
        }
    }

    /**
     * _E[h
     * @param resultObject UgIuWFNg
     * @param result BLogicResult
     * @param request HttpServletRequest
     * @param response HttpServletRequest
     * @param mappingEx ActionMappingEx
     */
    protected void processDownload(Object resultObject, BLogicResult result,
            HttpServletRequest request, HttpServletResponse response,
            ActionMappingEx mappingEx) {
        if (downloadProcessor != null) {
            downloadProcessor.processDownload(resultObject, result, request,
                    response, mappingEx);
        } else {
            FileDownloadUtil.download(resultObject, request, response);
        }
    }

    /**
     * NX̃TuNXɒ`ꂽAR}hNX̎^Cv擾B
     * @return ̓NX̌^B
     */
    protected Class<P> getInputBeanClass() {
        return getInputBeanClass(this);
    }

    /**
     * NX̃TuNXɒ`ꂽAR}hNX̎^Cv擾B
     * @return ̓NX̌^B
     */
    @SuppressWarnings("unchecked")
    protected Class<P> getInputBeanClass(Object blogic) {
        Class childClass = null;
        if (AopUtils.isAopProxy(blogic)) {
            childClass = AopUtils.getTargetClass(blogic);
        } else {
            childClass = blogic.getClass();
        }

        // Qȏ̌pĂꍇA
        // TerasolunaController̎qɂNX擾
        while (childClass.getSuperclass() != AbstractAnnotationBLogicAction.class) {
            childClass = childClass.getSuperclass();
        }

        // TerasolunaControlleř^i^p[^̏tj
        Type terasolunaControllerType = childClass.getGenericSuperclass();
        if (!(terasolunaControllerType instanceof ParameterizedType)) {
            log.error("Controller class must be set ParameterizedType");
            throw new IllegalStateException(
                    "Controller class must be set ParameterizedType");
        }
        ParameterizedType pt = (ParameterizedType) terasolunaControllerType;

        // ^p[^
        Type type = pt.getActualTypeArguments()[0];
        if (type instanceof Class) {
            return (Class<P>) type;
        }
        return null;
    }

    /**
     * _E[hݒ肷
     * @param downloadProcessor the downloadProcessor to set
     */
    @Autowired(required = false)
    public void setDownloadProcessor(DownloadProcessor downloadProcessor) {
        this.downloadProcessor = downloadProcessor;
    }
}
