/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.plugins;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

import javax.servlet.ServletException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.ValidatorResources;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.validator.ValidatorPlugIn;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;
import org.xml.sax.SAXException;

/**
 * gValidatorPlugInNXłB ChJ[hŎw肵pXɃ}b`̓`FbNݒt@Civalidation.xmlj[hAT[ubgReLXgɕۑ悤ɁA
 * Struts񋟂ValidatorPlugIngĂ܂B
 */
public class ValidatorPlugInEx extends ValidatorPlugIn {

    /**
     * OCX^X
     */
    private static Log log = LogFactory.getLog(ValidatorPlugInEx.class);

    /**
     * ANVT[ubg
     */
    private ActionServlet servlet;

    /**
     * vOC܂B
     * @see org.apache.struts.validator.ValidatorPlugIn#init(org.apache.struts.action.ActionServlet,
     *      org.apache.struts.config.ModuleConfig)
     */
    @Override
    public void init(ActionServlet servlet, ModuleConfig config)
                                                                throws ServletException {
        this.servlet = servlet;
        super.init(servlet, config);
    }

    /**
     * \[X܂BResourcePatternResolver𗘗pAChJ[hŎw肵pXɃ}b`̓`FbNݒt@Ci validation.xmlj[h܂B
     * @see org.apache.struts.validator.ValidatorPlugIn#initResources()
     */
    @Override
    protected void initResources() throws IOException, ServletException {
        String pathnames = getPathnames();
        if (pathnames == null || pathnames.length() <= 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(pathnames, ",");

        List<InputStream> streamList = new ArrayList<InputStream>();
        try {
            while (st.hasMoreTokens()) {
                String validatorRules = st.nextToken().trim();
                ResourcePatternResolver resourcePatternResolver = new ServletContextResourcePatternResolver(
                        servlet.getServletContext());
                Resource[] resources = resourcePatternResolver
                        .getResources(validatorRules);
                for (Resource resource : resources) {
                    if (log.isInfoEnabled()) {
                        log.info("Loading validation rules file from '"
                                + resource + "'");
                    }
                    InputStream input = resource.getInputStream();
                    if (input != null) {
                        BufferedInputStream bis = new BufferedInputStream(input);
                        streamList.add(bis);
                    } else {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Skipping validation rules file from '");
                        sb.append(resource);
                        sb.append("'.  No stream could be opened.");
                        throw new ServletException(sb.toString());
                    }
                }
            }
            int streamSize = streamList.size();
            InputStream[] streamArray = new InputStream[streamSize];
            for (int streamIndex = 0; streamIndex < streamSize; streamIndex++) {
                InputStream is = (InputStream) streamList.get(streamIndex);
                streamArray[streamIndex] = is;
            }

            this.resources = new ValidatorResources(streamArray);
        } catch (SAXException e) {
            log.error("Skipping all validation", e);
            throw new ServletException(e);
        } finally {
            Iterator<InputStream> streamIterator = streamList.iterator();
            while (streamIterator.hasNext()) {
                InputStream is = streamIterator.next();
                is.close();
            }
        }

    }
}
