/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.web.thin;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

/**
 * <p>w肳ꂽK\p^[ɊÂăgꂽNGXgp[^ԂHttpServletRequest̎B</p>
 * 
 */
public class ParameterTrimmedHttpServletRequest extends
        HttpServletRequestWrapper {

    /**
     * NGXgp[^̃gɎgp鐳K\
     */
    private String trimPattern;

    /**
     * ParameterTrimmedHttpServletRequest̃CX^X\zB
     * 
     * @param request
     *            HttpServletRequest
     * @param trimPattern
     *            NGXgp[^̃gɎgp鐳K\
     */
    public ParameterTrimmedHttpServletRequest(HttpServletRequest request,
            String trimPattern) {
        super(request);
        this.trimPattern = trimPattern;
    }

    /**
     * gꂽp[^擾B
     * 
     * @param name
     *            擾p[^
     * @return gꂽp[^̒l
     * 
     * @see javax.servlet.ServletRequestWrapper#getParameter(java.lang.String)
     */
    @Override
    public final String getParameter(String name) {
        String value = super.getParameter(name);
        return trim(value);
    }

    /**
     * gꂽp[^̔z擾B
     * 
     * @param name
     *            擾p[^
     * @return gꂽp[^z
     * 
     * @see javax.servlet.ServletRequestWrapper#getParameterValues(java.lang.String)
     */
    @Override
    public final String[] getParameterValues(String name) {
        String[] values = super.getParameterValues(name);
        if (values == null) {
            return null;
        }
        String[] trimmedValues = new String[values.length];
        for (int i = 0; i < values.length; i++) {
            trimmedValues[i] = trim(values[i]);
        }
        return trimmedValues;
    }
    
    /**
     * gꂽp[^̃}bv擾B
     * 
     * @return gꂽp[^}bv
     * 
     * @see javax.servlet.ServletRequestWrapper#getParameterValues(java.lang.String)
     */
    @SuppressWarnings("unchecked")
    @Override
    public final Map getParameterMap() {
        Map<String, String[]> map = super.getParameterMap();
        if (map == null) {
            return null;
        }
        Map<String, String[]> trimmedMap = new HashMap<String, String[]>();
        Iterator<String> it = map.keySet().iterator();
        String[] trimmedValues = null;
        while (it.hasNext()) {
            String key = it.next();
            String[] values = map.get(key);
            if (values != null) {
                trimmedValues = new String[values.length];
                for (int i = 0; i < values.length; i++) {
                    trimmedValues[i] = trim(values[i]);
                }
            }
            trimmedMap.put(key, trimmedValues);
        }
        return trimmedMap;
    }

    /**
     * p[^lgB
     * 
     * @param value
     *            NGXgp[^̒l
     * @return gꂽNGXgp[^l
     */
    protected final String trim(String value) {
        if (value == null) {
            return null;
        }
        return value.replaceAll(this.trimPattern, "");
    }
}