/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.web.struts.actions;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.terasoluna.fw.ex.web.struts.action.DefaultFlowCallbackInfoFactory;
import jp.terasoluna.fw.ex.web.struts.action.FlowCallbackInfo;
import jp.terasoluna.fw.ex.web.struts.action.FlowCallbackInfoFactory;
import jp.terasoluna.fw.ex.web.struts.action.FlowCallbackInfoMapping;
import jp.terasoluna.fw.ex.web.struts.action.FlowInvokeActionMapping;
import jp.terasoluna.fw.ex.web.struts.action.FlowInvokeActionMappingExtendPropertyHolder;
import jp.terasoluna.fw.web.struts.actions.ForwardAction;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * ʉʃt[Np̃ANVNXB
 * <p>
 * ʉʃt[Ăяoۂ̑JځAсAʉʃt[ȊJڂsB
 */
public class FlowInvokeAction extends ForwardAction {

    /**
     * ʉʃt[Iɗp{@link FlowCallbackInfo}̃t@Ng
     */
    private FlowCallbackInfoFactory flowCallbackInfoFactory = new DefaultFlowCallbackInfoFactory();

    /**
     * {@link FlowCallbackInfoFactory}ݒ肷B (nullȊO)
     * @param flowCallbackInfoFactory {@link FlowCallbackInfoFactory}
     */
    public void setFlowCallbackInfoFactory(
            FlowCallbackInfoFactory flowCallbackInfoFactory) {
        this.flowCallbackInfoFactory = flowCallbackInfoFactory;
    }

    /**
     * ʉʃt[NpANVsB
     * <p>
     * ȉ̏sB
     * <pre>
     * Eʉʃt[IANVݒ肷郊NGXg({@link FlowTerminateAction#TERMINAL_KEY})݂ȂꍇA
     *   ʉʃt[֑Jڂۂ̏sB
     *   EHttpSessionAʉʃt[Ƌʉʃt[Iɗp{@link FlowCallbackInfo}̃}bsOێ
     *     {@link FlowCallbackInfoMapping}̃CX^X擾B
     *     擾łȂꍇA{@link FlowCallbackInfoMapping}̃CX^XVKɐAHttpSessionɓo^B
     *   E{@link FlowCallbackInfoFactory}Aʉʃt[Iɗp{@link FlowCallbackInfo}𐶐B
     *   Eʉʃt[L[ɂāAʉʃt[Iɗp{@link FlowCallbackInfo}{@link FlowCallbackInfoMapping}ɓo^B
     *   EactionvfparameterA邢namelusuccessvforwardvfŎw肳ꂽJڐɑJڂB
     *     (Jڏ́ATERASOLUNA FWForwardActionɈϏB)
     * 
     * Eʉʃt[IANVݒ肷郊NGXg({@link FlowTerminateAction#TERMINAL_KEY})݂ꍇA
     *   ʉʃt[߂Ăۂ̏sB
     *   ENGXg({@link FlowTerminateAction#TERMINAL_KEY})A
     *     ̃tH[hs߂̘_tH[h(ʉʃt[IANVterminalŐݒ肳ꂽl)擾B
     *   EL̃NGXg폜B
     *   E擾_tH[hnamelvĂforwardvfŎw肳ꂽJڐɑJڂB
     * </pre>
     * </p>
     * @param mapping
     *            ʉʃt[Ńiʉʃt[NANV́jactionvf\ANV}bsO (nullȊO)
     * @param form
     *            ANVtH[
     * @param request
     *            NGXg (nullȊO)
     * @param response
     *            X|X (nullȊO)
     * @throws IllegalArgumentException
     *             mapping {@link FlowInvokeActionMapping}^{@link FlowInvokeActionMappingExtendPropertyHolder}NXłȂꍇ
     * @throws IllegalArgumentException
     *             {@link FlowInvokeActionMapping#getDestinationFlow}({@link FlowInvokeActionMappingExtendPropertyHolder#getDestinationFlow})
     *             null̏ꍇ
     * @throws FlowTerminateFailureException
     *             ʉʃt[ȊJڐ(terminalɑΉforward)Ȃꍇ
     */
    @Override
    public ActionForward doExecute(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) {
        // ʉʃt[߂Ăۂ̏
        String terminal = (String) request
                .getAttribute(FlowTerminateAction.TERMINAL_KEY);
        if (terminal != null) {
            request.removeAttribute(FlowTerminateAction.TERMINAL_KEY);
            ActionForward forward = mapping.findForward(terminal);
            if (forward == null) {
                throw new FlowTerminateFailureException(
                        "Failed to find ActionForward(name=\"" + terminal
                                + "\") in ActionMapping(path=\""
                                + mapping.getPath() + "\", module=\""
                                + mapping.getModuleConfig().getPrefix()
                                + "\").");
            }
            return forward;
        }

        // ꂩ狤ʉʃt[ɓۂ̏
        if (!(mapping instanceof FlowInvokeActionMappingExtendPropertyHolder)) {
            throw new IllegalArgumentException(
                    "Argument mapping must be an instance of "
                            + FlowInvokeActionMapping.class.getName()
                            + " or "
                            + FlowInvokeActionMappingExtendPropertyHolder.class
                                    .getName() + ".");
        }
        FlowInvokeActionMappingExtendPropertyHolder flowInvokeActionMapping = (FlowInvokeActionMappingExtendPropertyHolder) mapping;
        String destinationFlow = flowInvokeActionMapping.getDestinationFlow();
        if (StringUtils.isBlank(destinationFlow)) {
            throw new IllegalArgumentException(
                    "The value of destinationFlow at "
                            + mapping.getClass().getName()
                            + " must be specified.");
        }
        HttpSession session = request.getSession();
        FlowCallbackInfoMapping callBackInfoMapping = (FlowCallbackInfoMapping) session
                .getAttribute(FlowCallbackInfoMapping.class.getName());
        if (callBackInfoMapping == null) {
            callBackInfoMapping = new FlowCallbackInfoMapping();
            session.setAttribute(FlowCallbackInfoMapping.class.getName(),
                    callBackInfoMapping);
        }
        FlowCallbackInfo callBackInfo = flowCallbackInfoFactory
                .createFlowCallbackInfo(mapping, form, request, response);
        callBackInfoMapping.registerFlowCallbackInfo(destinationFlow,
                callBackInfo);
        return super.doExecute(mapping, form, request, response);
    }
}
