/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.codelist;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * ۉΉ{@link jp.terasoluna.fw.web.codelist.CodeListLoader}
 * 邽߂̒ۃNXB
 *
 * <p>
 * ̃NX͍ۉꂽR[hXgP[
 * R[hXg̃}bv`ŕێB
 * ܂Ã}bv烍P[w肵
 * R[hXg擾郁\bhĂB
 * <br> 
 * R[hXg̓Ǎ݂́ÃNXpTuNXŎB
 * 
 * @see DBCodeListLoader
 * @see MappedCodeListLoader
 * 
 */
public abstract class AbstractMultilingualCodeListLoader implements CodeListLoader {

    /**
     * ONXB
     */
    private Log log = LogFactory.getLog(AbstractMultilingualCodeListLoader.class);
    
    /**
     * ۉΉR[hXg}bv
     * @see jp.terasoluna.fw.web.codelist.CodeBean
     */
    protected Map<Locale, List<CodeBean>> localeMap = null;

    
    /**
     * P[w肳ĂȂꍇ̃ftHgP[B R[hXg
     * ŃP[w肳ĂȂꍇA ̃P[ݒ肳B
     * ftHgł̓T[o[JVM̌R[ĥ݂P[ƂĎgpB
     */
    protected Locale defaultLocale
                            = new Locale(Locale.getDefault().getLanguage());

    /**
     * ftHgP[ݒ肷B
     * 
     * @param defaultLocale ftHgP[
     */
    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    /** 
     * R[hXg擾B
     *
     * R[hXg {@link CodeBean} ̔zƂĎ擾łB<br>
     * R[hXg͌ƂăAvP[VňӂƂȂłB
     * ̃\bhI[o[Chꍇ́AƖWbNȂǂ
     * R[hXg̓eҏWĂeȂ悤ɎKvB
     *
     * @return R[hXg
     */
    public CodeBean[] getCodeBeans() {
        return createCodeBeans(defaultLocale);
    }

    /**
     * P[w肵ăR[hXg擾B
     * <p>
     * R[hXg {@link CodeBean} ̔zƂĎ擾łB<br>
     * Ŏw肵P[ɑΉR[hXg擾łȂꍇA
     * ftHgP[ɑΉR[hXg擾B
     * 
     * R[hXg͌ƂăAvP[VňӂƂȂłB
     * ̃\bhI[o[Chꍇ́AƖWbNȂǂ
     * R[hXg̓eҏWĂeȂ悤ɎKvB
     *
     * @param locale P[
     * @return R[hXg
     */
    public CodeBean[] getCodeBeans(Locale locale) {
        
        if (log.isDebugEnabled()) {
            log.debug("getCodeBeans(" + locale + ") called.");
        }

        CodeBean[] result = createCodeBeans(locale);

        // R[hXg擾łȂꍇAftHgP[ōč쐬
        if (locale != null && result.length == 0) {
            result = createCodeBeans(defaultLocale);
        }
        return result;
    }
    
    /**
     * P[ɑΉR[hXg쐬B
     * <p>
     * Ŏw肵P[ɑΉR[hXg݂ȂꍇA
     * ʂ̃P[ɑΉR[hXg쐬B
     * 
     * @param locale P[
     * @return R[hXg
     */
    protected CodeBean[] createCodeBeans(Locale locale) {
        
        if (log.isDebugEnabled()) {
            log.debug("createCodeBeans(" + locale + ") called.");
        }
        
        if (localeMap == null) {
            if (log.isDebugEnabled()) {
                log.debug("field codeListsMap is null.");
            }
            // codeListsMap݂ȂƂ͋̔zԂB
            return new CodeBean[0];
        }

        if (locale == null) {
            if (log.isDebugEnabled()) {
                log.debug("arg locale is null. replace locale default : "
                        + defaultLocale);
            }
            if (defaultLocale == null) {
                throw new IllegalStateException("Default locale is null.");
            }
            locale = defaultLocale;
        }

        List<CodeBean> codeLists = localeMap.get(locale);
        
        // R[hXg擾łȂꍇAʂ̃P[ōč쐬
        if (codeLists == null) {
            if (locale.getVariant().length() > 0) {
                return createCodeBeans(new Locale(locale.getLanguage(), locale
                        .getCountry()));
            } else if (locale.getCountry().length() > 0) {
                return createCodeBeans(new Locale(locale.getLanguage()));
            }

            // codeLists݂ȂƂ͋̔zԂB
            return new CodeBean[0];
        }

        CodeBean[] cb = new CodeBean[codeLists.size()];
        for (int i = 0; i < codeLists.size(); i++) {
            cb[i] = new CodeBean();
            cb[i].setId(codeLists.get(i).getId());
            cb[i].setName(codeLists.get(i).getName());
        }
        return cb;
    }
    
    /**
     * R[hAR[hAoAgR[h烍P[쐬B
     * <p>
     * R[hnull܂͋󕶎̏ꍇ̓ftHgP[ԋpB
     * 
     * @param language R[h
     * @param country R[h
     * @param variant oAgR[h
     * @return P[
     */
    protected Locale createLocale(String language, String country,
            String variant) {
        
        // R[hݒ肳ĂȂꍇAftHgP[ԋp
        if (language == null || language.length() == 0) {
            return defaultLocale;
        }
        // R[hݒ肳ĂȂꍇAR[hō쐬P[ԋp
        if (country == null || country.length() == 0) {
            return new Locale(language);
        }
        // oAgR[hݒ肳ĂȂꍇA
        // R[hAR[hō쐬P[ԋp
        if (variant == null || variant.length() == 0) {
            return new Locale(language, country);
        }
        return new Locale(language, country, variant);
    }

}
