/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts;

import java.text.MessageFormat;
import java.util.HashMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.terasoluna.fw.util.PropertyUtil;
import jp.terasoluna.fw.web.struts.action.DBMessageResources;
import jp.terasoluna.fw.web.struts.action.PropertyMessageResourcesEx;
import jp.terasoluna.fw.web.struts.util.SpringMessageResources;

/**
 * Struts̃oO(STR-2172)pHashMap(MessageFormatLbV)̃t@NgNXB
 * <p>
 * StrutsMessageResourceśALbVgetMessageFormat𓯊ɕXbhŃANZX\ɂĂB<br>
 * ̃oO邽߂̊gHashMap𐶐B
 * </p>
 * <p>
 * Ql)<br>
 * ȂƂSun JDK̎gpẮAtñTutH[}bg({0,date})gpȂA
 * MessageFormat̎dlɂ͔̂́ACX^Xformat\bh𕡐XbhœɎsĂA
 * SȂB(ꂪAStrutsMessageResources̃oOSTR-2172Won't FixƂȂACȂRB)<br>
 * ̃NXł̓oỎ@𒲐\ƂĂBsystem.propertiesɈȉ̐ݒsB
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>system.propertiesݒ</legend>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>MessageFormat𕡐XbhŎgpȂ悤Aclone(MessageFormat̎dlɏ)</legend>
 * <code>
 * messageResources.messageFormatClone = enable
 * </code>
 * </fieldset>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>tñTutH[}bggpꂽƂ̂݁AMessageFormat𕡐XbhŎgpȂ悤Aclone (ftHg)<br>
 * (SunMessageFormatтgpFormatNX̎ɍ킹œK)</legend>
 * <code>
 * messageResources.messageFormatClone = dateFormatOnly
 * </code>
 * </fieldset>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>oOs킸AStruts̎̂܂ܓ삷</legend>
 * <code>
 * messageResources.messageFormatClone = disable
 * </code>
 * </fieldset>
 * ݒ莩̂ȗꍇALȊO̐ݒlݒ肳ꂽꍇ <strong>dateFormatOnly</strong> ƂĈB<br>
 * </p>
 * @see MessageFormatCloneReturnMap
 * @see MessageFormatCloneReturnIfUseDateFormatMap
 * @see PropertyMessageResourcesEx
 * @see DBMessageResources
 * @see SpringMessageResources
 */
public class MessageFormatCacheMapFactory {

    /**
     * OCX^X
     */
    private static Log log = LogFactory
            .getLog(MessageFormatCacheMapFactory.class);

    /**
     * messageFormatCloneݒl̃vpeBL[
     */
    private static final String MESSAGE_FORMAT_CLONE_KEY = "messageResources.messageFormatClone";

    /**
     * messageFormatCloneݒl:enable
     */
    private static final String ENABLE = "enable";

    /**
     * messageFormatCloneݒl:disable
     */
    private static final String DISABLE = "disable";

    /**
     * messageFormatCloneݒl:dateFormatOnly
     */
    private static final String DATE_FORMAT_ONLY = "dateFormatOnly";

    /**
     * Struts̃oO(STR-2172)pHashMapCX^XԂB
     * <p>
     * ݒɂAoOĂꍇ́AnullԂB
     * </p>
     * @return Struts̃oO(STR-2172)pHashMapCX^X
     */
    public static HashMap<String, MessageFormat> getInstance() {
        String cloneSetting = PropertyUtil
                .getProperty(MESSAGE_FORMAT_CLONE_KEY);
        if (log.isDebugEnabled()) {
            log.debug(MESSAGE_FORMAT_CLONE_KEY + " = " + cloneSetting);
        }
        if (cloneSetting == null) {
            log.debug("use MessageFormatCloneReturnAtDateFormatOnlyMap.");
            return new MessageFormatCloneReturnIfUseDateFormatMap();
        }

        cloneSetting = cloneSetting.toLowerCase();
        if (ENABLE.equals(cloneSetting)) {
            log.debug("use MessageFormatCloneReturnMap.");
            return new MessageFormatCloneReturnMap();
        } else if (DATE_FORMAT_ONLY.toLowerCase().equals(cloneSetting)) {
            log.debug("use MessageFormatCloneReturnAtDateFormatOnlyMap.");
            return new MessageFormatCloneReturnIfUseDateFormatMap();
        } else if (DISABLE.equals(cloneSetting)) {
            return null;
        } else {
            log.warn(MESSAGE_FORMAT_CLONE_KEY + " = " + cloneSetting
                    + " is invalid. set \"" + ENABLE + "\", \"" + DISABLE
                    + "\" or \"" + DATE_FORMAT_ONLY + "\".");
            log.warn("use MessageFormatCloneReturnAtDateFormatOnlyMap.");
            return new MessageFormatCloneReturnIfUseDateFormatMap();
        }
    }
}
