/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.form;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import jp.terasoluna.fw.web.struts.ModuleUtil;
import jp.terasoluna.fw.web.struts.reset.Resetter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorActionForm;

/**
 * IANVtH[NXB
 *
 * <p>
 * DynaValidatorActionFormEx p邱ƂŁA
 * Strutsݒt@C(struts-config.xml) ɐݒ`邾ŁA
 * ANVtH[𓮓Iɐ邱ƂłB
 * <p><strong> Strutsݒt@C(struts-config.xml) ̃ANVtH[쐬</strong>
 * </p>
 *
 * <code><pre>
 * &lt;form-beans&gt;
 *  <b>&lt;form-bean
 *  name="_validateSampleForm"
 *  type="jp.terasoluna.fw.web.thin.form.DynaValidatorActionFormEx"&gt;</b>
 *    &lt;form-property name="companyId" type="java.lang.String" /&gt;
 *    &lt;form-property name="userId"    type="java.lang.String" /&gt;
 *    &lt;form-property name="password"  type="java.lang.String" /&gt;
 *    &lt;form-property name="longName"  type="java.lang.String" /&gt;
 *    &lt;form-property name="codeArray" type="java.util.ArrayList" /&gt;
 *  &lt;/form-bean&gt;
 * &lt;/form-beans&gt;
 * </pre></code>
 * &lt;form-bean&gt;^O name 
 * tH[_w肵Atype ɃNXw肷B<br>
 * tH[_̐擪 &quot;_&quot tARg[
 * RequestProcessorExw肷邱ƂɂA
 * ZbṼtH[̗BꐫۏႳB<br>
 * <br>
 * <strong>g_Œ񋟂@\</strong><br>
 * <ul>
 * <li>Zbg@\B<br>
 * T[ubgReLXgɐݒ肳Ă ResetterImpl NX
 * reset()\bhNB<br></li>
 * <li>CfbNXtvpeB擾@\B<br>
 * getIndexCount(String fieldName)ɂAΏۂ̃tB[h
 * 擾łB<br></li>
 * <li>CfbNXtvpeBݒ@\B<br>
 * zAList̃CfbNX͈͊ÕZb^[\bhĂ΂ꂽ
 * ƂɓIɃCfbNX̗vf𑝉B<br></li>
 * <li>CfbNXtvpeB擾@\B<br>
 * zAList̃CfbNX͈͊ÕQb^[\bhĂ΂ꂽ
 * ƂnullԋpB<br></li>
 * <li>tB[hlύXtOB<br>
 * BLogicMapperɂăANVtH[̃tB[hlύX̍ۂ
 * modifiedtrueɐݒ肵AύXsꂽǂmłB
 * <br></li>
 * </ul>
 *
 * @\̏ڍׂƂĎQlɂׂ
 * <ul>
 *  <li>tH[ɃNX쐬ꍇ̎ɂẮA
 *   ValidatorActionFormExQƁB</li>
 *  <li>tH[̗BꐫAtB[hlύXtȌڍׂɂẮA
 *   RequestProcessorExQƁB</li>
 *  <li>ZbgEtB[hlNA@\ɂĂ̏ڍׂ́AResetterImplA
 *    ResetterPlugInQƁB</li>
 *  <li>gof[V@\ɂĂ FieldChecksEx QƁB</li>
 * </ul>
 * </p>
 *
 * @see jp.terasoluna.fw.web.struts.form.ValidatorActionFormEx
 * @see jp.terasoluna.fw.web.struts.action.RequestProcessorEx
 * @see jp.terasoluna.fw.web.struts.reset.Resetter
 * @see jp.terasoluna.fw.web.struts.plugins.ResetterPlugIn
 * @see jp.terasoluna.fw.web.struts.form.FieldChecksEx
 * @see jp.terasoluna.fw.service.thin.BLogicMapper
 *
 */
public class DynaValidatorActionFormEx
    extends DynaValidatorActionForm
    implements FormEx {

    /**
     * VAo[WID
     */
    private static final long serialVersionUID = -8958002981280692562L;

    /**
     * ONXB
     */
    private static Log log =
        LogFactory.getLog(DynaValidatorActionFormEx.class);

    /**
     * lύXtOB
     */
    private boolean modified = false;

    /**
     * CfbNXt̃vpeB擾B
     *
     * <p>
     *  CfbNX͈͊ÔƂnull
     *  Ԃ悤Struts̃ftHggĂB
     * </p>
     *
     * @param name tB[h
     * @param index CfbNX
     * @return vpeBl
     */
    @Override
    public Object get(String name, int index) {
        if (log.isDebugEnabled()) {
            log.debug("get(" + name + ", " + index + ") called.");
        }

        Object value = dynaValues.get(name);
        if (value == null) {
            throw new NullPointerException(
                "No indexed value for '" + name + "[" + index + "]'");
        } else if (value.getClass().isArray()) {
            try {
                return (Array.get(value, index));
            } catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        } else if (value instanceof List) {
            try {
                return ((List) value).get(index);
            } catch (IndexOutOfBoundsException e) {
                return null;
            }
        } else {
            throw new IllegalArgumentException(
                "Non-indexed property for '" + name + "[" + index + "]'");
        }
    }

    /**
     * CfbNXt̃vpeB擾B
     *
     * <p>
     *  CfbNX͈͊ÔƂnull
     *  Ԃ悤Struts̃ftHggĂB
     * </p>
     *
     * @param name tB[h
     * @param index CfbNX
     * @return vpeBl
     */
    public Object getIndexedValue(String name, int index) {
        return this.get(name, index);
    }

    /**
     * w肳ꂽtB[ȟ擾B
     *
     * @param fieldName 擾Ώۂ̃tB[hB
     * @return tB[hľB
     * <p>vpeB擾łȂꍇ0ԂB</p>
     */
    public int getIndexCount(String fieldName) {
        if (log.isDebugEnabled()) {
            log.debug("getIndexCount(" + fieldName + ") called.");
        }
        int count = 0;
        Object value = dynaValues.get(fieldName);
        if (value == null) {
            count = 0;
        } else if (value.getClass().isArray()) {
            count = ((Object[]) value).length;
        } else if (value instanceof List) {
            count = ((List) value).size();
        } else if (value instanceof Map) {
            count = ((Map) value).size();
        } else {
            count = 1;
        }
        if (log.isDebugEnabled()) {
            log.debug("size = [" + count + "]");
        }
        return count;
    }

    /**
     * ANVtH[̃tB[hlZbgsB
     *
     * @param mapping }bsO
     * @param request NGXg
     */
    @Override
    public void reset(ActionMapping mapping, HttpServletRequest request) {
        if (log.isDebugEnabled()) {
            log.debug("reset() called.");
        }

        //Prefix擾
        String prefix = ModuleUtil.getPrefix(request);

        try {
            Resetter resetter =
                (Resetter) getServlet().getServletContext().getAttribute(
                    Resetter.RESETTER_KEY + prefix);
            if (resetter == null) {
                if (log.isDebugEnabled()) {
                    log.debug("resetter class is not specified.");
                }
                return;
            }
            resetter.reset(this, mapping, request);
        } catch (ClassCastException e) {
            log.error("", e);
            return;
        }
    }

    /**
     * CfbNXt̃vpeBZbgB
     *
     * <p>
     *  StrutsDynaActionFormł̓vpeB̌^
     *  List܂͔z^ɂƎgpOɏA
     *  TCY肵Ȃ΂ȂȂAIɃTCY
     *  ύX邱ƂŁȀȗł悤ɊgĂB
     * </p>
     *
     * @param name ZbgΏۂ̃tB[h
     * @param index ZbgΏۂ̃CfbNX
     * @param value ZbgΏۂ̃tB[hl
     */
    public void setIndexedValue(String name, int index, Object value) {

        if (log.isDebugEnabled()) {
            log.debug(
                "setIndexedValue(" + name + ", " + index + ", " + value + ") called.");
        }

        this.set(name, index, value);
    }


    /**
     * CfbNXt̃vpeBZbgB
     *
     * <p>
     *  StrutsDynaActionFormł̓vpeB̌^
     *  List܂͔z^ɂƎgpOɏA
     *  TCY肵Ȃ΂ȂȂAIɃTCY
     *  ύX邱ƂŁȀȗł悤ɊgĂB
     * </p>
     *
     * @param name ZbgΏۂ̃tB[h
     * @param index ZbgΏۂ̃CfbNX
     * @param value ZbgΏۂ̃tB[hl
     */
    @SuppressWarnings("unchecked")
    @Override
    public void set(String name, int index, Object value) {

        if (log.isDebugEnabled()) {
            log.debug(
                "set(" + name + ", " + index + ", " + value + ") called.");
        }

        Object prop = dynaValues.get(name);
        if (prop == null) {
            throw new NullPointerException(
                "No indexed value for '" + name + "[" + index + "]'");
        } else if (prop.getClass().isArray()) {
            if (index < Array.getLength(prop)) {
                Array.set(prop, index, value);
            } else {
                // CfbNX`FbN
                ActionFormUtil.checkIndexLength(index);
                // VK̔z𐶐
                Object newArray = Array.newInstance(
                     prop.getClass().getComponentType(), index + 1);
                // z̃R|[lgRs[
                System.arraycopy(prop, 0, newArray, 0, Array.getLength(prop));
                // ǉ̃R|[lgZbg
                Array.set(newArray, index, value);
                // QƂ̃Rs[
                prop = newArray;
            }
            dynaValues.put(name, prop);
        } else if (prop instanceof List) {
            if (index < ((List) prop).size()) {
                ((List) prop).set(index, value);
            } else {
                // CfbNX`FbN
                ActionFormUtil.checkIndexLength(index);
                Object[] oldValues = ((List) prop).toArray();
                Object[] newValues = (Object[]) Array.newInstance(
                           oldValues.getClass().getComponentType(), index + 1);
                System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
                newValues[index] = value;
                ((List) prop).clear();
                ((List) prop).addAll(Arrays.asList(newValues));
            }
            dynaValues.put(name, prop);
        } else {
            throw new IllegalArgumentException(
                "Non-indexed property for '" + name + "[" + index + "]'");
        }

    }

    /**
     * lύXtO擾B
     *
     * @return lύXtO
     */
    public boolean isModified() {
        return this.modified;
    }

    /**
     * lύXtOݒ肷B
     *
     * @param modified lύXtO
     */
    public void setModified(boolean modified) {
        this.modified = modified;
    }

}
