/*
 *
 *
 * Copyright (c) 2007, 2010 NTT DATA Corporation
 *
 */
package jp.terasoluna.toursample.uc_a01_04.blogic;

import java.util.Calendar;
import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.service.thin.BLogic;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.toursample.common.exception.RecordNotFoundException;
import jp.terasoluna.toursample.common.util.DateUtil;
import jp.terasoluna.toursample.uc_a01_04.dto.RP_A01_04_01_02Input;
import jp.terasoluna.toursample.uc_a01_04.exception.CannotCancelException;

/**
 * \LZNXB
 * 
 * 
 */
public class RP_A01_04_01_02BLogicImpl implements BLogic<RP_A01_04_01_02Input> {

    /**
     * ʏsNullԋpꂽꍇ̃G[bZ[WB
     */
    public static final String ERROR_NOT_RESERVED = "error.common.00008";

    /**
     * DAONXB<br>
     * SpringɂCX^Xݒ肳B queryDAO B
     */
    private QueryDAO queryDAO = null;

    /**
     * DAONXB<br>
     * SpringɂCX^Xݒ肳B updateDAO B
     */
    private UpdateDAO updateDAO = null;

    /**
     * queryDAO 擾B
     * 
     * @return queryDAO
     */
    public QueryDAO getQueryDAO() {

        return this.queryDAO;
    }

    /**
     * queryDAO ݒ肷B
     * 
     * @param queryDAO
     *            queryDAO
     */
    public void setQueryDAO(QueryDAO queryDAO) {

        this.queryDAO = queryDAO;
    }

    /**
     * updateDAO 擾B
     * 
     * @return updateDAO
     */
    public UpdateDAO getUpdateDAO() {

        return this.updateDAO;
    }

    /**
     * updateDAO ݒ肷B
     * 
     * @param updateDAO
     *            updateDAO
     */
    public void setUpdateDAO(UpdateDAO updateDAO) {

        this.updateDAO = updateDAO;
    }

    /**
     * ONXB
     */
    private static final Log log = LogFactory
            .getLog(RP_A01_04_01_02BLogicImpl.class);

    /**
     * Uς݂̃`FbNė\̃LZsB<br>
     * 
     * @exception NotTransferException
     *                ʂȂꍇB
     * @exception CannotCancelException
     *                xς݂̏ꍇB
     * @param rp_a01_04_01_02Input
     * @return rWlXWbN̎sʁABLogicResultCX^XB
     */
    public BLogicResult execute(RP_A01_04_01_02Input rp_a01_04_01_02Input) {

        // ʂi[B
        BLogicResult result = new BLogicResult();

        // cA[\̐UtOB
        Boolean transfer = queryDAO
                .executeForObject("UC_A01_04.selectTransfer",
                        rp_a01_04_01_02Input, Boolean.class);

        // \񂪂ȂꍇAOsB
        // ONXFRecordNotFoundException
        if (transfer == null) {

            if (log.isErrorEnabled()) {
                log.error(ERROR_NOT_RESERVED + ":\񂪌܂B");
            }

            throw new RecordNotFoundException(ERROR_NOT_RESERVED);
        }

        // UtOUς݂̏ꍇOsB
        if (transfer) {

            if (log.isWarnEnabled()) {
                log.warn("warn.UC_A01_04.00001:xς݂̂ߗ\LZłȂB");
            }

            throw new CannotCancelException("warn.UC_A01_04.00001");
        }

        // U擾B
        Date paymentTimeLimit = DateUtil.getOneWeekBeforeDate(rp_a01_04_01_02Input.
                getReserveDetail().getDepDay());

        // VXetƐUr
        // U߂ĂꍇAƖG[ʂ֑JڂB
        Date today = DateUtil.getTodayDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(today);

        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.clear(Calendar.MINUTE);
        calendar.clear(Calendar.SECOND);
        calendar.clear(Calendar.MILLISECOND);

        if (calendar.getTime().after(paymentTimeLimit)) {
            if (log.isWarnEnabled()) {
                log.warn("warn.UC_A01_04.00001:U߂Ă邽ߗ\LZłȂB");
            }
            throw new CannotCancelException("warn.UC_A01_04.00001");
        }

        // \LZB
        updateDAO.execute("UC_A01_04.deleteReserve", rp_a01_04_01_02Input);

        // ʂZbgB
        result.setResultString("success");
        return result;
    }

}