/*
 *
 *
 * Copyright (c) 2007, 2010 NTT DATA Corporation
 *
 */
package jp.terasoluna.toursample.uc_a99_01.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.Globals;

import jp.terasoluna.fw.service.thin.BLogicMessage;
import jp.terasoluna.fw.service.thin.BLogicMessages;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.web.struts.actions.AbstractBLogicAction;
import jp.terasoluna.toursample.common.TourUVO;
import jp.terasoluna.toursample.uc_a99_01.blogic.RP_A99_01_02_02BLogic;
import jp.terasoluna.toursample.uc_a99_01.dto.RP_A99_01_02_02Input;
import jp.terasoluna.toursample.uc_a99_01.dto.RP_A99_01_02_02Output;

/**
 * OCsANVNXB<br>
 * <br>
 * E[XP[XUC_A99_01FڋqOC<br>
 * <br>
 * ͂ꂽ(ڋqIDApX[h)𗘗pOCsB<br>
 * f[^x[XɌڋq񂪂ꍇUVO𐶐ZbVɊi[B<br>
 * Ȃꍇ̓G[bZ[Wʂɕ\B
 * 
 * 
 * 
 */
public class RP_A99_01_02_02Action extends 
    AbstractBLogicAction<RP_A99_01_02_02Input> {

    /**
     * ONXB
     */
    private static final Log log = 
        LogFactory.getLog(RP_A99_01_02_02Action.class);

    /**
     * OCɎsꍇ̃G[bZ[WR[hB
     */
    private static final String LOGIN_ERROR = "warn.UC_A99_01.00001";

    /**
     * OCrWlXWbNB
     */
    private RP_A99_01_02_02BLogic rp_a99_01_02_02BLogic = null;

    /**
     * OCrWlXWbNݒ肷B
     * 
     * @param logic
     *            OCrWlXWbN
     */
    public void setRp_a99_01_02_02BLogic(RP_A99_01_02_02BLogic logic) {

        rp_a99_01_02_02BLogic = logic;
    }

    /**
     * OCsB<br>
     * <p>
     * OCrWlXWbNsAOC\̏ꍇUVO(ڋq) ZbVɊi[B
     * </p>
     * 
     * @param param
     *            BLogic͏
     * @return BLogico͏
     */
    @Override
    public BLogicResult doExecuteBLogic(RP_A99_01_02_02Input param) {

        BLogicResult result = new BLogicResult();

        // OCsB
        TourUVO uvo = rp_a99_01_02_02BLogic.executeLogin(param
            .getCustomerCode(), param.getCustomerPass());

        // ڋq擾ۂmFB
        if (uvo == null) {
            // ڋq񂪎擾łȂꍇiF؎sj
            // G[bZ[Wi[ABLogicResultɐݒ肷
            BLogicMessages errors = new BLogicMessages();
            errors.add(Globals.ERROR_KEY, new BLogicMessage(LOGIN_ERROR));
            result.setErrors(errors);

            result.setResultString("failure");

            // Oo͂B
            if (log.isWarnEnabled()) {
                log.warn("Login failureF " + param.getCustomerCode());
            }
        } else {
            // ڋq񂪎擾łꍇiFؐj
            // o̓IuWFNg𐶐ABLogicResultɐݒ肷
            RP_A99_01_02_02Output output = new RP_A99_01_02_02Output();
            output.setUvo(uvo);
            result.setResultObject(output);

            // Oo͂B
            if (log.isInfoEnabled()) {
                log.info("Login successF " + param.getCustomerCode());
            }

            String returnCode = param.getReturnCode();

            // JڌIDmFB
            if (returnCode == null || "".equals(returnCode)) {
                // JڌIDȂꍇ
                result.setResultString("success");
            } else if ("SC_A01_01_02".equals(returnCode)) {
                // JڌIDSC_A01_01_02(cA[ڍ׉)̏ꍇ
                result.setResultString("returnSC_A01_01_02");
            } else {
                // zȎJڌID̏ꍇ
                result.setResultString("default");
            }

        }
        return result;
    }

}
