/*
 * Copyright 2009- kensir0u.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/*
 * 쐬 (creation date)  F2009/02/11
 * pbP[W  (package name) Fnet.sf.thirdi.jdbc.meta
 * t@C  (file name)    FPropertyDesc.java
 */
package net.sf.thirdi.jdbc.meta;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import net.sf.thirdi.jdbc.exception.InvokeException;

/**
 * <i>Tv(abstract)</i>F vpeB
 *@.<p>
 * vpeB
 * 
 *
 * @author  kensir0u
 * @version 1.0
 * @since   JDK 5.0
 *
 */
public class PropertyDesc  implements ElementDesc{
	private static final ElementType elementtype= ElementType.PROPERTY;
	
	private String propertyName;
	
	private String name;
	
	private String aliasname;
	
	private String id;
	
	private int index = Short.MIN_VALUE;
	
	private Method method;
	
	private Class<?> type;

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.meta.ElementDesc#getAliasName()
	 */
	@Override
	public String getAliasName() {
		return this.aliasname;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.meta.ElementDesc#getElementType()
	 */
	@Override
	public ElementType getElementType() {
		return elementtype;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.meta.ElementDesc#getId()
	 */
	@Override
	public String getId() {
		return this.id;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.meta.ElementDesc#getName()
	 */
	@Override
	public String getName() {
		return this.name;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.meta.ElementDesc#getType()
	 */
	@Override
	public Class<?> getType() {
		return this.type;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.meta.ElementIndexable#getIndex()
	 */
	@Override
	public int getIndex() {
		return this.index;
	}




	public void setName(String name) {
		this.name = name;
	}

	public void setAliasname(String aliasname) {
		this.aliasname = aliasname;
	}

	public void setId(String id) {
		this.id = id;
	}

	public void setIndex(int index) {
		this.index = index;
	}

	public void setType(Class<?> type) {
		this.type = type;
	}

	public String getPropertyName() {
		return propertyName;
	}

	public void setPropertyName(String propertyName) {
		this.propertyName = propertyName;
	}

	public Method getMethod() {
		return method;
	}

	public void setMethod(Method method) {
		this.method = method;
	}

	public String getAliasname() {
		return aliasname;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.meta.ElementDesc#invoke(java.lang.Object, java.lang.Object)
	 */
	@Override
	public void invoke(Object bean, Object value) {
		try {
			method.invoke(bean, value);
		} catch (IllegalArgumentException e) {
			throw new InvokeException(e);
		} catch (IllegalAccessException e) {
			throw new InvokeException(e);
		} catch (InvocationTargetException e) {
			throw new InvokeException(e);
		}
	}
}
