/*
 * Copyright 2009- kensir0u.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/*
 * 쐬 (creation date)  F2009/02/12
 * pbP[W  (package name) Fnet.sf.thirdi.jdbc.typeresolver.impl
 * t@C  (file name)    FDefaultTypeResolver.java
 */
package net.sf.thirdi.jdbc.typeresolver.impl;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

import net.sf.thirdi.jdbc.type.Type;
import net.sf.thirdi.jdbc.type.impl.ArrayType;
import net.sf.thirdi.jdbc.type.impl.BigDecimalType;
import net.sf.thirdi.jdbc.type.impl.BlobType;
import net.sf.thirdi.jdbc.type.impl.BooleanType;
import net.sf.thirdi.jdbc.type.impl.ByteType;
import net.sf.thirdi.jdbc.type.impl.BytesType;
import net.sf.thirdi.jdbc.type.impl.ClobType;
import net.sf.thirdi.jdbc.type.impl.DateType;
import net.sf.thirdi.jdbc.type.impl.DoubleType;
import net.sf.thirdi.jdbc.type.impl.FloatType;
import net.sf.thirdi.jdbc.type.impl.IntegerType;
import net.sf.thirdi.jdbc.type.impl.LongType;
import net.sf.thirdi.jdbc.type.impl.ObjectType;
import net.sf.thirdi.jdbc.type.impl.RefType;
import net.sf.thirdi.jdbc.type.impl.ShortType;
import net.sf.thirdi.jdbc.type.impl.StringType;
import net.sf.thirdi.jdbc.type.impl.StructType;
import net.sf.thirdi.jdbc.type.impl.TimeType;
import net.sf.thirdi.jdbc.type.impl.TimestampType;
import net.sf.thirdi.jdbc.typeresolver.TypeResolver;

/**
 * <i>Tv(abstract)</i>F ftHg^Cv
 *@.<p>
 * ftHg^Cv
 * 
 *
 * @author  kensir0u
 * @version 1.0
 * @since   JDK 5.0
 *
 */
public class DefaultTypeResolver implements TypeResolver{

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.typeresolver.TypeResolver#getTypes()
	 */
	@Override
	public Map<Class<?>, Type> getTypes() {
		Map<Class<?>,Type> types = new HashMap<Class<?>,Type>();
		
		types.put(String.class, new StringType());
		types.put(BigDecimal.class, new BigDecimalType());
		types.put(Boolean.class, new BooleanType());
		types.put(Boolean.TYPE, new BooleanType());
		types.put(Integer.class, new IntegerType());
		types.put(Integer.TYPE, new IntegerType());
		types.put(Long.class, new LongType());
		types.put(Long.TYPE, new LongType());
		types.put(Float.class, new FloatType());
		types.put(Float.TYPE, new FloatType());
		types.put(Double.class, new DoubleType());
		types.put(Double.TYPE, new DoubleType());
		types.put(Byte[].class, new BytesType());
		types.put(Byte.class, new ByteType());
		types.put(Byte.TYPE, new ByteType());
		types.put(Short.class, new ShortType());
		types.put(Short.class, new ShortType());
		types.put(Time.class, new TimeType());
		types.put(Date.class, new DateType());
		types.put(Timestamp.class, new TimestampType());
		types.put(Clob.class, new ClobType());
		types.put(Blob.class, new BlobType());
		types.put(Array.class, new ArrayType());
		types.put(Struct.class, new StructType());
		types.put(Ref.class, new RefType());
		types.put(Object.class, new ObjectType());

		return types;
	}

}
