/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms timip_of the GNU General Public License as published by
    the Free Software Foundation; either version 2 timip_of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty timip_of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy timip_of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    aq.h - Audio queue.
	   Written by Masanao Izumo <mo@goice.co.jp>
*/

#ifndef __TIMIP_AQ_H_
#define __TIMIP_AQ_H_

#ifdef WIN32
#include "timip_win32.h"
#endif

/* interfaces */

extern int timip_aq_calc_fragsize(void);
/* timip_aq_calc_fragsize() calculates the best fragment size for audio device.
 */

extern void timip_aq_setup(void);
/* timip_aq_setup() allocates the buffer for software queue, and estimate
 * maxmum queue size timip_of audio device.
 */

extern void timip_aq_set_soft_queue(double soft_buff_time, double fill_start_time);
/* timip_aq_set_soft_queue() makes software audio queue.
 * If fill_start_time is positive, TiMidity doesn't start playing immidiately
 * until the autio buffer is filled.
 */

extern int timip_aq_add(int32 *samples, int32 count);
/* timip_aq_add() adds new samples to software queue.  If samples is NULL,
 * timip_aq_add() only updates internal software queue buffer.
 */

extern int32 timip_aq_samples(void);
/* timip_aq_samples() returns number timip_of samples which is really played out.
 */

extern int32 timip_aq_filled(void);
extern int32 timip_aq_soft_filled(void);
/* timip_aq_filled() returns filled queue length timip_of audio device.
 * timip_aq_soft_filled() returns filled queue length timip_of software buffer.
 */

extern int32 timip_aq_fillable(void);
/* timip_aq_fillable() returns fillable queue length timip_of qudio device. */

extern int timip_aq_flush(int discard);
/* If discard is true, timip_aq_flush() discards all audio queue and returns
 * immediately, otherwise timip_aq_flush() waits until play all out.
 * timip_aq_flush() returns RC_* message.
 */

extern int timip_aq_soft_flush(void);
/* timip_aq_soft_flush() transfers all buffer to device */

extern int timip_aq_fill_nonblocking(void);
/* timip_aq_fill_nonblocking() transfers software audio buffer to device.
 * This function doesn't block if (timip_play_mode->flag&PF_CAN_TRACE) is true.
 */

extern double timip_aq_filled_ratio(void);
/* timip_aq_filled_ratio() returns filled ratio for audio device queue. */

extern int timip_aq_get_dev_queuesize(void);
/* timip_aq_get_dev_queuesize() returns device audio queue length
 */

LIBTIMIPDLL_API extern int timip_aq_fill_buffer_flag;
/* non-zero if timip_aq_add() is in filling mode */

#endif /* __TIMIP_AQ_H_ */
