/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms timip_of the GNU General Public License as published by
    the Free Software Foundation; either version 2 timip_of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty timip_of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy timip_of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    rtsyn_portmidi.c
        Copyright (c) 2003 Keishi Suenaga <s_keishi@mutt.freemail.ne.jp>

    I referenced following sources.
        alsaseq_c.c - ALSA sequencer server interface
            Copyright (c) 2000  Takashi Iwai <tiwai@suse.de>
        readmidi.c

*/

#ifdef HAVE_CONFIG_H
#include "timip_config.h"
#endif /* HAVE_CONFIG_H */
#include "timip_interface.h"

#include <stdio.h>

#include <stdarg.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#endif
#ifndef NO_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#include <math.h>
#include <signal.h>

#include "timip_server_defs.h"

#ifdef TIMIP___W32__
#include <windows.h>
#endif

#include <portmidi.h>
#include <porttime.h>

#include "timip_timidity.h"
#include "timip_common.h"
#include "timip_controls.h"
#include "timip_instrum.h"
#include "timip_playmidi.h"
#include "timip_readmidi.h"
#include "timip_recache.h"
#include "timip_output.h"
#include "timip_aq.h"
#include "timip_timer.h"

#include "timip_rtsyn.h"

int timip_rtsyn_portnumber=1;
unsigned int timip_portID[MAX_PORT];
char timip_rtsyn_portlist[32][80];
int timip_rtsyn_nportlist;

#define MAX_EXBUF 20
#define BUFF_SIZE 512

double pm_start_time;
PmError pmerr;
static unsigned int timip_InNum;
struct midistream_t{
	PortMidiStream* timip_stream;
};
static struct midistream_t  midistream[MAX_PORT];
//static PmDeviceID timip_portID[MAX_PORT];
#define PMBUFF_SIZE 8192
#define EXBUFF_SIZE 512
static PmEvent pmbuffer[PMBUFF_SIZE];
static char    sysexbuffer[EXBUFF_SIZE];

void timip_rtsyn_get_port_list(){
	int i,j;
	PmDeviceInfo *deviceinfo;
	
	pmerr=Pm_Initialize();
	if( pmerr != pmNoError ) goto pmerror;

	timip_InNum = Pm_CountDevices();
	j=0;
	for (i=1;i <=timip_InNum && i<=32;i++){
		deviceinfo=(PmDeviceInfo *)Pm_GetDeviceInfo(i-1);
		if(TRUE==deviceinfo->input){
			sprintf(timip_rtsyn_portlist[j],"%d:%s",i,deviceinfo->name);
			j++;
		}
	}
	timip_rtsyn_nportlist=j;
	Pm_Terminate();
	
	return;
pmerror:
		Pm_Terminate();
	timip_ctl->cmsg(  CMSG_ERROR, VERB_NORMAL, "PortMIDI error: %s\n", Pm_GetErrorText( pmerr ) );
	return;
}

int timip_rtsyn_synth_start(){
	int i;
	unsigned int port;
	
	port=0;
	Pt_Start(1,NULL,NULL);
	pm_start_time = timip_get_current_calender_time();
	pmerr=Pm_Initialize();
	if( pmerr != pmNoError ) goto pmerror;
	for(port=0;port<timip_rtsyn_portnumber;port++){
				PortMidiStream* timip_stream;
				void* timeinfo;

				pmerr=Pm_OpenInput( &timip_stream,
				timip_portID[port],
				NULL,
				(PMBUFF_SIZE),
				Pt_Time,
				NULL);
		midistream[port].timip_stream=stream;
		if( pmerr != pmNoError ) goto pmerror;
		pmerr=Pm_SetFilter(midistream[port].timip_stream,PM_FILT_CLOCK);
		if( pmerr != pmNoError ) goto pmerror;
	}

	return ~0;

pmerror:
		Pm_Terminate();
	timip_ctl->cmsg(  CMSG_ERROR, VERB_NORMAL, "PortMIDI error: %s\n", Pm_GetErrorText( pmerr ) );
	return 0;

}


void timip_rtsyn_synth_stop(){

	timip_rtsyn_stop_playing();
//	timip_play_mode->close_output();
	timip_rtsyn_midiports_close();
	
	return;
pmerror:
		Pm_Terminate();
	timip_ctl->cmsg(  CMSG_ERROR, VERB_NORMAL, "PortMIDI error: %s\n", Pm_GetErrorText( pmerr ) );
	return ;
}
void timip_rtsyn_midiports_close(void){
	unsigned int port;

	for(port=0;port<timip_rtsyn_portnumber;port++){
		pmerr=Pm_Abort(midistream[port].timip_stream);
//		if( pmerr != pmNoError ) goto pmerror;
	}
	Pm_Terminate();
	Pt_Stop();
}

int timip_rtsyn_play_some_data (void){
	PmMessage pmmsg;
	int played;	
	int j,port,exlen,data,shift;
	long pmlength,pmbpoint;
	double event_time;
	
	played=0;
		sleep(0);
		for(port=0;port<timip_rtsyn_portnumber;port++){
			pmerr=Pm_Read(midistream[port].timip_stream, pmbuffer, PMBUFF_SIZE);
			if(pmerr<0) goto pmerror;
			pmlength=pmerr;
			pmbpoint=0;
			while(pmbpoint<pmlength){
				played=~0;
				pmmsg=pmbuffer[pmbpoint].message;
				event_time=((double)pmbuffer[pmbpoint].timestamp)/1000.0 + pm_start_time;
				pmbpoint++;
				if( 1==timip_rtsyn_play_one_data (port, pmmsg, event_time) ){	

					j=0;
					sysexbuffer[j++] = 0xf0;
					for (shift = 8,data=0; shift < 32 && (data != 0x0f7); shift += 8) {
       		         	data= (pmmsg >> shift) & 0x0FF;
						sysexbuffer[j++]=data;
					}
					if(data!=0x0f7){
						if(pmbpoint>=pmlength){
							{
								pmerr=Pm_Read(midistream[port].timip_stream, pmbuffer, PMBUFF_SIZE);
								if(pmerr<0){goto pmerror; }
								sleep(0);
							}while(pmerr==8);
							pmlength=pmerr;
							pmbpoint=0;
						}
						while(j<EXBUFF_SIZE-4){
							for (shift=0,data=0; shift < 32 && (data != 0x0f7); shift += 8) {
                				data= (pmbuffer[pmbpoint].message >> shift) & 0x0FF;
								sysexbuffer[j++]=data;
							}
							pmbpoint++;
							if(data==0x0f7) break;
							if( pmbpoint>=pmlength ){
								{
									pmerr=Pm_Read(midistream[port].timip_stream, pmbuffer, PMBUFF_SIZE);
									if(pmerr<0){goto pmerror;}
									sleep(0);
								}while(pmerr==0);
								pmlength=pmerr;
								pmbpoint=0;
							}
						}
					}
					exlen=j;
					timip_rtsyn_play_one_sysex (sysexbuffer,exlen, event_time);
				}
			}
		}
	return played;
pmerror:
	Pm_Terminate();
	timip_ctl->cmsg(  CMSG_ERROR, VERB_NORMAL, "PortMIDI error: %s\n", Pm_GetErrorText( pmerr ) );
	return 0;
}

