<?php
require_once(TODOTASK_DIR.'/app/controllers/login.class.php');

class Datafile extends Login {
	// 許可する拡張子
//	private $ary_allow_ext = array('jpg','gif','png','bmp'); 
	private $ary_allow_ext = array('jpg','gif','png'); 
	
	private $file_chk = false;
	private $file_data = "";
	private $file_name = "";
	private $file_ext = "";
	private $file_size = 0;	
	
	function __construct(){
		parent::__construct();
	}

	function __destruct(){

	}

	// 画像ファイルの種類
	public function GetImgMimetype($ext) { 
		$mime = array( 
			'jpg' => 'image/jpeg', 
			'gif' => 'image/gif', 
			'png' => 'image/png', 
			'bmp' => 'image/bmp' 
		); 
		return $mime[$ext]; 
	} 

	// 画像ファイルの種類
	public function ChkFile($file) { 
		if (!is_array($file)) {
			return false; 
		}
		if (!isset($file["name"])) {
			return false; 
		}
		if ($file["name"]=="") {
			return false; 
		}
		return true; 
	} 

	// ファイル状態のチェック	
	public function ChkUpFile(&$file,$blnImg = false) {
		$this->file_chk = false;

		if (!$this->ChkFile($file)) {
			parent::set_errmsg(DATA_ART_002);
			return false; 
		}

		$fp = fopen($file["tmp_name"], "rb");
		if(!$fp) {
			parent::set_errmsg($file["name"].DATA_ART_003);
			return false; 
		}
				
		// ファイルサイズのチェック
		$file_size = filesize($file["tmp_name"]);
		if (!self::fChkFileSize($file_size)){
			fclose($fp);
			return false; 
		}

		// 拡張子チェック
		$file_ext = self::fGetExtType($file);
		if (!in_array($file_ext,$this->ary_allow_ext)){
			parent::set_errmsg(DATA_ART_004);
			return false; 
		}

		// 名称の切り出し
		$file_name = self::fGetFileName($file);

		// ファイルのオープン
		$file_data = fread($fp, $file_size);
		fclose($fp);

		// RFIのチェック
		if (!self::fChkRFI($file_data)){
			parent::set_errmsg(DATA_ART_005);
			return false; 
		}

		// 画像かどうかのチェック
		if ($blnImg) {
			if (!self::fChkImgFormat($file)){
				parent::set_errmsg(DATA_ART_006);
				return false; 
			}
		}

		$this->file_chk = true;
		$this->file_data = $file_data;
		$this->file_name = $file_name;
		$this->file_ext = $file_ext;
		$this->file_size = $file_size;	

		return true; 
	}

	// RFI（リモートファイルインクルード）脆弱性対応
	private function fChkRFI($file_data) {
		// @eregiだと十分なSEARCHができないので再考の余地あり

		if (eregi("<?php",$file_data)) {
			return false;
		}
//		if (eregi("<?",$file_data)) {
//			return false;
//		}
//		if (eregi("<%",$file_data)) {
//			return false;
//		}
		if (eregi("<script",$file_data)) {
			return false;
		}
		if (eregi("<input",$file_data)) {
			return false;
		}
		if (eregi("<html",$file_data)) {
			return false;
		}
		return true;
	}

	// ファイルサイズのチェック
	private function fChkFileSize($file_size) {
		if ($file_size > (MAX_UPFILE_SIZE * 1024)) {
			self::set_errmsg(DATA_ART_007);
			return false; 
		} else if ($file_size == 0) {
			self::set_errmsg(DATA_ART_008);
			return false; 
		}
		return true;		
	}	

	private function fGetExtType($file) {
		//一般ファイルの判定 ＝ 追加した処理
		$aryFileName = explode('.', $file['name']);
		$ext = strtolower(end($aryFileName));

		// ビットマップはjpgで保存するのでjpgにしておく。
		if ($ext == "bmp") {
			$ext = "jpg";
		}
		return $ext; 
	}

	private function fGetFileName($file) {
		//一般ファイルの判定 ＝ 追加した処理
		$aryFileName = explode('.', $file['name']);
		$name = current($aryFileName);
		return $name; 
	}

	// 画像ファイルのチェック
	private function fChkImgFormat($file) {
		try {
			//画像ファイルの判定 ＝ 本来の処理
			list($w, $h, $type, $attr) = @getimagesize($file['tmp_name']);
	
			switch ($type) {
				case IMAGETYPE_GIF:
			        $user_img  = @imagecreatefromgif($file['tmp_name']);
					break;
				case IMAGETYPE_JPEG:
			        $user_img  = @imagecreatefromjpeg($file['tmp_name']);
					break;
				case IMAGETYPE_PNG:
			        $user_img  = @imagecreatefrompng($file['tmp_name']);
					break;
// @bmpのやり方はこれではあげられない　死にロジック
			    case IMAGETYPE_BMP:
			        $user_img  = @imagecreatefromwbmp($file['tmp_name']);
			        break;
				default:
					parent::set_errmsg(DATA_ART_004);
					return false; 
			}
			// 不正な形式の画像ファイルを削除するために画像に変換をかます
			//--- 書き込みイメージリソースはわけたほうがよい？
			// $blankImg = imagecreatetruecolor($w + 1,$h + 1);
			@imagepng($user_img, $file['tmp_name']);
	
			// 元の画像形式に戻す
			switch ($type) {
				case IMAGETYPE_GIF:
					imagegif(@imagecreatefrompng($file['tmp_name']),$file['tmp_name']);
			        $user_img  = @imagecreatefromgif($file['tmp_name']);
					break;
				case IMAGETYPE_JPEG:
					imagejpeg(@imagecreatefrompng($file['tmp_name']),$file['tmp_name']);
			        $user_img  = @imagecreatefromjpeg($file['tmp_name']);
					break;
				case IMAGETYPE_PNG:
					imagepng(@imagecreatefrompng($file['tmp_name']),$file['tmp_name']);
			        $user_img  = @imagecreatefrompng($file['tmp_name']);
					break;
			    case IMAGETYPE_BMP:
	//				imagewbmp(@imagecreatefrompng($file['tmp_name']),$file['tmp_name']);
	//		        $user_img  = @imagecreatefromwbmp($file['tmp_name']);
	//		        break;
					// bmp登録されるようなデータはjpgに変換する
			        $user_img  = @imagecreatefrompng($file['tmp_name']);
					imagejpeg($user_img,$file['tmp_name']);
			        $user_img  = @imagecreatefromjpeg($file['tmp_name']);
					break;
	
				default:
					parent::set_errmsg(DATA_ART_004);
					return false; 
			}
			// 画像をリサイズする
			if (!self::fResizeImage($user_img,$w,$h,MAX_IMG_SIZE)) {
				parent::set_errmsg(DATA_ART_009);
				return false; 
			}
			// 元の画像形式に戻す
			switch ($type) {
				case IMAGETYPE_GIF:
					imagegif($user_img,$file['tmp_name']);
					break;
				case IMAGETYPE_JPEG:
					imagejpeg($user_img,$file['tmp_name']);
					break;
				case IMAGETYPE_PNG:
					imagepng($user_img,$file['tmp_name']);
					break;
			    case IMAGETYPE_BMP:
					imagewbmp($user_img,$file['tmp_name']);
			        break;
				default:
					parent::set_errmsg(DATA_ART_004);
					return false; 
			}
			@imagedestroy($user_img);
	
			return true;

		} catch (Exception $e) {
			parent::set_errmsg($e->getMessage());
			return false; 
		}
	}

	private function fResizeImage(&$image,$w,$h,$maxsize) {
		if ($w <= 0 or $h <= 0 or $maxsize <= 0){
			return false; 
		}
	
		// 画像を規定サイズに縮小
		$resizeW = $maxsize/$w;
		$resizeY = $maxsize/$h;
		if ($resizeW < 1 or $resizeY < 1) {
			// 小さい方の尺にあわせてリサイズする
			$resize = 0; 
			if ($resizeW < $resizeY){
				$resize = $resizeW;
			} else {
				$resize = $resizeY;
			} 
			$new_width = (int)($w * $resize);
			$new_height = (int)($h * $resize);
		
			// 再サンプル
			$image_p = imagecreatetruecolor($new_width, $new_height);
			imagecopyresampled($image_p, $image, 0, 0, 0, 0, $new_width, $new_height, $w, $h);
			
			// 出力
			$image = $image_p;
		}
		return true;		
		
	}

	public function GetDataFile($data_no,$task_no,$group_no) {
		$aryRes = array();

		// 管理ユーザをメンバーリストから取得
		$sSQL = "";
		$sSQL = $sSQL."Select ";
		$sSQL = $sSQL."	data_no,";
		$sSQL = $sSQL."	task_no,";
		$sSQL = $sSQL."	group_no,";
		$sSQL = $sSQL."	data,";
		$sSQL = $sSQL."	data_name,";
		$sSQL = $sSQL."	data_ext,";
		$sSQL = $sSQL."	data_size ";
		$sSQL = $sSQL."From data_tbl ";
		$sSQL = $sSQL."Where ";
		$sSQL = $sSQL."	data_no = ".gfQt($data_no);
		$sSQL = $sSQL."	and task_no = ".gfQt($task_no);
		$sSQL = $sSQL."	and group_no=".gfQt($group_no);

		$rs = parent::get_rs($sSQL);
		if($rs) {
			while( $row = parent::get_row($rs)){
				$aryRes["data_no"] = gfGetDBFields($row,"task_no"); 
				$aryRes["task_no"] = gfGetDBFields($row,"task_no"); 
				$aryRes["group_no"] = gfGetDBFields($row,"group_no"); 
				$aryRes["data"] = gfGetDBFields($row,"data"); 
				$aryRes["data_name"] = gfGetDBFields($row,"data_name"); 
				$aryRes["data_ext"] = gfGetDBFields($row,"data_ext"); 
				$aryRes["data_size"] = gfGetDBFields($row,"data_size"); 
			}
			parent::free_rs($rs);
		}
		return $aryRes;
	}

	// 画像の登録をおこなう
	public function InsDataFile($task_no ,$group_no ,$id) {

		// ファイルフォーマットのチェックが完了しているか？
		if (!$this->file_chk) {
			return false;
		}
		
		$sSQL = "";
		$sSQL = $sSQL."insert into data_tbl (";
		$sSQL = $sSQL."	task_no,";
		$sSQL = $sSQL."	group_no,";
		$sSQL = $sSQL."	data,";
		$sSQL = $sSQL."	data_name,";
		$sSQL = $sSQL."	data_ext,";
		$sSQL = $sSQL."	data_size,";
		$sSQL = $sSQL."	add_user_id,";
		$sSQL = $sSQL."	remotehost,";
		$sSQL = $sSQL."	upddate,";
		$sSQL = $sSQL."	insdate";
		$sSQL = $sSQL.") values (";
		$sSQL = $sSQL.gfQt($task_no).",";
		$sSQL = $sSQL.gfQt($group_no).",";
		$sSQL = $sSQL."'".base64_encode($this->file_data)."',";
		$sSQL = $sSQL.gfQt($this->file_name).",";
		$sSQL = $sSQL.gfQt($this->file_ext).",";
		$sSQL = $sSQL.gfQt($this->file_size).",";
		$sSQL = $sSQL.gfQt($id).",";
		$sSQL = $sSQL.gfQt($_SERVER['REMOTE_ADDR']).",";
		$sSQL = $sSQL."now(),";
		$sSQL = $sSQL."now()";
		$sSQL = $sSQL.") ";

		$res = parent::exec_sql($sSQL);
		if (!$res){
			return $res;
		}
	
		if (parent::affected_rows() > 0 ) {
			$this->file_chk = false;
			return true;
		} else {
			return false;
		}
	}

	public function GetUserFileSize($id) {
		$sumsize = 0;

		// 管理ユーザをメンバーリストから取得
		$sSQL = "";
		$sSQL = $sSQL."Select ";
		$sSQL = $sSQL."	sum(data_size) data_sum ";
		$sSQL = $sSQL."From data_tbl ";
		$sSQL = $sSQL."Where ";
		$sSQL = $sSQL."	add_user_id = ".gfQt($id);

		$rs = parent::get_rs($sSQL);
		if($rs) {
			while( $row = parent::get_row($rs)){
				$sumsize = gfGetDBFields($row,"data_sum"); 
				break;
			}
			parent::free_rs($rs);
		}
		return $sumsize;
	}


	public function DelDataFile($data_no ,$task_no ,$group_no ,$id) {
		$res = false; 

		$sSQL = "";
		$sSQL = $sSQL."Delete from data_tbl ";
		$sSQL = $sSQL."Where ";
		$sSQL = $sSQL."	task_no = ".gfQt($task_no);
		$sSQL = $sSQL."	and group_no=".gfQt($group_no);
		if ($data_no != DELL_ALL) {
			$sSQL = $sSQL."	and data_no = ".gfQt($data_no);
		}

		$res = parent::exec_sql($sSQL);
		if (!$res){
			return $res;
		}
	
		if (parent::affected_rows() > 0 ) {
			$res = true;
		} else {
			$res = false;
		}
		return $res;
	}
	

//    // ＠アクセスが増えるようであれば画像などのキャッシュファイルを作る。
//    function MakeCache($img){
//		// ディレクトリの存在チェック＆作成
//        
//        
//        // イメージファイルの書き込み
//        $fp = fopen(IMG_PASS, "wb");
//        fwrite($fp, $img);
//        fclose($fp);
//    }

	
}


?>
