<?php
require_once(TODOTASK_DIR.'/app/controllers/login.class.php');

// 画面呼び出し画面
define("GRP_CLASS_1ST" ,"");				// 初回呼び出し  
define("GRP_CLASS_SPANDEL" ,"spandel");		//  
define("GRP_CLASS_EDIT" ,"edit");			//  
define("GRP_CLASS_MODE_LIST" ,"1");			//  
define("GRP_CLASS_MODE_MYGRP" ,"0");		//  


class Grp extends Login {

	function __construct(){
		parent::__construct();
	}

	function __destruct(){

	}
	
	// タスクグループの取得
	public function GetGrpList($user_id, $mytaskflg=0, $pageno=1) {
		$aryRes = array();
	
		$tmpFSQL = "";
//		if ($user_id !="" && $mytaskflg==GRP_CLASS_MODE_MYGRP) {
		if ($mytaskflg==GRP_CLASS_MODE_MYGRP) {
			$tmpFSQL .= ", member_tbl mt ";
			$tmpFSQL .= "Where ";
			$tmpFSQL .= "	gm.group_no = mt.group_no ";
			$tmpFSQL .= "	and  mt.user_id =".gfQt($user_id);


		}
	
		$sSQL = "";
		$sSQL .= "Select ";
//		$sSQL .= "	ifnull(max(tt.upddate),' New!') upd,";
		$sSQL .= "	ifnull(max(tt.upddate), gm.upddate) upd,";
		$sSQL .= "	vm.assent_flg assent_flg, ";
		$sSQL .= "	vm.view_flg view_flg, ";
		$sSQL .= "	gm.group_no group_no, ";
		$sSQL .= "	gm.group_name group_name, ";
		$sSQL .= "	gm.group_note group_note, ";
		$sSQL .= "	gm.group_prio group_prio ";
		$sSQL .= "From group_mst gm ";
		$sSQL .= "     left outer join view_mst vm ";
		$sSQL .= "          on vm.group_no = gm.group_no ";
		$sSQL .= "     left outer join task_tbl tt ";
		$sSQL .= "          on tt.group_no = gm.group_no ";
		$sSQL .= $tmpFSQL;
		$sSQL .= " Group by gm.group_no,gm.group_name,gm.group_note,vm.assent_flg,vm.view_flg ";
		$sSQL .= "Order By ";
		$sSQL .= "	group_prio desc,upd desc,gm.group_no,gm.upddate ";
		$sSQL .= "LIMIT ".($pageno-1)*MAX_GRPPV." , ".MAX_GRPPV;

		$rs = parent::get_rs($sSQL);
		if($rs) {
			$i= 0;
			while( $row = parent::get_row($rs)){
				$aryRes[$i]["group_note"] = gfGetDBFields($row,"group_note"); 
				$aryRes[$i]["group_name"] = gfGetDBFields($row,"group_name"); 
				$aryRes[$i]["group_no"] = gfGetDBFields($row,"group_no"); 
				$aryRes[$i]["group_prio"] = gfGetDBFields($row,"group_prio"); 
				$aryRes[$i]["upd"] = gfGetDBFields($row,"upd"); 
				$aryRes[$i]["assent"] = $this->fGetAssentName(gfGetDBFields($row,"assent_flg"));
				$aryRes[$i]["view"] = $this->fGetViewName(gfGetDBFields($row,"view_flg")); 
				$aryRes[$i]["assent_name"] = gfGetDBFields($row,"assent_flg");
				$aryRes[$i]["view_name"] = gfGetDBFields($row,"view_flg"); 
				$i++;
			}
			parent::free_rs($rs);
		}
		
		return $aryRes;
	}

	private function fGetAssentName($assent_flg) {
		switch($assent_flg){
			case GRP_ASSENT_OK:
				$status = GRP_ASSENT_OK_NAME;
				break;
			case GRP_ASSENT_NG:
				$status = GRP_ASSENT_NG_NAME;
				break;
			default:
				$status = "";
				break;
		}
		return $status;
	}

	private function fGetViewName($view_flg) {
		switch($view_flg){
			case GRP_VIEW_OK:
				$status = GRP_VIEW_OK_NAME;
				break;
			case GRP_VIEW_NG:
				$status = GRP_VIEW_NG_NAME;
				break;
			case GRP_VIEW_GRPONLY:
				$status = GRP_VIEW_GRPONLY_NAME;
				break;
			default:
				$status = "";
				break;
		}
		return $status;
	}
	
	// ページ番号計算処理
	public function GetPageCnt($user_id, $mytaskflg){
		// ページ数の計算
		$iPageAll = 0; // 全ページ数
	
		// ページ数の取得
		$tmpSQL = "";
//		if ($user_id !="" && $mytaskflg=="0") {
		if ($mytaskflg=="0") {
			$tmpSQL .= ", member_tbl mt ";
			$tmpSQL .= "Where ";
			$tmpSQL .= "	gm.group_no = mt.group_no ";
			$tmpSQL .= "	and  mt.user_id =".gfQt($user_id);
		}
		$sSQL = "";
		$sSQL = $sSQL."Select ";
		$sSQL = $sSQL."	count(gm.group_no) cnt ";
		$sSQL = $sSQL."From group_mst gm ";
		$sSQL = $sSQL.$tmpSQL;
	

		$rs = parent::get_rs($sSQL);
		if($rs) {
			while( $row = parent::get_row($rs)){
				$iPageAll = ceil((gfGetDBFields($row,"cnt")/MAX_GRPPV));
			}
			parent::free_rs($rs);
		}
		return $iPageAll;

	}


	// タスクグループを作成する
	public function InsGrpMst($group_name,$group_note,$user_id) {

	
		// タスクグループを追加する。
		$sSQL = "";
		$sSQL = $sSQL."insert into group_mst (";
//		$sSQL = $sSQL."	group_no,";
		$sSQL = $sSQL."	group_name,";
		$sSQL = $sSQL."	group_note,";
		$sSQL = $sSQL."	owneruser,";
		$sSQL = $sSQL."	group_prio,";
		$sSQL = $sSQL."	upddate,";
		$sSQL = $sSQL."	insdate";
		$sSQL = $sSQL.") values (";
//		$sSQL = $sSQL.gfQt($group_no).",";
		$sSQL = $sSQL.gfQt($group_name).",";
		$sSQL = $sSQL.gfQt($group_note).",";
		$sSQL = $sSQL.gfQt($user_id).",";
		$sSQL = $sSQL."1,";
		$sSQL = $sSQL."now(),";
		$sSQL = $sSQL."now()";
		$sSQL = $sSQL.") ";
	
		$res = parent::exec_sql($sSQL);
		if (!$res){
			return $res;
		}

		if (parent::affected_rows() > 0 ) {
			// グループnoを取得する
			$group_no = parent::get_lastid();
			// ログの書き込み
			parent::InsLog($group_no, "" , "",gfPageStr($group_name).GRP_MSG_002 ,TASK_STATUS_MAKE,"");
		} else {
			parent::set_errmsg(GRP_ERR_001);
			return false;
		}
	
		// メンバーを追加する。
		$sSQL = "";
		$sSQL = $sSQL."insert into member_tbl (";
		$sSQL = $sSQL."	group_no,";
		$sSQL = $sSQL."	user_id,";
		$sSQL = $sSQL."	status,";
		$sSQL = $sSQL."	upddate,";
		$sSQL = $sSQL."	insdate";
		$sSQL = $sSQL.") values (";
		$sSQL = $sSQL.gfQt($group_no).",";
		$sSQL = $sSQL.gfQt($user_id).",";
		$sSQL = $sSQL.gfQt(GRPAUTH_ADMIN).",";	// 管理権限
		$sSQL = $sSQL."now(),";
		$sSQL = $sSQL."now()";
		$sSQL = $sSQL.") ";
	
		$res = parent::exec_sql($sSQL);
		if (!$res){
			return $res;
		}
	
		// 新規タスクボックスを追加する。
		$sSQL = "";
		$sSQL = $sSQL."insert into taskbox_mst (";
		$sSQL = $sSQL."	group_no,";
		$sSQL = $sSQL."	taskbox_name,";
		$sSQL = $sSQL."	taskbox_prio,";
		$sSQL = $sSQL."	upddate,";
		$sSQL = $sSQL."	insdate";
		$sSQL = $sSQL.") values (";
		$sSQL = $sSQL.gfQt($group_no).",";
		$sSQL = $sSQL.gfQt(gfFixUpStr(TASKBOX_NAME)).",";
		$sSQL = $sSQL."1,";
		$sSQL = $sSQL."now(),";
		$sSQL = $sSQL."now()";
		$sSQL = $sSQL.") ";
	
		$res = parent::exec_sql($sSQL);
		if (!$res){
			return $res;
		}

		if (parent::affected_rows() > 0 ) {
			// グループnoを取得する
			$taskbox_id = parent::get_lastid();
			// ログの書き込み
			parent::InsLog($group_no, "" ,$taskbox_id ,gfPageStr($group_name).GRP_MSG_002 ,TASK_STATUS_MAKE,"");
		} else {
			parent::set_errmsg(GRP_ERR_005);
			return false;
		}
	
		// 表示状態を追加する。
		$sSQL = "";
		$sSQL = $sSQL."insert into view_mst (";
		$sSQL = $sSQL."	group_no,";
		$sSQL = $sSQL."	upddate,";
		$sSQL = $sSQL."	insdate";
		$sSQL = $sSQL.") values (";
		$sSQL = $sSQL.gfQt($group_no).",";
		$sSQL = $sSQL."now(),";
		$sSQL = $sSQL."now()";
		$sSQL = $sSQL.") ";
	
		$res = parent::exec_sql($sSQL);
		if (!$res){
			return $res;
		}

		return true;
	}

	// グループ管理下のタスクを一括削除する
	public function DelSpanTask($group_no,$delspan) {

		// 削除する予定のタスクに紐づいている画像を削除する
		$sSQL = "";
		$sSQL = $sSQL."Delete from data_tbl where ";
		$sSQL = $sSQL." task_no in (";
		$sSQL = $sSQL."	Select task_no from task_tbl where ";
		$sSQL = $sSQL."	group_no = ".gfQt($group_no);
		$sSQL = $sSQL."	and status = 2 ";		// 終了
		$sSQL = $sSQL."	and (to_days(now()) - to_days(upddate)) >= ".$delspan;
		$sSQL = $sSQL." )";
	
		$res = parent::exec_sql($sSQL);
		if (!$res){
			return $res;
		}
		

		// タスクボックスを削除する。
		$sSQL = "";
		$sSQL = $sSQL."Delete from task_tbl where ";
		$sSQL = $sSQL."	group_no = ".gfQt($group_no);
		$sSQL = $sSQL."	and status = 2 ";		// 終了
		$sSQL = $sSQL."	and (to_days(now()) - to_days(upddate)) >= ".$delspan;

		$res = parent::exec_sql($sSQL);
		if (!$res){
			return $res;
		}
	
		if (parent::affected_rows() > 0 ) {
			// ログの書き込み
			parent::InsLog($group_no, "" , "" ,GRP_MSG_006_1.$delspan.GRP_MSG_006_2 ,TASK_STATUS_SPANDEL,"");
		}
		return true;
	}

	// メンバー情報更新処理
	public function UpdMemberTbl($group_no,$userid,$status) {
	
		// 表示状態を更新する。
		$sSQL = "";
		$sSQL = $sSQL."Update member_tbl set ";
		$sSQL = $sSQL."	 status = ".gfQt($status);
		$sSQL = $sSQL."	 ,upddate= now() ";
		$sSQL = $sSQL."where ";
		$sSQL = $sSQL."	 group_no= ".gfQt($group_no);
		$sSQL = $sSQL."	 and user_id = ".gfQt($userid);
		$sSQL = $sSQL."	 and status <> ".gfQt(GRPAUTH_ADMIN);
		$sSQL = $sSQL."	 and status <> ".gfQt($status);
	
		$res = parent::exec_sql($sSQL);
		if (!$res){
			return $res;
		}
	
		if (parent::affected_rows() > 0 ) {
			// ログの書き込み
			parent::InsLog($group_no, "" , "" ,GRP_MSG_009 ,TASK_STATUS_GRPUPD,"");
		}
		return true;
	}
	
	// グループ情報更新処理
	public function UpdGrpInfo($group_no,$aryGrpInfo) {
		// 表示状態を更新する。
		$sSQL = "";
		$sSQL = $sSQL."Update group_mst set ";
		$sSQL = $sSQL."	 group_name= ".gfQt($aryGrpInfo['group_name']);
		$sSQL = $sSQL."	 ,group_note= ".gfQt($aryGrpInfo['group_note']);
		$sSQL = $sSQL."	 ,group_prio= ".gfQt($aryGrpInfo['group_prio']);
		$sSQL = $sSQL."	 ,upddate= now() ";
		$sSQL = $sSQL."where ";
		$sSQL = $sSQL."	 group_no= ".gfQt($group_no);
	
		$res = parent::exec_sql($sSQL);
		if (!$res){
			return $res;
		}
		if (parent::affected_rows() > 0 ) {
			// ログの書き込み
			parent::InsLog($group_no, "" , "" ,$aryGrpInfo['group_name'] ,TASK_STATUS_GRPINFO_UPD,"");
		}
		return true;
	}
	
	// ビューモード更新処理
	public function UpdViewMode($group_no,$aryMode) {
	
		// 表示状態を更新する。
		$sSQL = "";
		$sSQL = $sSQL."Update view_mst set ";
		$sSQL = $sSQL."	 assent_flg= ".gfQt($aryMode['assent_flg']);
		$sSQL = $sSQL."	 ,priority_flg= ".gfQt($aryMode['priority_flg']);
		$sSQL = $sSQL."	 ,view_flg= ".gfQt($aryMode['view_flg']);
		$sSQL = $sSQL."	 ,limit_flg= ".gfQt($aryMode['limit_flg']);
		$sSQL = $sSQL."	 ,gains_flg= ".gfQt($aryMode['gains_flg']);
		$sSQL = $sSQL."	 ,do_user_flg= ".gfQt($aryMode['do_user_flg']);
		$sSQL = $sSQL."	 ,add_user_flg= ".gfQt($aryMode['add_user_flg']);
		$sSQL = $sSQL."	 ,fintask_flg= ".gfQt($aryMode['fintask_flg']);
		$sSQL = $sSQL."	 ,staytask_flg= ".gfQt($aryMode['staytask_flg']);
		$sSQL = $sSQL."	 ,detail_flg= ".gfQt($aryMode['detail_flg']);
		$sSQL = $sSQL."	 ,grpmail_flg= ".gfQt($aryMode['grpmail_flg']);
		$sSQL = $sSQL."	 ,grpfile_flg= ".gfQt($aryMode['grpfile_flg']);
		$sSQL = $sSQL."	 ,grpcmnt_flg= ".gfQt($aryMode['grpcmnt_flg']);
		$sSQL = $sSQL."	 ,grpcmntcnt_flg= ".gfQt($aryMode['grpcmntcnt_flg']);
		$sSQL = $sSQL."	 ,taskvolume_flg= ".gfQt($aryMode['taskvolume_flg']);
		$sSQL = $sSQL."	 ,approval_flg= ".gfQt($aryMode['approval_flg']);
		$sSQL = $sSQL."	 ,alert_flg= ".gfQt($aryMode['alert_flg']);
		$sSQL = $sSQL."	 ,alert1_days= ".gfQt($aryMode['alert1_days']);
		$sSQL = $sSQL."	 ,alert2_days= ".gfQt($aryMode['alert2_days']);
		$sSQL = $sSQL."	 ,delauth_flg= ".gfQt($aryMode['delauth_flg']);
		$sSQL = $sSQL."	 ,group_msg= ".gfQt($aryMode['group_msg']);
		$sSQL = $sSQL."	 ,taskboxmax= ".gfQt($aryMode['taskboxmax']);
		$sSQL = $sSQL."	 ,pagemax= ".gfQt($aryMode['pagemax']);
		$sSQL = $sSQL."	 ,upddate= now() ";
		$sSQL = $sSQL."where ";
		$sSQL = $sSQL."	 group_no= ".gfQt($group_no);
	
		$res = parent::exec_sql($sSQL);
		if (!$res){
			return $res;
		}
	
		if (parent::affected_rows() > 0 ) {
			// ログの書き込み
			parent::InsLog($group_no, "" , "" ,GRP_MSG_010 ,TASK_STATUS_VIWEUPD,"");
		}
		return true;
	}
	
	
	// タスクボックス削除処理
	public function DelTaskbox($group_no,$aryId,$aryName) {
		foreach ($aryId as $key => $val) {
			$aryId[$key] = gfQt($val);
		}
		$boxid = implode($aryId,",");
		$boxname = implode($aryName," ");

		// 削除する予定のタスクにボックス紐づいている画像を削除する
		$sSQL = "";
		$sSQL = $sSQL."Delete from data_tbl where ";
		$sSQL = $sSQL." task_no in (";
		$sSQL = $sSQL."	Select task_no from task_tbl where ";
		$sSQL = $sSQL."	group_no = ".gfQt($group_no);
		$sSQL = $sSQL."	and taskbox_id in (".$boxid.")";
		$sSQL = $sSQL." )";
	
		$res = parent::exec_sql($sSQL);
		if (!$res){
			return $res;
		}


		// タスクボックスを削除する。
		$sSQL = "";
		$sSQL = $sSQL."Delete from taskbox_mst where ";
		$sSQL = $sSQL."	group_no = ".gfQt($group_no);
		$sSQL = $sSQL."	and taskbox_id in (".$boxid.") ";
	
		$res = parent::exec_sql($sSQL);
		if (!$res){
			return $res;
		}
	
		if (parent::affected_rows() > 0 ) {
			// ログの書き込み
			parent::InsLog($group_no, "" , "" ,$boxname.GRP_MSG_012 ,TASK_STATUS_BOXDROP,"");
		}
	
		// タスクボックスに紐付くタスクをすべて削除する
		$sSQL = "";
		$sSQL = $sSQL."Delete from task_tbl where ";
		$sSQL = $sSQL."	group_no = ".gfQt($group_no);
		$sSQL = $sSQL."	and taskbox_id in (".$boxid.")";
		
		$res = parent::exec_sql($sSQL);
		if (!$res){
			return $res;
		}
	
		if (parent::affected_rows() > 0 ) {
			// ログの書き込み
			parent::InsLog($group_no, "" , "" ,$boxname.GRP_MSG_013 ,TASK_STATUS_BOXDROP,"");
		}

		return true;
	}
	
	// タスクボックス更新処理
	public function UpdTaskbox($group_no,$aryBox) {
	
		// タスクボックスを更新する。
		$sSQL = "";
		$sSQL = $sSQL."Update taskbox_mst set ";
		$sSQL = $sSQL."	 taskbox_name= ".gfQt($aryBox['taskbox_name']);
		$sSQL = $sSQL."	 ,taskbox_prio= ".gfQt($aryBox['taskbox_prio']);
		$sSQL = $sSQL."	 ,mailsend_flg= ".gfQt($aryBox['mailsend_flg']);
		$sSQL = $sSQL."	 ,upddate= now() ";
		$sSQL = $sSQL."where ";
		$sSQL = $sSQL."	 group_no= ".gfQt($group_no);
		$sSQL = $sSQL."	 and taskbox_id= ".gfQt($aryBox['taskbox_id']);

		$res = parent::exec_sql($sSQL);
		if (!$res){
			return $res;
		}
	
		if (parent::affected_rows() > 0 ) {
			// ログの書き込み
			parent::InsLog($group_no, "" , "" ,$aryBox['taskbox_name'].GRP_MSG_011 ,TASK_STATUS_BOXUPD,"");
		}

		return true;
	}

	// タスクボックス新規登録処理
	public function InsTaskbox($group_no,$aryBox) {
	
		// タスクボックスを更新する。
		$sSQL = "";
		$sSQL = $sSQL."insert into taskbox_mst (";
		$sSQL = $sSQL."	group_no,";
		$sSQL = $sSQL."	taskbox_name,";
		$sSQL = $sSQL."	taskbox_prio,";
		$sSQL = $sSQL."	mailsend_flg,";
		$sSQL = $sSQL."	upddate,";
		$sSQL = $sSQL."	insdate";
		$sSQL = $sSQL.") values (";
		$sSQL = $sSQL.gfQt($group_no).",";
		$sSQL = $sSQL.gfQt($aryBox['taskbox_name']).",";
		$sSQL = $sSQL.gfQt($aryBox['taskbox_prio']).",";
		$sSQL = $sSQL.gfQt($aryBox['mailsend_flg']).",";
		$sSQL = $sSQL."now(),";
		$sSQL = $sSQL."now()";
		$sSQL = $sSQL.") ";
//		$sSQL = $sSQL."ON DUPLICATE KEY UPDATE ";

		$res = parent::exec_sql($sSQL);
		if (!$res){
			return $res;
		}
	
		if (parent::affected_rows() > 0 ) {
			// ログの書き込み
			parent::InsLog($group_no, "" , "" ,$aryBox['taskbox_name'].GRP_MSG_014 ,TASK_STATUS_BOXUPD,"");
		}
		return true;
	}
	
	//メンバーテーブルにユーザーを追加する
	public function InsMemberTbl($group_no,$user_id,$user_name,$assent_flg) {
		// メンバーを追加する。
		$sSQL = "";
		$sSQL = $sSQL."insert into member_tbl (";
		$sSQL = $sSQL."	group_no,";
		$sSQL = $sSQL."	user_id,";
		$sSQL = $sSQL."	status,";
		$sSQL = $sSQL."	upddate,";
		$sSQL = $sSQL."	insdate";
		$sSQL = $sSQL.") values (";
		$sSQL = $sSQL.gfQt($group_no).",";
		$sSQL = $sSQL.gfQt($user_id).",";
		$sSQL = $sSQL.gfQt($assent_flg).",";
		$sSQL = $sSQL."now(),";
		$sSQL = $sSQL."now()";
		$sSQL = $sSQL.") ";

		$res = parent::exec_sql($sSQL);
		if (!$res){
			return $res;
		}
	
		if (parent::affected_rows() > 0 ) {
			// ログの書き込み
			parent::InsLog($group_no, "" , "" ,$user_name.GRP_MSG_015 ,TASK_STATUS_GRPJOIN,"");
		}
		return true;
	}

	// 担当者の取得
	public function GetGrpAdminMember($group_no) {
		$aryRes = array();

		// 管理ユーザをメンバーリストから取得
		$sSQL = "";
		$sSQL = $sSQL."Select ";
		$sSQL = $sSQL."	um.user_id, ";
		$sSQL = $sSQL."	um.user_name, ";
		$sSQL = $sSQL."	um.user_mail ";
		$sSQL = $sSQL."From user_mst um,";
		$sSQL = $sSQL."	member_tbl mt ";
		$sSQL = $sSQL."Where ";
		$sSQL = $sSQL."	um.user_id = mt.user_id  ";
		$sSQL = $sSQL."	and mt.group_no=".gfQt($group_no);
		$sSQL = $sSQL."	and mt.status >=".gfQt(GRPAUTH_MADMIN);

		$rs = parent::get_rs($sSQL);
		if($rs) {
			$i=0;
			while( $row = parent::get_row($rs)){
				$aryRes[$i]["user_id"] = gfGetDBFields($row,"user_id"); 
				$aryRes[$i]["user_name"] = gfGetDBFields($row,"user_name"); 
				$aryRes[$i]["user_mail"] = gfGetDBFields($row,"user_mail"); 
				$i++;
			}
			parent::free_rs($rs);
		}
		return $aryRes;
	}


}
?>