<?php
	require_once('./config.inc.php');
	require_once(TODOTASK_CTRL_DIR.'/task.class.php');
	// ページロード
	$page = gfPageLoad();

	$page->group_no = gfIssetPOST('group_no',""); 
	// タスクボックスID
	$page->taskbox_id = gfIssetPOST('taskboxid',""); 
	// タスクボックスNO
	$page->task_no = gfIssetPOST('taskno',""); 
	// 進捗度
	$gains = gfIssetPOST('gains',""); 
	// タスクステータス
	$status = gfIssetPOST('status',""); 
	// 優先度
	$priority = gfIssetPOST('priority',""); 
	// 編集モードの確認  1:状態の更新 2:ステータスの更新 3:進捗の更新
	$page->mode = gfIssetPOST('mode',TASK_CLASS_MODE_STATUSUP); 
	$page->csrf = gfIssetPOST('csrf',""); 	 //CSRF対策

	// check page parameter
	$page->chkPage();

	// 数値型の確認
	gfChkNum($gains,"0");
	gfChkNum($status,"0");
	gfChkNum($priority,"1");
	gfChkMaxMin($gains,"0","100");
	gfChkMaxMin($priority,"1",TASK_PRIORITY_MAX);


	// 更新モードの確認
	if ($page->mode != TASK_CLASS_MODE_GAINUP 
			&& $page->mode != TASK_CLASS_MODE_STATUSUP 
			&& $page->mode != TASK_CLASS_MODE_PRIORITYUP){
		exit;
	}

	// ログイン確認
	$objTask = new Task();
	$page->user_name = $objTask->get_loginname(); 
	$page->user_id = $objTask->get_loginid(); 

	// ログイン状態の確認
	if (!$objTask->ChkLogin()) {
		exit;
	}

	// 取得したグループが存在するか確認
	if (!$objTask->ChkGroupMst($page->group_no,$page->taskbox_id)) {
		exit;
	}

	// パラメーターの確認
	if ($page->csrf != sha1($page->user_id.$page->task_no.CSRF_SEED)) {
		exit;
	}


	// メンバーチェック(参照しようとしているタスクのメンバーに登録されているか)
	$page->memLv = $objTask->ChkMember($page->group_no,$page->user_id);
	// メンバーに所属しているか
	if ($page->memLv < GRPAUTH_MEM) {
		exit;
	}

	// 特定タスクの呼び出し
	$aryTask = $objTask->GetTaskForEdit($page->group_no,$page->taskbox_id,$page->task_no);
	$note = $aryTask['note'];

	// 表示モードの取得
	$page->aryViewMode = $objTask->GetViewMode($page->group_no ,$page->gmode);

	$sResEnd = "";				// 終了時メッセージ
	// トランザクション発行
	$retDel = $objTask->begin_trans();
	if ($status == TASK_STATUS_DEL) {
		// タスク削除権限の確認
		if ($page->aryViewMode["delauth_flg"]==DELL_AUTH 
			&& $page->memLv < GRPAUTH_MADMIN 
			&& $aryTask['add_user_id'] != $page->user_id){

			// 削除権限なし
			$sResEnd = "";	// 失敗
		} else {
			// タスク破棄処理
			if ($objTask->DelTask($page->group_no ,$page->taskbox_id ,$page->task_no ,$status ,$note )) {
				$sResEnd = TASK_STATUS_DEL; 
			}
		}
	} else {
		// 更新処理
		$sResEnd = $objTask->UpdTaskAjax($page->user_id ,$page->group_no ,$page->taskbox_id ,$page->task_no ,$page->mode ,$gains ,$status ,$priority ,$note);
	}
	if ($sResEnd=="") {
		$retDel = false;
	} else {
		$retDel = true;
	}
	// コミット|ロールバック
	$objTask->commit_trans($retDel);


	// テキストの吐き出し
	echo($sResEnd);

	// ページ終了処理
	gfPageUnLoad();
?>