package jp.snowgoose.treno.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import jp.snowgoose.treno.Constants;
import jp.snowgoose.treno.result.type.DirectionType;
import jp.snowgoose.treno.result.type.Forward;

/**
 * @author snowgoose
 */
@Retention(RetentionPolicy.RUNTIME)
@Target( { ElementType.ANNOTATION_TYPE })
public @interface Direction {

    String when() default Constants.SUCCESS;

    String to() default "";

    Class<? extends DirectionType> type() default Forward.class;

    Arg[] args() default {};

}
