package jp.snowgoose.treno.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import javax.servlet.FilterConfig;

import jp.snowgoose.treno.Constants;
import jp.snowgoose.treno.component.SimpleInstanceProvider;
import jp.snowgoose.treno.metadata.Suffix;
import jp.snowgoose.treno.util.Assertion;
import jp.snowgoose.treno.util.StringUtils;

/**
 * @author snowgoose
 */
public class WebConfig implements Config {

    private static final String DEFAULT_COMPONENT_PACKAGENAME = "jp.snowgoose.treno";
    private static final String DEFAULT_ACTION_FACTORY_ID = "annotation";
    private FilterConfig filterConfig;
    private List<String> actionPackageNames;
    private List<String> componentsPackageNames;
    private String actionInstanceProviderClassName;
    private String actionFactoryId;
    private String componentInstanceProviderClassName;
    private Suffix suffix;

    public WebConfig(FilterConfig filterConfig) {
        Assertion.notNull(filterConfig, "FilterConfig");
        this.filterConfig = filterConfig;
        actionPackageNames = getActionPackageNames(filterConfig
                .getInitParameter(Constants.INIT_PARAMETER_ACTION_PACKAGES_ROOT));
        actionFactoryId = getInitParameter0(filterConfig,
                Constants.INIT_PARAMETER_ACTION_FACTORY_ID, DEFAULT_ACTION_FACTORY_ID);
        componentsPackageNames = getComponentPackageNames(filterConfig
                .getInitParameter(Constants.INIT_PARAMETER_COMPONENTS_PACKAGES_ROOT));
        suffix = initSuffix(filterConfig.getInitParameter(Constants.INIT_PARAMETER_ACTION_SUFFIX));
        actionInstanceProviderClassName = getInitParameter0(filterConfig,
                Constants.INIT_PARAMETER_ACTION_PROVIDER, SimpleInstanceProvider.class
                        .getCanonicalName());
        componentInstanceProviderClassName = getInitParameter0(filterConfig,
                Constants.INIT_PARAMETER_COMPONENTS_PROVIDER, SimpleInstanceProvider.class
                        .getCanonicalName());
    }

    private String getInitParameter0(FilterConfig config, String parameter, String defaultValue) {
        String value = config.getInitParameter(parameter);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        } else {
            return value;
        }
    }

    protected List<String> getActionPackageNames(String names) {
        Assertion.notNull(names, "action package names");
        return getPackageNames0(names);
    }

    protected List<String> getComponentPackageNames(String names) {
        List<String> packageNames = new ArrayList<String>();
        packageNames.addAll(getPackageNames0(names));
        if (packageNames.isEmpty()) {
            packageNames.add(DEFAULT_COMPONENT_PACKAGENAME);
        }
        return packageNames;
    }

    protected List<String> getPackageNames0(String names) {
        if (names != null) {
            return Arrays.asList(names.split(","));
        }
        return Collections.emptyList();
    }

    protected Suffix initSuffix(String suffixName) {
        if (StringUtils.isEmpty(suffixName)) {
            return Suffix.DEFAULT;
        } else {
            return new Suffix(suffixName);
        }
    }

    public List<String> getActionPackageNames() {
        return actionPackageNames;
    }

    public List<String> getComponentPackageNames() {
        return componentsPackageNames;
    }

    public Suffix getSuffix() {
        return suffix;
    }

    public String getActionInstanceProviderClassName() {
        return actionInstanceProviderClassName;
    }

    public String getComponentInstanceProviderClassName() {
        return componentInstanceProviderClassName;
    }

    public String getActionDescriptorFactoryId() {
        return actionFactoryId;
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }
}
