package jp.snowgoose.treno.context;

import javax.servlet.http.HttpServletRequest;

/**
 * @author snowgoose
 */
public abstract class AbstractRequestValueMapper implements RequestValueMapper {

    private RequestContext requestContext;
    private ParameterConverters parameterConverters;

    public AbstractRequestValueMapper(RequestContext context, ParameterConverters converters) {
        requestContext = context;
        parameterConverters = converters;
    }

    public HttpServletRequest getRequest() {
        return getRequestContext().getRequest();
    }

    protected RequestContext getRequestContext() {
        return this.requestContext;
    }

    public ParameterConverters getParameterConverters() {
        return this.parameterConverters;
    }

    public void setParameterConverters(ParameterConverters converters) {
        this.parameterConverters = converters;
    }

}
