package jp.snowgoose.treno.exception;

import jp.snowgoose.treno.metadata.MappedPath;
import jp.snowgoose.treno.util.SerializationUtils;

/**
 * @author snowgoose
 */
public class ActionNotFoundException extends RenoException {

    /** TODO : default uid. */
    private static final long serialVersionUID = 1L;
    private static final String messageKey = "no action found on %s.";
    private final String[] args;

    public ActionNotFoundException(MappedPath mappedPath) {
        args = new String[] { mappedPath.getPath() };
    }

    @Override
    public Object[] getMessageArgs() {
        return SerializationUtils.clone(args);
    }

    @Override
    public String getMessageKey() {
        return messageKey;
    }

}
