package jp.snowgoose.treno.exception;

import jp.snowgoose.treno.metadata.ResultDescriptor;
import jp.snowgoose.treno.util.SerializationUtils;

/**
 * @author snowgoose
 */
public class ResultEvaluationFailureException extends RenoException {

    /** TODO :default uid. */
    private static final long serialVersionUID = 1L;
    private static final String messageKey = "result evaluation failure at %s : %s";
    private final String[] messageArgs;

    public ResultEvaluationFailureException(Throwable e, ResultDescriptor resultDescriptor) {
        super(e);
        messageArgs = new String[] { resultDescriptor.getWhen(), resultDescriptor.getTo(),
                resultDescriptor.getResultType().getName() };
    }

    @Override
    public Object[] getMessageArgs() {
        return SerializationUtils.clone(messageArgs);
    }

    @Override
    public String getMessageKey() {
        return messageKey;
    }

}
