package jp.snowgoose.treno.metadata;

import java.io.Serializable;

import jp.snowgoose.treno.context.ParameterConverter;
import jp.snowgoose.treno.metadata.BindDescriptor.BindElementType.BindType;

public class BindDescriptor implements Serializable {

    /** TODO : default uid. */
    private static final long serialVersionUID = 1L;
    protected String name;
    protected Class<?> parameterType;
    protected BindElementType bindElementType;
    protected Scope scope;
    protected String format;
    protected Class<? extends ParameterConverter> converterType;

    public String getName() {
        return name;
    }

    public Class<?> getParameterType() {
        return parameterType;
    }

    public BindElementType getBindElementType() {
        return bindElementType;
    }

    public Scope getScope() {
        return scope;
    }

    public String getFormat() {
        return format;
    }

    public Class<? extends ParameterConverter> getConverterType() {
        return converterType;
    }

    public static interface BindElementType extends Serializable {

        BindType getType();

        public static class MethodBindElement implements BindElementType {
            /** TODO : default uid. */
            private static final long serialVersionUID = 1L;
            private final String methodName;

            public MethodBindElement(String methodName) {
                this.methodName = methodName;
            }

            public String getMethodName() {
                return methodName;
            }

            public final BindType getType() {
                return BindType.METHOD;
            }
        }

        public static class ParameterBindElement implements BindElementType {
            /** TODO : default uid. */
            private static final long serialVersionUID = 1L;
            private final int index;

            public final BindType getType() {
                return BindType.PARAMETER;
            }

            public ParameterBindElement(int index) {
                this.index = index;
            }

            public int getIndex() {
                return this.index;
            }

        }

        public static class TypeBindElement implements BindElementType {
            /** TODO : default uid. */
            private static final long serialVersionUID = 1L;
            private final Class<?> type;

            public final BindType getType() {
                return BindType.TYPE;
            }

            public TypeBindElement(Class<?> type) {
                this.type = type;
            }

            public Class<?> getTypeClass() {
                return this.type;
            }

        }

        public static class FieldBindElement implements BindElementType {
            /** TODO : default uid. */
            private static final long serialVersionUID = 1L;
            private final int modefiers;
            private String fieldName;

            public final BindType getType() {
                return BindType.FIELD;
            }

            public FieldBindElement(int modefiers, String fieldName) {
                this.modefiers = modefiers;
                this.fieldName = fieldName;
            }

            public int getModefier() {
                return this.modefiers;
            }

            public String getFieldName() {
                return this.fieldName;
            }

        }

        enum BindType {
            PARAMETER, METHOD, TYPE, FIELD;
        }
    }

    public boolean bindTypeIs(BindType elementType) {
        return getBindElementType().getType().equals(elementType);
    }

}
