package jp.snowgoose.treno.metadata;

import java.io.Serializable;

import jp.snowgoose.treno.util.Assertion;

/**
 * @author snowgoose
 */
public class MappedPath implements Serializable {

    /** TODO : default uid. */
    private static final long serialVersionUID = 1L;
    private final String path;

    public MappedPath(String path) {
        Assertion.notNull(path, "mappedPath");
        this.path = path;
    }

    public MappedPath(String root, String path) {
        String editedRoot = root;
        if (editedRoot.lastIndexOf('*') == editedRoot.length() - 1) {
            editedRoot = editedRoot.substring(0, editedRoot.length() - 1);
        }
        if (editedRoot.lastIndexOf('/') == editedRoot.length() - 1) {
            editedRoot = editedRoot.substring(0, editedRoot.length() - 1);
        }
        String editedPath = path;
        if (editedPath.indexOf('/') != 0) {
            editedPath = '/' + path;
        }
        this.path = editedRoot + editedPath;
    }

    public String getPath() {
        return path;
    }

    @Override
    public boolean equals(Object other) {
        if (path == null) {
            return false;
        }
        if (other instanceof MappedPath) {
            MappedPath otherMappedPath = MappedPath.class.cast(other);
            return path.equals(otherMappedPath.path);
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        if (path == null) {
            return 0;
        }
        return path.hashCode();
    }

}
