package jp.snowgoose.treno.result.type;

import java.util.Collection;
import java.util.Map;

import jp.snowgoose.treno.util.Maps;

/**
 * @author snowgoose
 */
public class DirectionTypes {

    private final Map<Class<? extends DirectionType>, DirectionType> resultTypesMap = Maps
            .newLinkedHashMap();

    public DirectionTypes(Collection<DirectionType> resultTypes) {
        for (DirectionType resultType : resultTypes) {
            register(resultType);
        }
    }

    public DirectionType getResultType(Class<? extends DirectionType> clazz) {
        return resultTypesMap.get(clazz);
    }

    public void register(DirectionType resultType) {
        if (resultType != null) {
            resultTypesMap.put(resultType.getClass(), resultType);
        }
    }

    public int size() {
        return resultTypesMap.size();
    }

}
