package jp.snowgoose.treno.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/**
 * @author snowgoose
 */
public final class ClassUtils {

    private ClassUtils() {
        // may not instanticate this class.
    }

    public static Class<?> forNameSilentry(String canonicalName) {
        try {
            return Class.forName(canonicalName);
        } catch (ClassNotFoundException ignore) {
            return null;
        }
    }

    public static <T> T newInstanceSilentry(Class<T> clazz, Object[] args) {
        try {
            Constructor<T> constractor = clazz.getConstructor(getTypes(args));
            return constractor.newInstance(args);
        } catch (IllegalAccessException e) {
            return null;
        } catch (IllegalArgumentException e) {
            return null;
        } catch (InstantiationException e) {
            return null;
        } catch (InvocationTargetException e) {
            return null;
        } catch (SecurityException e) {
            return null;
        } catch (NoSuchMethodException e) {
            return null;
        }
    }

    @SuppressWarnings("unchecked")
    public static <T> T newInstanceSilentry(String className, Object[] args) {
        return (T) newInstanceSilentry(forNameSilentry(className), null);
    }

    public static Class<?>[] getTypes(Object[] instances) {
        if (ArrayUtils.isEmpty(instances)) {
            return new Class<?>[0];
        }
        List<Class<?>> types = new ArrayList<Class<?>>();
        for (Object obj : instances) {
            types.add(obj.getClass());
        }
        return types.toArray(new Class<?>[types.size()]);
    }

    public static Method getReadMethodSilentry(Class<?> type, String name) {
        try {
            String methodName = "get" + name.substring(0, 1).toUpperCase(Locale.getDefault())
                    + name.substring(1);
            return type.getMethod(methodName, new Class<?>[0]);
        } catch (SecurityException e) {
            return null;
        } catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getWriteMethodSilentry(Class<?> type, Class<?> parameterType, String name) {
        try {
            String methodName = "set" + name.substring(0, 1).toUpperCase(Locale.getDefault())
                    + name.substring(1);
            return type.getMethod(methodName, parameterType);
        } catch (SecurityException e) {
            return null;
        } catch (NoSuchMethodException e) {
            return null;
        }
    }

}
