package jp.snowgoose.treno.util;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import jp.snowgoose.treno.Constants;
import jp.snowgoose.treno.util.ResourceUtils.FindResourceStrategies;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author snowgoose
 */
public class FileClassCollector implements ClassCollector {

    private static final Logger log = LoggerFactory.getLogger(FileClassCollector.class);

    @SuppressWarnings("unchecked")
    public Collection<Class> collect(final String packageName, final URL url) {
        if (packageName == null || url == null || url.getProtocol().equals("file") == false) {
            return Collections.EMPTY_LIST;
        }
        File root;
        // try {
        root = new File(url.getPath());
        // root = new File(url.toURI());
        // } catch (URISyntaxException e) {
        // root = new File(url.getPath());
        // }
        Set<Class> classes = new HashSet<Class>();
        final File[] files = root.listFiles();
        for (File file : files) {
            final String fileName = file.getName();
            if (file.isDirectory()) {
                String newPackageName = packageName + "." + fileName;
                classes.addAll(collect(newPackageName, ResourceUtils.findResource('/' + file
                        .getPath(), Arrays.asList(FindResourceStrategies.FILE))));
            } else if (fileName.endsWith(Constants.CLASS_SUFFIX)) {
                final String shortClassName = fileName.substring(0, fileName.length()
                        - Constants.CLASS_SUFFIX.length());
                Class clazz = ClassUtils.forNameSilentry(packageName + "." + shortClassName);
                if (log.isDebugEnabled()) {
                    log.debug("adding found class resource : " + clazz);
                }
                classes.add(clazz);
            }
        }
        return classes;
    }

}
