package jp.snowgoose.treno.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtils {

    private IOUtils() {
        // not be instantiate this class.
    }

    public static <T extends Closeable> boolean closeSilently(T closable) {
        if (closable != null) {
            try {
                closable.close();
                return true;
            } catch (IOException e) {
                return false;
            }
        } else {
            return false;
        }
    }

    public static void writeAndFlush(OutputStream out, InputStream in) throws IOException {
        int i;
        while ((i = in.read()) > 0) {
            out.write(i);
        }
        out.flush();
    }

}
