package jp.snowgoose.treno.util;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

import jp.snowgoose.treno.Constants;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author snowgoose
 */
public class JarClassCollector implements ClassCollector {

    private static final Logger log = LoggerFactory.getLogger(JarClassCollector.class);

    @SuppressWarnings("unchecked")
    public Collection<Class> collect(String packageName, URL source) {
        if (source == null || source.getProtocol().equals("jar") == false || packageName == null) {
            return Collections.EMPTY_LIST;
        }
        JarFile jarFile;
        try {
            JarURLConnection connection = (JarURLConnection) source.openConnection();
            jarFile = connection.getJarFile();
        } catch (IOException ignore) {
            return Collections.emptyList();
        }
        Set<Class> collectedClasses = new HashSet<Class>();
        final Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            final JarEntry entry = enumeration.nextElement();
            final String entryName = entry.getName().replace('\\', '/');
            if (entryName.endsWith(Constants.CLASS_SUFFIX)) {
                final String className = entryName.substring(0,
                        entryName.length() - Constants.CLASS_SUFFIX.length()).replace('/', '.');
                final int pos = className.lastIndexOf('.');
                final String detectedPackageName = (pos == -1) ? null : className.substring(0, pos);
                final String shortClassName = (pos == -1) ? className : className
                        .substring(pos + 1);
                if (detectedPackageName != null && detectedPackageName.contains(packageName)) {
                    Class clazz = ClassUtils.forNameSilentry(detectedPackageName + "."
                            + shortClassName);
                    if (log.isDebugEnabled()) {
                        log.debug("adding found class resource : " + clazz);
                    }
                    collectedClasses.add(clazz);
                }
            }
        }
        return collectedClasses;
    }

}
