package jp.snowgoose.treno.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SerializationUtils {

    private SerializationUtils() {
        // not be instantiate this class.
    }

    public static <T extends Serializable> T clone(T obj) {
        return clone(obj, true);
    }

    @SuppressWarnings("unchecked")
    public static <T extends Serializable> T clone(T obj, boolean resetOutputStreeam) {
        if (obj == null) {
            return null;
        }
        ObjectOutputStream oout = null;
        ObjectInputStream oin = null;
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            oout = new ObjectOutputStream(bout);
            oout.writeObject(obj);
            ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
            oin = new ObjectInputStream(bin);
            return (T) oin.readObject();
        } catch (ClassNotFoundException e) {
            // ignore
            return null;
        } catch (IOException e) {
            // ignore
            return null;
        } finally {
            if (resetOutputStreeam) {
                resetOutputStreeam(oout);
            }
            IOUtils.closeSilently(oout);
            IOUtils.closeSilently(oin);
        }
    }

    private static boolean resetOutputStreeam(ObjectOutputStream oout) {
        try {
            oout.reset();
            return true;
        } catch (IOException e) {
            return false;
        }
    }

}
